/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.javafile.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AnnotationMetadata {
    private String annotationClassName;
    private Map<String, String> memberValues = new HashMap<String, String>();
    private Type type;

    private AnnotationMetadata(Type type, String annotationClassName, Map<String, String> memberValues) {
        this.type = type;
        this.annotationClassName = annotationClassName;
        this.memberValues = memberValues != null ? memberValues : Collections.emptyMap();
    }

    public String getName() {
        return this.annotationClassName;
    }

    public Map<String, String> getMemberValues() {
        return Collections.unmodifiableMap(this.memberValues);
    }

    public Type getType() {
        return this.type;
    }

    public static AnnotationMetadata markerAnnotation(String annotationClassName) {
        return new AnnotationMetadata(Type.MARKER, annotationClassName, null);
    }

    public static AnnotationMetadata normalAnnotation(String annotationClassName, Map<String, String> memberValues) {
        return new AnnotationMetadata(Type.NORMAL, annotationClassName, memberValues);
    }

    public static AnnotationMetadata singleMemberAnnotation(String annotationClassName, String value) {
        HashMap<String, String> memberValues = new HashMap<String, String>(1);
        memberValues.put(null, value);
        return new AnnotationMetadata(Type.SINGLE_MEMBER, annotationClassName, memberValues);
    }

    public static enum Type {
        MARKER,
        NORMAL,
        SINGLE_MEMBER;

    }
}

