/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.classfile.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.sequencer.classfile.metadata.AnnotationMetadata;
import org.modeshape.sequencer.classfile.metadata.FieldMetadata;
import org.modeshape.sequencer.classfile.metadata.MethodMetadata;
import org.modeshape.sequencer.classfile.metadata.Visibility;
import org.modeshape.sequencer.javafile.metadata.ImportMetadata;

@Immutable
public class ClassMetadata {
    private static final String JAVA_LANG_PKG = "java.lang.";
    private final ClassFile clazz;
    private final List<AnnotationMetadata> annotations;
    private final List<FieldMetadata> fields;
    private final List<MethodMetadata> methods;
    private final List<MethodMetadata> constructors;
    private final List<ImportMetadata> imports;

    ClassMetadata(ClassFile clazz) {
        this.clazz = clazz;
        this.annotations = this.annotationsFor(clazz);
        this.fields = this.fieldsFor(clazz);
        this.methods = this.methodsFor(clazz);
        this.constructors = this.constructorsFor(clazz);
        this.imports = this.importsFor(clazz);
    }

    private List<AnnotationMetadata> annotationsFor(ClassFile clazz) {
        LinkedList<AnnotationMetadata> annotations = new LinkedList<AnnotationMetadata>();
        for (Object ob : clazz.getAttributes()) {
            AttributeInfo att = (AttributeInfo)ob;
            if (!(att instanceof AnnotationsAttribute)) continue;
            for (Annotation ann : ((AnnotationsAttribute)att).getAnnotations()) {
                annotations.add(new AnnotationMetadata(ann));
            }
        }
        return Collections.unmodifiableList(annotations);
    }

    private List<FieldMetadata> fieldsFor(ClassFile clazz) {
        LinkedList<FieldMetadata> fields = new LinkedList<FieldMetadata>();
        for (Object field : clazz.getFields()) {
            fields.add(new FieldMetadata((FieldInfo)field));
        }
        Collections.sort(fields);
        return Collections.unmodifiableList(fields);
    }

    private List<MethodMetadata> methodsFor(ClassFile clazz) {
        LinkedList<MethodMetadata> methods = new LinkedList<MethodMetadata>();
        for (Object ob : clazz.getMethods()) {
            MethodInfo method = (MethodInfo)ob;
            if (method.isStaticInitializer() || method.isConstructor()) continue;
            methods.add(new MethodMetadata(clazz, method));
        }
        Collections.sort(methods);
        return Collections.unmodifiableList(methods);
    }

    private List<MethodMetadata> constructorsFor(ClassFile clazz) {
        LinkedList<MethodMetadata> ctors = new LinkedList<MethodMetadata>();
        for (Object ob : clazz.getMethods()) {
            MethodInfo method = (MethodInfo)ob;
            if (method.isStaticInitializer() || !method.isConstructor()) continue;
            ctors.add(new MethodMetadata(clazz, method));
        }
        Collections.sort(ctors);
        return Collections.unmodifiableList(ctors);
    }

    private List<ImportMetadata> importsFor(ClassFile clazz) {
        ConstPool pool;
        Set references;
        String clazzName = clazz.getName();
        String pkg = null;
        boolean clazzHasPackage = false;
        if (clazzName.lastIndexOf(".") != -1) {
            pkg = clazzName.substring(0, clazzName.lastIndexOf(".") + 1);
            clazzHasPackage = true;
        }
        if ((references = (pool = clazz.getConstPool()).getClassNames()) == null || references.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ImportMetadata> imports = new ArrayList<ImportMetadata>();
        for (String reference : references) {
            String refClassName = Descriptor.toJavaName((String)reference);
            if (refClassName.startsWith("[L") && (refClassName = Descriptor.toClassName((String)refClassName)).endsWith("[]")) {
                refClassName = refClassName.substring(0, refClassName.length() - 2);
            }
            if (refClassName.startsWith(JAVA_LANG_PKG) || clazzHasPackage && refClassName.startsWith(pkg) || !clazzHasPackage && reference.indexOf(46) == -1) continue;
            imports.add(ImportMetadata.single(refClassName));
        }
        return Collections.unmodifiableList(imports);
    }

    public boolean isEnumeration() {
        return false;
    }

    public String getClassName() {
        return this.clazz.getName();
    }

    public String getSuperclassName() {
        return this.clazz.getSuperclass();
    }

    public String[] getInterfaces() {
        return this.clazz.getInterfaces();
    }

    public boolean isAbstract() {
        return this.clazz.isAbstract();
    }

    public boolean isInterface() {
        return this.clazz.isInterface();
    }

    public boolean isStrictFp() {
        return 2048 == (0x800 & this.clazz.getAccessFlags());
    }

    public boolean isFinal() {
        return 16 == (0x10 & this.clazz.getAccessFlags());
    }

    public Visibility getVisibility() {
        return Visibility.fromAccessFlags(this.clazz.getAccessFlags());
    }

    public List<AnnotationMetadata> getAnnotations() {
        return this.annotations;
    }

    public List<FieldMetadata> getFields() {
        return this.fields;
    }

    public List<MethodMetadata> getMethods() {
        return this.methods;
    }

    public List<MethodMetadata> getConstructors() {
        return this.constructors;
    }

    public List<ImportMetadata> getImports() {
        return this.imports;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        if (!this.getImports().isEmpty()) {
            for (ImportMetadata imported : this.getImports()) {
                buff.append(imported).append('\n');
            }
            buff.append('\n');
        }
        for (AnnotationMetadata annotation : this.annotations) {
            buff.append(annotation).append('\n');
        }
        buff.append((Object)this.getVisibility());
        if (this.getVisibility() != Visibility.PACKAGE) {
            buff.append(' ');
        }
        if (this.isAbstract()) {
            if (this.isInterface()) {
                buff.append("interface ");
            } else {
                buff.append("abstract class ");
            }
        } else {
            buff.append("class ");
        }
        if (this.getSuperclassName() != null && !Object.class.getName().equals(this.getSuperclassName())) {
            buff.append(" extends ").append(this.getSuperclassName()).append(" ");
        }
        if (this.getInterfaces().length > 0) {
            boolean first = true;
            buff.append(" implements ");
            for (String interfaceName : this.getInterfaces()) {
                if (first) {
                    first = false;
                } else {
                    buff.append(", ");
                }
                buff.append(interfaceName);
            }
            buff.append(' ');
        }
        buff.append(this.getClassName()).append(" {\n");
        for (FieldMetadata field : this.fields) {
            buff.append('\t').append(field).append('\n');
        }
        if (!this.methods.isEmpty()) {
            buff.append('\n');
        }
        for (MethodMetadata method : this.methods) {
            buff.append('\t').append(method).append('\n');
        }
        buff.append("}");
        return buff.toString();
    }
}

