/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.javafile;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Value;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.WildcardType;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.api.ValueFactory;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.classfile.ClassFileSequencerLexicon;
import org.modeshape.sequencer.classfile.metadata.Visibility;
import org.modeshape.sequencer.javafile.CompilationUnitParser;
import org.modeshape.sequencer.javafile.JavaFileI18n;
import org.modeshape.sequencer.javafile.JavaMetadataUtil;
import org.modeshape.sequencer.javafile.SourceFileRecorder;

public class JdtRecorder
implements SourceFileRecorder {
    private static final Logger LOGGER = Logger.getLogger(JdtRecorder.class);
    private CompilationUnit compilationUnit;
    private Sequencer.Context context;
    private String sourceCode;

    protected String getSourceCode(int startPosition, int length) {
        if (StringUtil.isBlank((String)this.sourceCode)) {
            return null;
        }
        return this.sourceCode.substring(startPosition, startPosition + length);
    }

    protected String getTypeName(Type type) {
        if (type.isPrimitiveType()) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            return primitiveType.getPrimitiveTypeCode().toString();
        }
        if (type.isSimpleType()) {
            SimpleType simpleType = (SimpleType)type;
            return simpleType.getName().getFullyQualifiedName();
        }
        if (type.isQualifiedType()) {
            QualifiedType qualifiedType = (QualifiedType)type;
            return qualifiedType.getName().getFullyQualifiedName();
        }
        if (type.isParameterizedType()) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            StringBuilder result = new StringBuilder(this.getTypeName(parameterizedType.getType()));
            result.append('<');
            if (!parameterizedType.typeArguments().isEmpty()) {
                List paramTypes = parameterizedType.typeArguments();
                boolean firstTime = true;
                for (Type paramType : paramTypes) {
                    if (firstTime) {
                        firstTime = false;
                    } else {
                        result.append(", ");
                    }
                    result.append(this.getTypeName(paramType));
                }
            }
            result.append('>');
            return result.toString();
        }
        if (type.isArrayType()) {
            ArrayType arrayType = (ArrayType)type;
            Type elementType = arrayType.getElementType();
            if (elementType.isPrimitiveType()) {
                return ((PrimitiveType)elementType).getPrimitiveTypeCode().toString();
            }
            if (elementType.isSimpleType()) {
                return ((SimpleType)elementType).getName().getFullyQualifiedName();
            }
        }
        if (type.isWildcardType()) {
            return "?";
        }
        return null;
    }

    protected String getVisibility(int modifiers) {
        if ((modifiers & 1) != 0) {
            return Visibility.PUBLIC.getDescription();
        }
        if ((modifiers & 4) != 0) {
            return Visibility.PROTECTED.getDescription();
        }
        if ((modifiers & 2) != 0) {
            return Visibility.PRIVATE.getDescription();
        }
        return Visibility.PACKAGE.getDescription();
    }

    protected void record(Annotation annotation, Node parentNode) throws Exception {
        String name = annotation.getTypeName().getFullyQualifiedName();
        Node annotationNode = parentNode.addNode(name, "class:annotation");
        annotationNode.setProperty("class:name", name);
        if (annotation.isMarkerAnnotation()) {
            annotationNode.setProperty("class:annotationType", ClassFileSequencerLexicon.AnnotationType.MARKER.toString());
            LOGGER.debug("Marker annotation {0} created", new Object[]{name});
        } else if (annotation.isNormalAnnotation()) {
            annotationNode.setProperty("class:annotationType", ClassFileSequencerLexicon.AnnotationType.NORMAL.toString());
            List entries = ((NormalAnnotation)annotation).values();
            if (entries != null && !entries.isEmpty()) {
                for (MemberValuePair entry : entries) {
                    String memberName = entry.getName().getFullyQualifiedName();
                    Expression expression = entry.getValue();
                    this.recordAnnotationMember(memberName, expression, annotationNode);
                }
            }
            LOGGER.debug("Normal annotation {0} created", new Object[]{name});
        } else if (annotation.isSingleMemberAnnotation()) {
            annotationNode.setProperty("class:annotationType", ClassFileSequencerLexicon.AnnotationType.SINGLE_MEMBER.toString());
            Expression expression = ((SingleMemberAnnotation)annotation).getValue();
            this.recordAnnotationMember(null, expression, annotationNode);
            LOGGER.debug("Single member annotation {0} created", new Object[]{name});
        } else {
            assert (false);
            LOGGER.error((I18nResource)JavaFileI18n.unhandledAnnotationType, new Object[]{annotation.getClass().getName(), parentNode.getName()});
        }
        this.recordSourceReference((ASTNode)annotation, annotationNode);
    }

    protected Node record(AnnotationTypeDeclaration annotationType, Node outputNode) throws Exception {
        String name = annotationType.getName().getFullyQualifiedName();
        Node annotationTypeNode = outputNode.addNode(name, "class:annotationType");
        annotationTypeNode.setProperty("class:name", name);
        annotationTypeNode.setProperty("class:visibility", this.getVisibility(annotationType.getModifiers()));
        annotationTypeNode.setProperty("class:sequencedDate", this.context.getTimestamp());
        Javadoc javadoc = annotationType.getJavadoc();
        if (javadoc != null) {
            this.record((Comment)javadoc, annotationTypeNode);
        }
        List modifiers = annotationType.modifiers();
        this.recordAnnotations(modifiers, annotationTypeNode);
        List body = annotationType.bodyDeclarations();
        if (body != null && !body.isEmpty()) {
            Node fieldsNode = null;
            Node membersNode = null;
            Node nestedTypesNode = null;
            for (BodyDeclaration declaration : body) {
                if (declaration instanceof AnnotationTypeMemberDeclaration) {
                    if (membersNode == null) {
                        membersNode = annotationTypeNode.addNode("class:annotationTypeMembers", "class:annotationTypeMembers");
                    }
                    this.record((AnnotationTypeMemberDeclaration)declaration, membersNode);
                    continue;
                }
                if (declaration instanceof FieldDeclaration) {
                    if (fieldsNode == null) {
                        fieldsNode = annotationTypeNode.addNode("class:fields", "class:fields");
                    }
                    this.record((FieldDeclaration)declaration, fieldsNode);
                    continue;
                }
                if (declaration instanceof AbstractTypeDeclaration) {
                    if (nestedTypesNode == null) {
                        nestedTypesNode = annotationTypeNode.addNode("class:nestedTypes", "class:nestedTypes");
                    }
                    if (declaration instanceof TypeDeclaration) {
                        this.record((TypeDeclaration)declaration, nestedTypesNode);
                        continue;
                    }
                    if (declaration instanceof EnumDeclaration) {
                        this.record((EnumDeclaration)declaration, nestedTypesNode);
                        continue;
                    }
                    if (declaration instanceof AnnotationTypeDeclaration) {
                        this.record((AnnotationTypeDeclaration)declaration, nestedTypesNode);
                        continue;
                    }
                    assert (false);
                    LOGGER.error((I18nResource)JavaFileI18n.unhandledAnnotationTypeBodyDeclarationType, new Object[]{declaration.getClass().getName(), annotationType.getName()});
                    continue;
                }
                assert (false);
                LOGGER.error((I18nResource)JavaFileI18n.unhandledAnnotationTypeBodyDeclarationType, new Object[]{declaration.getClass().getName(), annotationType.getName()});
            }
        }
        this.recordSourceReference((ASTNode)annotationType, annotationTypeNode);
        return annotationTypeNode;
    }

    protected void record(AnnotationTypeMemberDeclaration annotationTypeMember, Node parentNode) throws Exception {
        Node memberNode = parentNode.addNode("class:annotationTypeMember", "class:annotationTypeMember");
        memberNode.setProperty("class:name", annotationTypeMember.getName().getFullyQualifiedName());
        int modifiers = annotationTypeMember.getModifiers();
        memberNode.setProperty("class:abstract", (modifiers & 0x400) != 0);
        memberNode.setProperty("class:visibility", this.getVisibility(modifiers));
        Javadoc javadoc = annotationTypeMember.getJavadoc();
        if (javadoc != null) {
            this.record((Comment)javadoc, memberNode);
        }
        List modifiers2 = annotationTypeMember.modifiers();
        this.recordAnnotations(modifiers2, memberNode);
        Type type = annotationTypeMember.getType();
        this.record(type, "class:type", memberNode);
        Expression expression = annotationTypeMember.getDefault();
        if (expression != null) {
            this.recordExpression(expression, "class:default", memberNode);
        }
    }

    protected void record(Block block, Node blockNode) throws Exception {
        List statements;
        if (block != null && (statements = block.statements()) != null && !statements.isEmpty()) {
            for (Statement statement : statements) {
                Node stmtNode = blockNode.addNode("class:statement", "class:statement");
                stmtNode.setProperty("class:content", statement.toString());
                this.recordSourceReference((ASTNode)statement, stmtNode);
            }
        }
    }

    protected void record(Comment comment, Node parentNode) throws Exception {
        Node commentNode = null;
        String commentType = null;
        if (comment.isDocComment()) {
            commentNode = parentNode.addNode("class:javadoc", "class:javadoc");
        } else {
            commentNode = parentNode.addNode("class:comment", "class:comment");
            if (comment.isBlockComment()) {
                commentType = ClassFileSequencerLexicon.CommentType.BLOCK.toString();
            } else if (comment.isLineComment()) {
                commentType = ClassFileSequencerLexicon.CommentType.LINE.toString();
            } else {
                assert (false);
                LOGGER.error((I18nResource)JavaFileI18n.unhandledCommentType, new Object[]{comment.getClass().getName()});
            }
            commentNode.setProperty("class:commentType", commentType);
        }
        String code = this.getSourceCode(comment.getStartPosition(), comment.getLength());
        if (!StringUtil.isBlank((String)code)) {
            commentNode.setProperty("class:comment", code);
        }
        this.recordSourceReference((ASTNode)comment, commentNode);
    }

    protected void record(CompilationUnit unit, Node compilationUnitNode) throws Exception {
        LOGGER.debug("recording unit comments", new Object[0]);
        this.recordComments(unit, compilationUnitNode);
        LOGGER.debug("recording unit import nodes", new Object[0]);
        this.recordImports(unit, compilationUnitNode);
        LOGGER.debug("recording unit compiler messages", new Object[0]);
        this.recordCompilerMessages(unit, compilationUnitNode);
        LOGGER.debug("recording unit package nodes", new Object[0]);
        Node pkgNode = this.recordPackage(unit, compilationUnitNode);
        LOGGER.debug("recording unit type nodes", new Object[0]);
        this.recordTypes(unit, compilationUnitNode, pkgNode);
        LOGGER.debug("recording unit source reference", new Object[0]);
        this.recordSourceReference((ASTNode)unit, compilationUnitNode);
        compilationUnitNode.setProperty("class:sequencedDate", this.context.getTimestamp());
    }

    @Override
    public void record(Sequencer.Context context, InputStream inputStream, long length, String encoding, Node outputNode) throws Exception {
        char[] sourceCode = JavaMetadataUtil.getJavaSourceFromTheInputStream(inputStream, length, encoding);
        this.record(context, sourceCode, outputNode);
    }

    protected void record(EnumConstantDeclaration enumConstant, Node parentNode) throws Exception {
        AnonymousClassDeclaration acd;
        String name = enumConstant.getName().getIdentifier();
        Node constantNode = parentNode.addNode(name, "class:enumConstant");
        Javadoc javadoc = enumConstant.getJavadoc();
        if (javadoc != null) {
            this.record((Comment)javadoc, constantNode);
        }
        List modifiers = enumConstant.modifiers();
        this.recordAnnotations(modifiers, constantNode);
        List args = enumConstant.arguments();
        if (args != null && !args.isEmpty()) {
            Node containerNode = constantNode.addNode("class:arguments", "class:arguments");
            for (Expression arg : args) {
                this.recordExpression(arg, "class:argument", containerNode);
            }
        }
        if ((acd = enumConstant.getAnonymousClassDeclaration()) != null) {
            this.recordBodyDeclarations(acd, constantNode);
        }
        this.recordSourceReference((ASTNode)enumConstant, constantNode);
    }

    protected Node record(EnumDeclaration enumType, Node parentNode) throws Exception {
        List enumValues;
        int i;
        Node containerNode;
        int modifiers;
        String name = enumType.getName().getFullyQualifiedName();
        Node enumNode = parentNode.addNode(name, "class:enum");
        enumNode.setProperty("class:name", name);
        enumNode.setProperty("class:sequencedDate", this.context.getTimestamp());
        enumNode.setProperty("class:interface", false);
        Javadoc javadoc = enumType.getJavadoc();
        if (javadoc != null) {
            this.record((Comment)javadoc, enumNode);
        }
        enumNode.setProperty("class:abstract", ((modifiers = enumType.getModifiers()) & 0x400) != 0);
        enumNode.setProperty("class:final", (modifiers & 0x10) != 0);
        enumNode.setProperty("class:static", (modifiers & 8) != 0);
        enumNode.setProperty("class:strictFp", (modifiers & 0x800) != 0);
        enumNode.setProperty("class:visibility", this.getVisibility(modifiers));
        List modifiers2 = enumType.modifiers();
        this.recordAnnotations(modifiers2, enumNode);
        List interfaces = enumType.superInterfaceTypes();
        if (interfaces != null && !interfaces.isEmpty()) {
            String[] interfaceNames = new String[interfaces.size()];
            containerNode = enumNode.addNode("class:implements", "class:types");
            i = 0;
            for (Type superInterfaceType : interfaces) {
                interfaceNames[i] = this.getTypeName(superInterfaceType);
                this.record(superInterfaceType, "class:interface", containerNode);
                ++i;
            }
            enumNode.setProperty("class:interfaces", interfaceNames);
        }
        if ((enumValues = enumType.enumConstants()) != null && !enumValues.isEmpty()) {
            String[] values = new String[enumValues.size()];
            containerNode = enumNode.addNode("class:enumConstants", "class:enumConstants");
            i = 0;
            for (EnumConstantDeclaration enumConstant : enumValues) {
                values[i++] = enumConstant.getName().getFullyQualifiedName();
                this.record(enumConstant, containerNode);
            }
            enumNode.setProperty("class:enumValues", values);
        }
        this.recordBodyDeclarations((AbstractTypeDeclaration)enumType, enumNode);
        this.recordSourceReference((ASTNode)enumType, enumNode);
        return enumNode;
    }

    protected void record(FieldDeclaration field, Node parentNode) throws Exception {
        List frags = field.fragments();
        String name = ((VariableDeclarationFragment)frags.get(0)).getName().getFullyQualifiedName();
        Node fieldNode = parentNode.addNode(name, "class:field");
        fieldNode.setProperty("class:name", name);
        Javadoc javadoc = field.getJavadoc();
        if (javadoc != null) {
            this.record((Comment)javadoc, fieldNode);
        }
        Type type = field.getType();
        String typeName = this.getTypeName(type);
        fieldNode.setProperty("class:typeClassName", typeName);
        this.record(type, "class:type", fieldNode);
        int modifiers = field.getModifiers();
        fieldNode.setProperty("class:final", (modifiers & 0x10) != 0);
        fieldNode.setProperty("class:static", (modifiers & 8) != 0);
        fieldNode.setProperty("class:transient", (modifiers & 0x80) != 0);
        fieldNode.setProperty("class:visibility", this.getVisibility(modifiers));
        fieldNode.setProperty("class:volatile", (modifiers & 0x40) != 0);
        List modifiers2 = field.modifiers();
        this.recordAnnotations(modifiers2, fieldNode);
        List fragments = field.fragments();
        if (fragments != null && !fragments.isEmpty()) {
            for (VariableDeclarationFragment var : fragments) {
                Expression initializer = var.getInitializer();
                if (initializer == null) continue;
                this.recordExpression(initializer, "class:initializer", fieldNode);
            }
        }
        this.recordSourceReference((ASTNode)field, fieldNode);
    }

    protected void record(Initializer initializer, String nodeName, Node parentNode) throws Exception {
        List statements;
        Block block = initializer.getBody();
        if (block != null && (statements = block.statements()) != null && !statements.isEmpty()) {
            Node initializerNode = parentNode.addNode(nodeName, "class:statements");
            this.record(block, initializerNode);
        }
    }

    protected void record(MethodDeclaration method, Node parentNode) throws Exception {
        Block body;
        int modifiers;
        Node containerNode;
        List typeParams;
        String name = method.getName().getFullyQualifiedName();
        Node methodNode = parentNode.addNode(name, "class:method");
        methodNode.setProperty("class:name", name);
        Javadoc javadoc = method.getJavadoc();
        if (javadoc != null) {
            this.record((Comment)javadoc, methodNode);
        }
        if ((typeParams = method.typeParameters()) != null && !typeParams.isEmpty()) {
            containerNode = methodNode.addNode("class:typeParameters", "class:typeParameters");
            for (TypeParameter param : typeParams) {
                this.record(param, containerNode);
            }
        }
        methodNode.setProperty("class:abstract", ((modifiers = method.getModifiers()) & 0x400) != 0);
        methodNode.setProperty("class:final", (modifiers & 0x10) != 0);
        methodNode.setProperty("class:native", (modifiers & 0x100) != 0);
        methodNode.setProperty("class:static", (modifiers & 8) != 0);
        methodNode.setProperty("class:strictFp", (modifiers & 0x800) != 0);
        methodNode.setProperty("class:synchronized", (modifiers & 0x20) != 0);
        methodNode.setProperty("class:visibility", this.getVisibility(modifiers));
        List modifiers2 = method.modifiers();
        this.recordAnnotations(modifiers2, methodNode);
        List params = method.parameters();
        if (params != null && !params.isEmpty()) {
            containerNode = methodNode.addNode("class:methodParameters", "class:parameters");
            for (TypeParameter param : params) {
                this.record((SingleVariableDeclaration)param, containerNode);
            }
        }
        if (method.isConstructor()) {
            methodNode.setProperty("class:returnTypeClassName", Void.TYPE.getCanonicalName());
        } else {
            Type returnType = method.getReturnType2();
            methodNode.setProperty("class:returnTypeClassName", this.getTypeName(returnType));
            this.record(returnType, "class:returnType", methodNode);
        }
        List errors = method.thrownExceptions();
        if (errors != null && !errors.isEmpty()) {
            String[] errorNames = new String[errors.size()];
            int i = 0;
            for (Name error : errors) {
                errorNames[i++] = error.getFullyQualifiedName();
            }
            methodNode.setProperty("class:thrownExceptions", errorNames);
        }
        if ((body = method.getBody()) != null && body.statements() != null && !body.statements().isEmpty()) {
            Node bodyNode = methodNode.addNode("class:body", "class:statements");
            this.record(body, bodyNode);
        }
        this.recordSourceReference((ASTNode)method, methodNode);
    }

    protected void record(Sequencer.Context context, char[] sourceCode, Node outputNode) throws Exception {
        if (sourceCode == null || sourceCode.length == 0) {
            LOGGER.debug("No source code was found for output node {0}", new Object[]{outputNode.getName()});
            return;
        }
        this.context = context;
        this.sourceCode = new String(sourceCode);
        this.compilationUnit = (CompilationUnit)CompilationUnitParser.runJLS3Conversion(sourceCode, true);
        outputNode.addMixin("class:compilationUnit");
        this.record(this.compilationUnit, outputNode);
    }

    protected void record(SingleVariableDeclaration variable, Node parentNode) throws Exception {
        String name = variable.getName().getFullyQualifiedName();
        Node paramNode = parentNode.addNode(name, "class:parameter");
        paramNode.setProperty("class:name", name);
        paramNode.setProperty("class:final", (variable.getModifiers() & 0x10) != 0);
        paramNode.setProperty("class:varargs", variable.isVarargs());
        Type type = variable.getType();
        String typeName = this.getTypeName(type);
        paramNode.setProperty("class:typeClassName", typeName);
        this.record(type, "class:type", paramNode);
        Expression initializer = variable.getInitializer();
        if (initializer != null) {
            this.recordExpression(initializer, "class:initializer", paramNode);
        }
        List modifiers = variable.modifiers();
        this.recordAnnotations(modifiers, paramNode);
        this.recordSourceReference((ASTNode)variable, paramNode);
    }

    protected void record(Type type, String typeNodeName, Node parentNode) throws Exception {
        if (type.isSimpleType()) {
            Node typeNode = parentNode.addNode(typeNodeName, "class:simpleType");
            typeNode.setProperty("class:typeClassName", this.getTypeName(type));
            LOGGER.debug("Simple type created at '{0}'", new Object[]{typeNode.getPath()});
        } else if (type.isPrimitiveType()) {
            Node typeNode = parentNode.addNode(typeNodeName, "class:primitiveType");
            typeNode.setProperty("class:typeClassName", this.getTypeName(type));
            LOGGER.debug("Primitive type created at '{0}'", new Object[]{typeNode.getPath()});
        } else if (type.isArrayType()) {
            Node typeNode = parentNode.addNode(typeNodeName, "class:arrayType");
            typeNode.setProperty("class:typeClassName", this.getTypeName(type));
            ArrayType arrayType = (ArrayType)type;
            typeNode.setProperty("class:dimensions", (long)arrayType.getDimensions());
            Type componentType = arrayType.getComponentType();
            this.record(componentType, "class:componentType", typeNode);
            LOGGER.debug("Array type created at '{0}'", new Object[]{typeNode.getPath()});
        } else if (type.isParameterizedType()) {
            Node typeNode = parentNode.addNode(typeNodeName, "class:parameterizedType");
            typeNode.setProperty("class:typeClassName", this.getTypeName(type));
            ParameterizedType paramType = (ParameterizedType)type;
            Type baseType = paramType.getType();
            this.record(baseType, "class:baseType", typeNode);
            List arguments = ((ParameterizedType)type).typeArguments();
            if (arguments != null && !arguments.isEmpty()) {
                Node containerNode = typeNode.addNode("class:arguments", "class:types");
                for (Type arg : arguments) {
                    this.record(arg, "class:argument", containerNode);
                }
            }
            LOGGER.debug("Parameterized type created at '{0}'", new Object[]{typeNode.getPath()});
        } else if (type.isQualifiedType()) {
            Node typeNode = parentNode.addNode(typeNodeName, "class:qualifiedType");
            typeNode.setProperty("class:typeClassName", this.getTypeName(type));
            QualifiedType qualifiedType = (QualifiedType)type;
            this.record(qualifiedType.getQualifier(), "class:qualifier", typeNode);
            LOGGER.debug("Qualified type created at '{0}'", new Object[]{typeNode.getPath()});
        } else if (type.isWildcardType()) {
            Node typeNode = parentNode.addNode("?", "class:wildcardType");
            typeNode.setProperty("class:typeClassName", this.getTypeName(type));
            WildcardType wildcardType = (WildcardType)type;
            String bound = wildcardType.isUpperBound() ? ClassFileSequencerLexicon.WildcardTypeBound.UPPER.toString() : ClassFileSequencerLexicon.WildcardTypeBound.LOWER.toString();
            typeNode.setProperty("class:boundType", bound);
            if (wildcardType.getBound() != null) {
                this.record(wildcardType.getBound(), "class:bound", typeNode);
            }
            LOGGER.debug("Wildcard type created at '{0}'", new Object[]{typeNode.getPath()});
        } else {
            assert (false);
            LOGGER.error((I18nResource)JavaFileI18n.unhandledType, new Object[]{type.getClass().getName(), typeNodeName});
        }
    }

    protected Node record(TypeDeclaration type, Node parentNode) throws Exception {
        int modifiers;
        Javadoc javadoc;
        String name = type.getName().getFullyQualifiedName();
        Node typeNode = parentNode.addNode(name, "class:class");
        typeNode.setProperty("class:name", name);
        typeNode.setProperty("class:sequencedDate", this.context.getTimestamp());
        boolean isInterface = type.isInterface();
        typeNode.setProperty("class:interface", isInterface);
        List interfaces = type.superInterfaceTypes();
        if (isInterface) {
            if (interfaces != null && !interfaces.isEmpty()) {
                Node extendsNode = typeNode.addNode("class:extends", "class:types");
                for (Type interfaceType : interfaces) {
                    this.record(interfaceType, "class:interface", extendsNode);
                }
            }
        } else {
            Type superType = type.getSuperclassType();
            String superTypeName = null;
            superTypeName = superType == null ? Object.class.getCanonicalName() : this.getTypeName(superType);
            assert (!StringUtil.isBlank((String)superTypeName));
            typeNode.setProperty("class:superClassName", superTypeName);
            if (superType != null) {
                Node extendsNode = typeNode.addNode("class:extends", "class:types");
                this.record(superType, this.getTypeName(superType), extendsNode);
            }
        }
        if (!isInterface && interfaces != null && !interfaces.isEmpty()) {
            Node implementsNode = typeNode.addNode("class:implements", "class:types");
            String[] interfaceNames = new String[interfaces.size()];
            int size = interfaces.size();
            for (int i = 0; i < size; ++i) {
                Type interfaceType = (Type)interfaces.get(i);
                interfaceNames[i] = this.getTypeName(interfaceType);
                this.record(interfaceType, interfaceNames[i], implementsNode);
            }
            typeNode.setProperty("class:interfaces", interfaceNames);
        }
        if ((javadoc = type.getJavadoc()) != null) {
            this.record((Comment)javadoc, typeNode);
        }
        typeNode.setProperty("class:abstract", ((modifiers = type.getModifiers()) & 0x400) != 0);
        typeNode.setProperty("class:final", (modifiers & 0x10) != 0);
        typeNode.setProperty("class:static", (modifiers & 8) != 0);
        typeNode.setProperty("class:strictFp", (modifiers & 0x800) != 0);
        typeNode.setProperty("class:visibility", this.getVisibility(modifiers));
        List modifiers2 = type.modifiers();
        this.recordAnnotations(modifiers2, typeNode);
        List typeParams = type.typeParameters();
        if (typeParams != null && !typeParams.isEmpty()) {
            Node containerNode = typeNode.addNode("class:typeParameters", "class:typeParameters");
            for (TypeParameter param : typeParams) {
                this.record(param, containerNode);
            }
        }
        this.recordBodyDeclarations((AbstractTypeDeclaration)type, typeNode);
        this.recordSourceReference((ASTNode)type, typeNode);
        return typeNode;
    }

    protected void record(TypeParameter param, Node parentNode) throws Exception {
        String paramName = param.getName().getFullyQualifiedName();
        Node paramNode = parentNode.addNode(paramName, "class:typeParameter");
        List bounds = param.typeBounds();
        if (bounds != null && !bounds.isEmpty()) {
            Node containerNode = paramNode.addNode("class:bounds", "class:types");
            for (Type bound : bounds) {
                this.record(bound, this.getTypeName(bound), containerNode);
            }
        }
        this.recordSourceReference((ASTNode)param, paramNode);
    }

    protected void recordAnnotationMember(String memberName, Expression expression, Node parentNode) throws Exception {
        String name = StringUtil.isBlank((String)memberName) ? "default" : memberName;
        Node node = parentNode.addNode(name, "class:annotationMember");
        node.setProperty("class:name", name);
        String value = null;
        value = expression instanceof StringLiteral ? ((StringLiteral)expression).getLiteralValue() : (expression instanceof Name ? ((Name)expression).getFullyQualifiedName() : (expression instanceof BooleanLiteral ? Boolean.toString(((BooleanLiteral)expression).booleanValue()) : (expression instanceof CharacterLiteral ? Character.toString(((CharacterLiteral)expression).charValue()) : expression.toString())));
        node.setProperty("class:value", value);
        this.recordExpression(expression, name, node);
    }

    protected void recordAnnotations(List<IExtendedModifier> extendedModifiers, Node node) throws Exception {
        if (extendedModifiers != null && !extendedModifiers.isEmpty()) {
            Node containerNode = null;
            for (IExtendedModifier modifier : extendedModifiers) {
                if (!modifier.isAnnotation()) continue;
                if (containerNode == null) {
                    containerNode = node.addNode("class:annotations", "class:annotations");
                }
                this.record((Annotation)modifier, containerNode);
            }
        }
    }

    protected void recordBodyDeclarations(AbstractTypeDeclaration type, Node typeNode) throws Exception {
        Node constructorsContainer = null;
        Node fieldsContainer = null;
        Node methodsContainer = null;
        Node nestedTypesContainer = null;
        for (Object bodyDeclaration : type.bodyDeclarations()) {
            if (bodyDeclaration instanceof FieldDeclaration) {
                if (fieldsContainer == null) {
                    fieldsContainer = typeNode.addNode("class:fields", "class:fields");
                }
                this.record((FieldDeclaration)bodyDeclaration, fieldsContainer);
                continue;
            }
            if (bodyDeclaration instanceof MethodDeclaration) {
                MethodDeclaration method = (MethodDeclaration)bodyDeclaration;
                if (method.isConstructor()) {
                    if (constructorsContainer == null) {
                        constructorsContainer = typeNode.addNode("class:constructors", "class:constructors");
                    }
                    this.record(method, constructorsContainer);
                    continue;
                }
                if (methodsContainer == null) {
                    methodsContainer = typeNode.addNode("class:methods", "class:methods");
                }
                this.record(method, methodsContainer);
                continue;
            }
            if (bodyDeclaration instanceof TypeDeclaration) {
                if (nestedTypesContainer == null) {
                    nestedTypesContainer = typeNode.addNode("class:nestedTypes", "class:nestedTypes");
                }
                this.record((TypeDeclaration)bodyDeclaration, nestedTypesContainer);
                continue;
            }
            if (bodyDeclaration instanceof EnumDeclaration) {
                if (nestedTypesContainer == null) {
                    nestedTypesContainer = typeNode.addNode("class:nestedTypes", "class:nestedTypes");
                }
                this.record((EnumDeclaration)bodyDeclaration, nestedTypesContainer);
                continue;
            }
            if (bodyDeclaration instanceof Initializer) {
                this.record((Initializer)bodyDeclaration, "class:initializer", typeNode);
                continue;
            }
            assert (false);
            LOGGER.error((I18nResource)JavaFileI18n.unhandledBodyDeclarationType, new Object[]{bodyDeclaration.getClass().getName()});
        }
    }

    protected void recordBodyDeclarations(AnonymousClassDeclaration anonClass, Node enumConstantNode) throws Exception {
        Node fieldsContainer = null;
        Node methodsContainer = null;
        Node nestedTypesContainer = null;
        for (Object bodyDeclaration : anonClass.bodyDeclarations()) {
            if (bodyDeclaration instanceof FieldDeclaration) {
                if (fieldsContainer == null) {
                    fieldsContainer = enumConstantNode.addNode("class:fields", "class:fields");
                }
                this.record((FieldDeclaration)bodyDeclaration, fieldsContainer);
                continue;
            }
            if (bodyDeclaration instanceof MethodDeclaration) {
                if (methodsContainer == null) {
                    methodsContainer = enumConstantNode.addNode("class:methods", "class:methods");
                }
                this.record((MethodDeclaration)bodyDeclaration, methodsContainer);
                continue;
            }
            if (bodyDeclaration instanceof TypeDeclaration) {
                if (nestedTypesContainer == null) {
                    nestedTypesContainer = enumConstantNode.addNode("class:nestedTypes", "class:nestedTypes");
                }
                this.record((TypeDeclaration)bodyDeclaration, nestedTypesContainer);
                continue;
            }
            assert (false);
            LOGGER.error((I18nResource)JavaFileI18n.unhandledBodyDeclarationType, new Object[]{bodyDeclaration.getClass().getName()});
        }
    }

    protected void recordComments(CompilationUnit compilationUnit, Node outputNode) throws Exception {
        List comments = compilationUnit.getCommentList();
        if (comments != null && !comments.isEmpty()) {
            Node containerNode = outputNode.addNode("class:comments", "class:comments");
            for (Comment comment : comments) {
                if (comment.isDocComment()) continue;
                this.record(comment, containerNode);
            }
        }
    }

    protected void recordCompilerMessages(CompilationUnit unit, Node parentNode) throws Exception {
        Message[] messages = unit.getMessages();
        if (messages != null && messages.length != 0) {
            Node containerNode = parentNode.addNode("class:messages", "class:messages");
            for (Message message : messages) {
                Node messageNode = containerNode.addNode("class:message", "class:message");
                messageNode.setProperty("class:message", message.getMessage());
                messageNode.setProperty("class:startPosition", (long)message.getStartPosition());
                messageNode.setProperty("class:length", (long)message.getLength());
            }
        }
    }

    protected void recordExpression(Expression expression, String nodeName, Node parentNode) throws Exception {
        Node expressionNode = parentNode.addNode(nodeName, "class:expression");
        expressionNode.setProperty("class:content", expression.toString());
        this.recordSourceReference((ASTNode)expression, expressionNode);
    }

    protected void recordImports(CompilationUnit compilationUnit, Node outputNode) throws Exception {
        List imports = compilationUnit.imports();
        if (imports != null && !imports.isEmpty()) {
            Node containerNode = outputNode.addNode("class:imports", "class:imports");
            for (ImportDeclaration mport : imports) {
                Node importNode = containerNode.addNode(mport.getName().getFullyQualifiedName(), "class:import");
                importNode.setProperty("class:static", mport.isStatic());
                importNode.setProperty("class:onDemand", mport.isOnDemand());
                this.recordSourceReference((ASTNode)mport, importNode);
            }
        }
    }

    protected Node recordPackage(CompilationUnit compilationUnit, Node outputNode) throws Exception {
        List annotations;
        Javadoc javadoc;
        PackageDeclaration pkg = compilationUnit.getPackage();
        if (pkg == null) {
            return outputNode;
        }
        Node pkgNode = outputNode;
        String pkgName = pkg.getName().getFullyQualifiedName();
        String[] packagePath = pkgName.split("\\.");
        if (pkgName.length() > 0) {
            for (String segment : packagePath) {
                pkgNode = pkgNode.addNode(segment);
                pkgNode.addMixin("class:package");
            }
        }
        if ((javadoc = pkg.getJavadoc()) != null) {
            this.record((Comment)javadoc, pkgNode);
        }
        if ((annotations = pkg.annotations()) != null && !annotations.isEmpty()) {
            for (Annotation annotation : annotations) {
                this.record(annotation, pkgNode);
            }
        }
        this.recordSourceReference((ASTNode)pkg, pkgNode);
        return pkgNode;
    }

    protected void recordSourceReference(ASTNode astNode, Node jcrNode) throws Exception {
        jcrNode.setProperty("class:startPosition", (long)astNode.getStartPosition());
        jcrNode.setProperty("class:length", (long)astNode.getLength());
    }

    protected void recordTypes(CompilationUnit unit, Node compilationUnitNode, Node pkgNode) throws Exception {
        List topLevelTypes = unit.types();
        if (topLevelTypes != null && !topLevelTypes.isEmpty()) {
            ArrayList<Node> types = new ArrayList<Node>(topLevelTypes.size());
            for (AbstractTypeDeclaration type : topLevelTypes) {
                if (type instanceof TypeDeclaration) {
                    types.add(this.record((TypeDeclaration)type, pkgNode));
                    continue;
                }
                if (type instanceof EnumDeclaration) {
                    types.add(this.record((EnumDeclaration)type, pkgNode));
                    continue;
                }
                if (type instanceof AnnotationTypeDeclaration) {
                    types.add(this.record((AnnotationTypeDeclaration)type, pkgNode));
                    continue;
                }
                assert (false);
                LOGGER.error((I18nResource)JavaFileI18n.unhandledTopLevelType, new Object[]{type.getName().getFullyQualifiedName()});
            }
            ValueFactory factory = this.context.valueFactory();
            Value[] refs = new Value[topLevelTypes.size()];
            int i = 0;
            for (Node typeNode : types) {
                refs[i++] = factory.createValue(typeNode);
            }
            compilationUnitNode.setProperty("class:types", refs);
        }
        this.recordSourceReference((ASTNode)this.compilationUnit, compilationUnitNode);
    }
}

