/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.javafile.metadata;

import java.util.ArrayList;
import java.util.List;
import org.modeshape.sequencer.javafile.metadata.AbstractMetadata;
import org.modeshape.sequencer.javafile.metadata.Variable;

public class FieldMetadata
extends AbstractMetadata {
    private Type metadataType;
    private String type;
    private List<Variable> variables = new ArrayList<Variable>();

    private FieldMetadata(String type, Type metadataType) {
        this.type = type;
        this.metadataType = metadataType;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public String getType() {
        return this.type;
    }

    public Type getMetadataType() {
        return this.metadataType;
    }

    public static FieldMetadata primitiveType(String type) {
        return new FieldMetadata(type, Type.PRIMITIVE);
    }

    public static FieldMetadata simpleType(String type) {
        return new FieldMetadata(type, Type.SIMPLE);
    }

    public static FieldMetadata arrayType(String type) {
        return new FieldMetadata(type, Type.ARRAY);
    }

    public static FieldMetadata qualifiedType(String type) {
        return new FieldMetadata(type, Type.QUALIFIED);
    }

    public static FieldMetadata parametrizedType(String type) {
        return new FieldMetadata(type, Type.PARAMETRIZED);
    }

    public static FieldMetadata wildcardType(String type) {
        return new FieldMetadata(type, Type.WILDCARD);
    }

    public static enum Type {
        PRIMITIVE,
        SIMPLE,
        ARRAY,
        QUALIFIED,
        PARAMETRIZED,
        WILDCARD;

    }
}

