/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.calendar;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.calendar.Day;
import org.jbpm.calendar.DayPart;
import org.jbpm.calendar.Duration;
import org.jbpm.calendar.Holiday;
import org.jbpm.util.ClassLoaderUtil;

public class BusinessCalendar
implements Serializable {
    private static final long serialVersionUID = 1L;
    static Properties businessCalendarProperties = null;
    Day[] weekDays = null;
    List holidays = null;

    public static synchronized Properties getBusinessCalendarProperties() {
        if (businessCalendarProperties == null) {
            String resource = JbpmConfiguration.Configs.getString("resource.business.calendar");
            businessCalendarProperties = ClassLoaderUtil.getProperties(resource);
        }
        return businessCalendarProperties;
    }

    public BusinessCalendar() {
        this(BusinessCalendar.getBusinessCalendarProperties());
    }

    public BusinessCalendar(Properties calendarProperties) {
        try {
            this.weekDays = Day.parseWeekDays(calendarProperties, this);
            this.holidays = Holiday.parseHolidays(calendarProperties, this);
        }
        catch (Exception e) {
            throw new JbpmException("couldn't create business calendar", e);
        }
    }

    public Date add(Date date, Duration duration) {
        Date end = null;
        if (duration.isBusinessTime) {
            boolean isInbusinessHours;
            DayPart dayPart = this.findDayPart(date);
            boolean bl = isInbusinessHours = dayPart != null;
            if (!isInbusinessHours) {
                Object[] result = new Object[2];
                this.findDay(date).findNextDayPartStart(0, date, result);
                date = (Date)result[0];
                dayPart = (DayPart)result[1];
            }
            end = dayPart.add(date, duration);
        } else {
            end = new Date(date.getTime() + duration.milliseconds);
        }
        return end;
    }

    public Date findStartOfNextDay(Date date) {
        Calendar calendar = BusinessCalendar.getCalendar();
        calendar.setTime(date);
        calendar.add(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        date = calendar.getTime();
        while (this.isHoliday(date)) {
            calendar.setTime(date);
            calendar.add(5, 1);
            date = calendar.getTime();
        }
        return date;
    }

    public Day findDay(Date date) {
        Calendar calendar = BusinessCalendar.getCalendar();
        calendar.setTime(date);
        return this.weekDays[calendar.get(7)];
    }

    public boolean isHoliday(Date date) {
        Iterator iter = this.holidays.iterator();
        while (iter.hasNext()) {
            Holiday holiday = (Holiday)iter.next();
            if (!holiday.includes(date)) continue;
            return true;
        }
        return false;
    }

    DayPart findDayPart(Date date) {
        DayPart dayPart = null;
        if (!this.isHoliday(date)) {
            Day day = this.findDay(date);
            for (int i = 0; i < day.dayParts.length && dayPart == null; ++i) {
                DayPart candidate = day.dayParts[i];
                if (!candidate.includes(date)) continue;
                dayPart = candidate;
            }
        }
        return dayPart;
    }

    public DayPart findNextDayPart(Date date) {
        DayPart nextDayPart = null;
        while (nextDayPart == null) {
            nextDayPart = this.findDayPart(date);
            if (nextDayPart != null) continue;
            date = this.findStartOfNextDay(date);
            Object[] result = new Object[2];
            Day day = this.findDay(date);
            day.findNextDayPartStart(0, date, result);
            nextDayPart = (DayPart)result[1];
        }
        return nextDayPart;
    }

    public boolean isInBusinessHours(Date date) {
        return this.findDayPart(date) != null;
    }

    public static Calendar getCalendar() {
        return new GregorianCalendar();
    }
}

