/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.action;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.graph.node.NodeTypes;
import org.jbpm.util.ClassLoaderUtil;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class ActionTypes {
    static final Log log = LogFactory.getLog(ActionTypes.class);
    static Map actionTypes = ActionTypes.initialiseActionTypes();
    static Map actionNames = NodeTypes.createInverseMapping(actionTypes);

    public static Set getActionTypes() {
        return actionNames.keySet();
    }

    public static Set getActionNames() {
        return actionTypes.keySet();
    }

    public static Class getActionType(String name) {
        return (Class)actionTypes.get(name);
    }

    public static String getActionName(Class type) {
        return (String)actionNames.get(type);
    }

    public static boolean hasActionName(String name) {
        return actionTypes.containsKey(name);
    }

    static Map initialiseActionTypes() {
        HashMap types = new HashMap();
        String resource = JbpmConfiguration.Configs.getString("resource.action.types");
        InputStream actionTypesStream = ClassLoaderUtil.getStream(resource);
        Element actionTypesElement = XmlUtil.parseXmlInputStream(actionTypesStream).getDocumentElement();
        Iterator actionTypeIterator = XmlUtil.elementIterator(actionTypesElement, "action-type");
        while (actionTypeIterator.hasNext()) {
            Element actionTypeElement = (Element)actionTypeIterator.next();
            String elementTag = actionTypeElement.getAttribute("element");
            String className = actionTypeElement.getAttribute("class");
            try {
                Class<?> actionClass = ClassLoaderUtil.getClassLoader().loadClass(className);
                types.put(elementTag, actionClass);
            }
            catch (Exception e) {
                log.debug("action '" + elementTag + "' will not be available. class '" + className + "' couldn't be loaded");
            }
        }
        return types;
    }
}

