/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.instantiation;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.jbpm.instantiation.FieldInstantiator;
import org.jbpm.instantiation.Instantiator;

public class BeanInstantiator
extends FieldInstantiator
implements Instantiator {
    private static final Log log = LogFactory.getLog(BeanInstantiator.class);

    protected void setPropertyValue(Class clazz, Object newInstance, String propertyName, Element propertyElement) {
        try {
            String setterMethodName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
            Method method = this.findSetter(clazz, setterMethodName);
            Class<?> propertyType = method.getParameterTypes()[0];
            if (method != null) {
                method.setAccessible(true);
                method.invoke(newInstance, BeanInstantiator.getValue(propertyType, propertyElement));
            } else {
                log.error("couldn't set property '" + propertyName + "' to value '" + propertyElement.asXML() + "'");
            }
        }
        catch (Exception e) {
            log.error("couldn't parse property '" + propertyName + "' to value '" + propertyElement.asXML() + "'", e);
        }
    }

    private Method findSetter(Class clazz, String setterMethodName) {
        Method method = null;
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length && method == null; ++i) {
            if (!setterMethodName.equals(methods[i].getName()) || methods[i].getParameterTypes() == null || methods[i].getParameterTypes().length != 1) continue;
            method = methods[i];
        }
        if (method == null && clazz != Object.class) {
            method = this.findSetter(clazz.getSuperclass(), setterMethodName);
        }
        return method;
    }
}

