/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.instantiation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.jbpm.JbpmException;
import org.jbpm.file.def.FileDefinition;
import org.jbpm.graph.def.ProcessDefinition;

public class ProcessClassLoader
extends ClassLoader {
    private ProcessDefinition processDefinition = null;

    public ProcessClassLoader(ClassLoader parent, ProcessDefinition processDefinition) {
        super(parent);
        this.processDefinition = processDefinition;
    }

    public URL findResource(String name) {
        URL url = null;
        FileDefinition fileDefinition = this.processDefinition.getFileDefinition();
        if (fileDefinition != null) {
            if (name.startsWith("/")) {
                while (name.startsWith("/")) {
                    name = name.substring(1);
                }
            } else {
                name = "classes/" + name;
            }
            byte[] bytes = null;
            if (fileDefinition.hasFile(name)) {
                bytes = fileDefinition.getBytes(name);
            }
            if (bytes != null) {
                try {
                    url = new URL(null, "processresource://" + this.processDefinition.getName() + "/classes/" + name, new BytesUrlStreamHandler(bytes));
                }
                catch (MalformedURLException e) {
                    throw new JbpmException("couldn't create url", e);
                }
            }
        }
        return url;
    }

    public Class findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        FileDefinition fileDefinition = this.processDefinition.getFileDefinition();
        if (fileDefinition != null) {
            String fileName = "classes/" + name.replace('.', '/') + ".class";
            try {
                byte[] classBytes = fileDefinition.getBytes(fileName);
                clazz = this.defineClass(name, classBytes, 0, classBytes.length);
            }
            catch (JbpmException e) {
                clazz = null;
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException("class '" + name + "' could not be found by the process classloader");
        }
        return clazz;
    }

    public static class BytesUrlConnection
    extends URLConnection {
        byte[] bytes = null;

        public BytesUrlConnection(byte[] bytes, URL u) {
            super(u);
            this.bytes = bytes;
        }

        public void connect() throws IOException {
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.bytes);
        }
    }

    public static class BytesUrlStreamHandler
    extends URLStreamHandler {
        byte[] bytes;

        public BytesUrlStreamHandler(byte[] bytes) {
            this.bytes = bytes;
        }

        protected URLConnection openConnection(URL u) throws IOException {
            return new BytesUrlConnection(this.bytes, u);
        }
    }
}

