/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.mp3;

import java.io.InputStream;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencer;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.mp3.Mp3Metadata;

public class Mp3MetadataSequencer
implements StreamSequencer {
    public static final String METADATA_NODE = "mp3:metadata";
    public static final String MP3_PRIMARY_TYPE = "jcr:primaryType";
    public static final String MP3_TITLE = "mp3:title";
    public static final String MP3_AUTHOR = "mp3:author";
    public static final String MP3_ALBUM = "mp3:album";
    public static final String MP3_YEAR = "mp3:year";
    public static final String MP3_COMMENT = "mp3:comment";

    public void sequence(InputStream stream, SequencerOutput output, StreamSequencerContext context) {
        Mp3Metadata metadata = Mp3Metadata.instance(stream);
        if (metadata != null) {
            output.setProperty(METADATA_NODE, MP3_PRIMARY_TYPE, new Object[]{METADATA_NODE});
            output.setProperty(METADATA_NODE, MP3_TITLE, new Object[]{metadata.getTitle()});
            output.setProperty(METADATA_NODE, MP3_AUTHOR, new Object[]{metadata.getAuthor()});
            output.setProperty(METADATA_NODE, MP3_ALBUM, new Object[]{metadata.getAlbum()});
            output.setProperty(METADATA_NODE, MP3_YEAR, new Object[]{metadata.getYear()});
            output.setProperty(METADATA_NODE, MP3_COMMENT, new Object[]{metadata.getComment()});
        }
    }
}

