/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.util.logging.Logger;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.AudioHeader;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.tag.Tag;

public class AudioFile {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio");
    protected File file;
    protected AudioHeader audioHeader;
    protected Tag tag;

    public AudioFile() {
    }

    public AudioFile(File f, AudioHeader audioHeader, Tag tag) {
        this.file = f;
        this.audioHeader = audioHeader;
        this.tag = tag;
    }

    public AudioFile(String s, AudioHeader audioHeader, Tag tag) {
        this.file = new File(s);
        this.audioHeader = audioHeader;
        this.tag = tag;
    }

    public void commit() throws CannotWriteException {
        AudioFileIO.write(this);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setTag(Tag tag) {
        this.tag = tag;
    }

    public AudioHeader getAudioHeader() {
        return this.audioHeader;
    }

    public Tag getTag() {
        return this.tag;
    }

    public String toString() {
        return "AudioFile " + this.getFile().getAbsolutePath() + "  --------\n" + this.audioHeader.toString() + "\n" + (this.tag == null ? "" : ((Object)this.tag).toString()) + "\n-------------------";
    }

    protected RandomAccessFile checkFilePermissions(File file, boolean readOnly) throws ReadOnlyFileException, FileNotFoundException {
        RandomAccessFile newFile;
        logger.info("Reading file:path" + file.getPath() + ":abs:" + file.getAbsolutePath());
        if (!file.exists()) {
            logger.severe("Unable to find:" + file.getPath());
            throw new FileNotFoundException("Unable to find:" + file.getPath());
        }
        if (readOnly) {
            newFile = new RandomAccessFile(file, "r");
        } else {
            if (!file.canWrite()) {
                logger.severe("Unable to write:" + file.getPath());
                throw new ReadOnlyFileException("Unable to write to:" + file.getPath());
            }
            newFile = new RandomAccessFile(file, "rw");
        }
        return newFile;
    }

    public String displayStructureAsXML() {
        return "";
    }

    public String displayStructureAsPlainText() {
        return "";
    }
}

