/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.ContentDescriptor;
import org.jaudiotagger.audio.asf.data.ExtendedContentDescription;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.util.Utils;

public class ExtContentDescReader {
    public static ExtendedContentDescription read(RandomAccessFile raf, Chunk candidate) throws IOException {
        if (raf == null || candidate == null) {
            throw new IllegalArgumentException("Arguments must not be null.");
        }
        if (GUID.GUID_EXTENDED_CONTENT_DESCRIPTION.equals(candidate.getGuid())) {
            raf.seek(candidate.getPosition());
            return new ExtContentDescReader().parseData(raf);
        }
        return null;
    }

    protected ExtContentDescReader() {
    }

    private ExtendedContentDescription parseData(RandomAccessFile raf) throws IOException {
        ExtendedContentDescription result = null;
        long chunkStart = raf.getFilePointer();
        GUID guid = Utils.readGUID(raf);
        if (GUID.GUID_EXTENDED_CONTENT_DESCRIPTION.equals(guid)) {
            BigInteger chunkLen = Utils.readBig64(raf);
            long descriptorCount = Utils.readUINT16(raf);
            result = new ExtendedContentDescription(chunkStart, chunkLen);
            for (long i = 0L; i < descriptorCount; ++i) {
                String tagElement = Utils.readUTF16LEStr(raf);
                int type = Utils.readUINT16(raf);
                ContentDescriptor prop = new ContentDescriptor(tagElement, type);
                switch (type) {
                    case 0: {
                        prop.setStringValue(Utils.readUTF16LEStr(raf));
                        break;
                    }
                    case 1: {
                        prop.setBinaryValue(this.readBinaryData(raf));
                        break;
                    }
                    case 2: {
                        prop.setBooleanValue(this.readBoolean(raf));
                        break;
                    }
                    case 3: {
                        raf.skipBytes(2);
                        prop.setDWordValue(Utils.readUINT32(raf));
                        break;
                    }
                    case 5: {
                        raf.skipBytes(2);
                        prop.setWordValue(Utils.readUINT16(raf));
                        break;
                    }
                    case 4: {
                        raf.skipBytes(2);
                        prop.setQWordValue(Utils.readUINT64(raf));
                        break;
                    }
                    default: {
                        prop.setStringValue("Invalid datatype: " + new String(this.readBinaryData(raf)));
                    }
                }
                result.addDescriptor(prop);
            }
        }
        return result;
    }

    private byte[] readBinaryData(RandomAccessFile raf) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int size = Utils.readUINT16(raf);
        for (int i = 0; i < size; ++i) {
            bos.write(raf.read());
        }
        return bos.toByteArray();
    }

    private boolean readBoolean(RandomAccessFile raf) throws IOException {
        int size = Utils.readUINT16(raf);
        if (size != 4) {
            throw new IllegalStateException("Boolean value do require 4 Bytes. (Size value is: " + size + ")");
        }
        long value = Utils.readUINT32(raf);
        boolean result = value == 1L;
        return result;
    }
}

