/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import org.jaudiotagger.audio.generic.AbstractTag;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagTextField;

public class GenericTag
extends AbstractTag {
    public static final int ALBUM = 1;
    public static final int ARTIST = 0;
    public static final int COMMENT = 6;
    public static final int GENRE = 5;
    private static final String[] keys = new String[]{"ARTIST", "ALBUM", "TITLE", "TRACK", "YEAR", "GENRE", "COMMENT"};
    public static final int TITLE = 2;
    public static final int TRACK = 3;
    public static final int YEAR = 4;

    public TagField createAlbumField(String content) {
        return new GenericTagTextField(keys[1], content);
    }

    public TagField createArtistField(String content) {
        return new GenericTagTextField(keys[0], content);
    }

    public TagField createCommentField(String content) {
        return new GenericTagTextField(keys[6], content);
    }

    public TagField createGenreField(String content) {
        return new GenericTagTextField(keys[5], content);
    }

    public TagField createTitleField(String content) {
        return new GenericTagTextField(keys[2], content);
    }

    public TagField createTrackField(String content) {
        return new GenericTagTextField(keys[3], content);
    }

    public TagField createYearField(String content) {
        return new GenericTagTextField(keys[4], content);
    }

    protected String getAlbumId() {
        return keys[1];
    }

    protected String getArtistId() {
        return keys[0];
    }

    protected String getCommentId() {
        return keys[6];
    }

    protected String getGenreId() {
        return keys[5];
    }

    protected String getTitleId() {
        return keys[2];
    }

    protected String getTrackId() {
        return keys[3];
    }

    protected String getYearId() {
        return keys[4];
    }

    protected boolean isAllowedEncoding(String enc) {
        return true;
    }

    private class GenericTagTextField
    implements TagTextField {
        private String content;
        private final String id;

        public GenericTagTextField(String fieldId, String initialContent) {
            this.id = fieldId;
            this.content = initialContent;
        }

        public void copyContent(TagField field) {
            if (field instanceof TagTextField) {
                this.content = ((TagTextField)field).getContent();
            }
        }

        public String getContent() {
            return this.content;
        }

        public String getEncoding() {
            return "ISO-8859-1";
        }

        public String getId() {
            return this.id;
        }

        public byte[] getRawContent() {
            return this.content == null ? new byte[]{} : Utils.getDefaultBytes(this.content, this.getEncoding());
        }

        public boolean isBinary() {
            return false;
        }

        public void isBinary(boolean b) {
        }

        public boolean isCommon() {
            return true;
        }

        public boolean isEmpty() {
            return this.content.equals("");
        }

        public void setContent(String s) {
            this.content = s;
        }

        public void setEncoding(String s) {
        }

        public String toString() {
            return this.getId() + " : " + this.getContent();
        }
    }
}

