/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.mp4.field;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.mp4.Mp4FieldKey;
import org.jaudiotagger.tag.mp4.atom.Mp4DataBox;
import org.jaudiotagger.tag.mp4.field.Mp4FieldType;
import org.jaudiotagger.tag.mp4.field.Mp4TagTextField;

public class Mp4TagByteField
extends Mp4TagTextField {
    private int realDataLength;
    private byte[] bytedata;

    public Mp4TagByteField(Mp4FieldKey id, String value) throws FieldDataInvalidException {
        this(id, value, 1);
    }

    public Mp4TagByteField(Mp4FieldKey id, String value, int realDataLength) throws FieldDataInvalidException {
        super(id.getFieldName(), value);
        this.realDataLength = realDataLength;
        try {
            Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            throw new FieldDataInvalidException("Value of:" + value + " is invalid for field:" + (Object)((Object)id));
        }
    }

    public Mp4TagByteField(String id, ByteBuffer raw) throws UnsupportedEncodingException {
        super(id, raw);
    }

    public Mp4FieldType getFieldType() {
        return Mp4FieldType.BYTE;
    }

    protected byte[] getDataBytes() throws UnsupportedEncodingException {
        if (this.bytedata != null) {
            return this.bytedata;
        }
        switch (this.realDataLength) {
            case 2: {
                Short shortValue = new Short(this.content);
                byte[] rawData = Utils.getShortSizeBigEndian(shortValue);
                return rawData;
            }
            case 1: {
                Short shortValue = new Short(this.content);
                byte[] rawData = new byte[]{shortValue.byteValue()};
                return rawData;
            }
            case 4: {
                Integer intValue = new Integer(this.content);
                byte[] rawData = Utils.getSizeBigEndian(intValue);
                return rawData;
            }
        }
        throw new RuntimeException(this.id + ":" + this.realDataLength + ":" + "Dont know how to write byte fields of this length");
    }

    protected void build(ByteBuffer data) throws UnsupportedEncodingException {
        Mp4BoxHeader header = new Mp4BoxHeader(data);
        Mp4DataBox databox = new Mp4DataBox(header, data);
        this.dataSize = header.getDataLength();
        this.realDataLength = this.dataSize - 8;
        this.bytedata = databox.getByteData();
        this.content = databox.getContent();
    }
}

