/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.StreamChunk;
import org.jaudiotagger.audio.asf.util.Utils;

public class VideoStreamChunk
extends StreamChunk {
    private byte[] codecId;
    private long pictureHeight;
    private long pictureWidth;

    public VideoStreamChunk(long pos, BigInteger chunkLen) {
        super(pos, chunkLen);
    }

    public byte[] getCodecId() {
        return this.codecId;
    }

    public String getCodecIdAsString() {
        if (this.getCodecId() != null) {
            return new String(this.getCodecId());
        }
        return "Unknown";
    }

    public long getPictureHeight() {
        return this.pictureHeight;
    }

    public long getPictureWidth() {
        return this.pictureWidth;
    }

    public String prettyPrint() {
        StringBuffer result = new StringBuffer(super.prettyPrint().replaceAll(Utils.LINE_SEPARATOR, Utils.LINE_SEPARATOR + "   "));
        result.insert(0, Utils.LINE_SEPARATOR + "VideoStream");
        result.append("Video info:" + Utils.LINE_SEPARATOR);
        result.append("      Width  : " + this.getPictureWidth() + Utils.LINE_SEPARATOR);
        result.append("      Heigth : " + this.getPictureHeight() + Utils.LINE_SEPARATOR);
        result.append("      Codec  : " + this.getCodecIdAsString() + Utils.LINE_SEPARATOR);
        return result.toString();
    }

    public void setCodecId(byte[] codecId) {
        this.codecId = codecId;
    }

    public void setPictureHeight(long picHeight) {
        this.pictureHeight = picHeight;
    }

    public void setPictureWidth(long picWidth) {
        this.pictureWidth = picWidth;
    }
}

