/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.flac.metadatablock;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockHeader;

public class MetadataBlockDataStreamInfo {
    public static final int STREAM_INFO_DATA_LENGTH = 34;
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.flac.MetadataBlockDataStreamInfo");
    private int minBlockSize;
    private int maxBlockSize;
    private int minFrameSize;
    private int maxFrameSize;
    private int samplingRate;
    private int samplingRatePerChannel;
    private int bitsPerSample;
    private int channelNumber;
    private int totalNumberOfSamples;
    private float length;
    private boolean isValid = true;

    public MetadataBlockDataStreamInfo(MetadataBlockHeader header, RandomAccessFile raf) throws IOException {
        ByteBuffer rawdata = ByteBuffer.allocate(header.getDataLength());
        int bytesRead = raf.getChannel().read(rawdata);
        if (bytesRead < header.getDataLength()) {
            throw new IOException("Unable to read required number of databytes read:" + bytesRead + ":required:" + header.getDataLength());
        }
        rawdata.rewind();
        this.minBlockSize = rawdata.getShort();
        this.maxBlockSize = rawdata.getShort();
        this.minFrameSize = this.readThreeByteInteger(rawdata.get(), rawdata.get(), rawdata.get());
        this.maxFrameSize = this.readThreeByteInteger(rawdata.get(), rawdata.get(), rawdata.get());
        this.samplingRate = this.readSamplingRate(rawdata.get(), rawdata.get(), rawdata.get());
        this.channelNumber = ((this.u(rawdata.get(12)) & 0xE) >>> 1) + 1;
        this.samplingRatePerChannel = this.samplingRate / this.channelNumber;
        this.bitsPerSample = ((this.u(rawdata.get(12)) & 1) << 4) + ((this.u(rawdata.get(13)) & 0xF0) >>> 4) + 1;
        this.totalNumberOfSamples = this.readTotalNumberOfSamples(rawdata.get(13), rawdata.get(14), rawdata.get(15), rawdata.get(16), rawdata.get(17));
        this.length = (float)((double)this.totalNumberOfSamples / (double)this.samplingRatePerChannel);
        logger.info(this.toString());
    }

    public String toString() {
        return "MinBlockSize:" + this.minBlockSize + "MaxBlockSize:" + this.maxBlockSize + "MinFrameSize:" + this.minFrameSize + "MaxFrameSize:" + this.maxFrameSize + "SampleRateTotal:" + this.samplingRate + "SampleRatePerChannel:" + this.samplingRatePerChannel + ":Channel number:" + this.channelNumber + ":Bits per sample: " + this.bitsPerSample + ":TotalNumberOfSamples: " + this.totalNumberOfSamples + ":Length: " + this.length;
    }

    public int getLength() {
        return (int)this.length;
    }

    public float getPreciseLength() {
        return this.length;
    }

    public int getChannelNumber() {
        return this.channelNumber;
    }

    public int getSamplingRate() {
        return this.samplingRate;
    }

    public int getSamplingRatePerChannel() {
        return this.samplingRatePerChannel;
    }

    public String getEncodingType() {
        return "FLAC " + this.bitsPerSample + " bits";
    }

    public boolean isValid() {
        return this.isValid;
    }

    private int readThreeByteInteger(byte b1, byte b2, byte b3) {
        int rate = (this.u(b1) << 16) + (this.u(b2) << 8) + this.u(b3);
        return rate;
    }

    private int readSamplingRate(byte b1, byte b2, byte b3) {
        int rate = (this.u(b1) << 13) + (this.u(b2) << 5) + ((this.u(b3) & 0xF0) >>> 3);
        return rate;
    }

    private int readTotalNumberOfSamples(byte b1, byte b2, byte b3, byte b4, byte b5) {
        int nb = this.u(b5);
        nb += this.u(b4) << 8;
        nb += this.u(b3) << 16;
        nb += this.u(b2) << 24;
        return nb += (this.u(b1) & 0xF) << 32;
    }

    private int u(int i) {
        return i & 0xFF;
    }
}

