/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.valuepair.TextEncoding;

public abstract class AbstractString
extends AbstractDataType {
    protected AbstractString(String identifier, AbstractTagFrameBody frameBody) {
        super(identifier, frameBody);
    }

    public AbstractString(String identifier, AbstractTagFrameBody frameBody, String value) {
        super(identifier, frameBody, value);
    }

    protected AbstractString(AbstractString object) {
        super(object);
    }

    public int getSize() {
        return this.size;
    }

    protected void setSize(int size) {
        this.size = size;
    }

    public String toString() {
        return (String)this.value;
    }

    public boolean canBeEncoded() {
        byte textEncoding = this.getBody().getTextEncoding();
        String charSetName = TextEncoding.getInstanceOf().getValueForId(textEncoding);
        CharsetEncoder encoder = Charset.forName(charSetName).newEncoder();
        if (encoder.canEncode((String)this.value)) {
            return true;
        }
        logger.finest("Failed Trying to decode" + (String)this.value + "with" + encoder.toString());
        return false;
    }
}

