/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.datatype.AbstractString;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.valuepair.TextEncoding;

public class TextEncodedStringSizeTerminated
extends AbstractString {
    public TextEncodedStringSizeTerminated(String identifier, AbstractTagFrameBody frameBody) {
        super(identifier, frameBody);
    }

    public TextEncodedStringSizeTerminated(TextEncodedStringSizeTerminated object) {
        super(object);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextEncodedStringSizeTerminated)) {
            return false;
        }
        return super.equals(obj);
    }

    public void readByteArray(byte[] arr, int offset) throws InvalidDataTypeException {
        logger.finest("Reading from array from offset:" + offset);
        String charSetName = this.getTextEncodingCharSet();
        CharsetDecoder decoder = Charset.forName(charSetName).newDecoder();
        ByteBuffer inBuffer = ByteBuffer.wrap(arr, offset, arr.length - offset).slice();
        CharBuffer outBuffer = CharBuffer.allocate(arr.length - offset);
        decoder.reset();
        CoderResult coderResult = decoder.decode(inBuffer, outBuffer, true);
        if (coderResult.isError()) {
            logger.warning("Decoding error:" + coderResult.toString());
        }
        decoder.flush(outBuffer);
        outBuffer.flip();
        this.value = outBuffer.toString();
        this.setSize(arr.length - offset);
        logger.info("Read SizeTerminatedString:" + this.value + " size:" + this.size);
    }

    public byte[] writeByteArray() {
        byte[] data = null;
        try {
            String stringValue;
            String charSetName = this.getTextEncodingCharSet();
            CharsetEncoder encoder = Charset.forName(charSetName).newEncoder();
            if (TagOptionSingleton.getInstance().isRemoveTrailingTerminatorOnWrite() && (stringValue = (String)this.value).length() > 0 && stringValue.charAt(stringValue.length() - 1) == '\u0000') {
                stringValue = stringValue.substring(0, stringValue.length() - 1);
                this.value = stringValue;
            }
            ByteBuffer bb = encoder.encode(CharBuffer.wrap((String)this.value));
            data = new byte[bb.limit()];
            bb.get(data, 0, bb.limit());
        }
        catch (CharacterCodingException ce) {
            logger.severe(ce.getMessage());
            throw new RuntimeException(ce);
        }
        this.setSize(data.length);
        return data;
    }

    protected String getTextEncodingCharSet() {
        byte textEncoding = this.getBody().getTextEncoding();
        String charSetName = TextEncoding.getInstanceOf().getValueForId(textEncoding);
        logger.finest("text encoding:" + textEncoding + " charset:" + charSetName);
        return charSetName;
    }

    private static List splitByNullSeperator(String value) {
        String[] valuesarray = value.split("\\u0000");
        List<String> values = Arrays.asList(valuesarray);
        if (values.size() == 0) {
            values = new ArrayList<String>(1);
            values.add("");
        }
        return values;
    }

    public void addValue(String value) {
        this.setValue(this.value + "\u0000" + value);
    }

    public int getNumberOfValues() {
        return TextEncodedStringSizeTerminated.splitByNullSeperator((String)this.value).size();
    }

    public String getValueAtIndex(int index) {
        List values = TextEncodedStringSizeTerminated.splitByNullSeperator((String)this.value);
        return (String)values.get(index);
    }
}

