/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.mp4;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.mp4.Mp4FieldKey;
import org.jaudiotagger.tag.mp4.field.Mp4FieldType;

public abstract class Mp4TagField
implements TagField {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.tag.mp4");
    protected String id;

    protected Mp4TagField(String id) {
        this.id = id;
    }

    protected Mp4TagField(ByteBuffer data) throws UnsupportedEncodingException {
        this.build(data);
    }

    protected Mp4TagField(String id, ByteBuffer data) throws UnsupportedEncodingException {
        this(id);
        this.build(data);
    }

    public String getId() {
        return this.id;
    }

    public void isBinary(boolean b) {
    }

    public boolean isCommon() {
        return this.id.equals(Mp4FieldKey.ARTIST.getFieldName()) || this.id.equals(Mp4FieldKey.ALBUM.getFieldName()) || this.id.equals(Mp4FieldKey.TITLE.getFieldName()) || this.id.equals(Mp4FieldKey.TRACK.getFieldName()) || this.id.equals(Mp4FieldKey.DAY.getFieldName()) || this.id.equals(Mp4FieldKey.COMMENT.getFieldName()) || this.id.equals(Mp4FieldKey.GENRE.getFieldName());
    }

    protected byte[] getIdBytes() {
        return Utils.getDefaultBytes(this.getId(), "ISO-8859-1");
    }

    protected abstract byte[] getDataBytes() throws UnsupportedEncodingException;

    public abstract Mp4FieldType getFieldType();

    protected abstract void build(ByteBuffer var1) throws UnsupportedEncodingException;

    public byte[] getRawContent() throws UnsupportedEncodingException {
        logger.fine("Getting Raw data for:" + this.getId());
        try {
            byte[] databox = this.getRawContentDataOnly();
            ByteArrayOutputStream outerbaos = new ByteArrayOutputStream();
            outerbaos.write(Utils.getSizeBigEndian(8 + databox.length));
            outerbaos.write(Utils.getDefaultBytes(this.getId(), "ISO-8859-1"));
            outerbaos.write(databox);
            return outerbaos.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public byte[] getRawContentDataOnly() throws UnsupportedEncodingException {
        logger.fine("Getting Raw data for:" + this.getId());
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] data = this.getDataBytes();
            baos.write(Utils.getSizeBigEndian(16 + data.length));
            baos.write(Utils.getDefaultBytes("data", "ISO-8859-1"));
            baos.write(new byte[]{0});
            baos.write(new byte[]{0, 0, (byte)this.getFieldType().getFileClassId()});
            baos.write(new byte[]{0, 0, 0, 0});
            baos.write(data);
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

