/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.data.StreamBitratePropertiesChunk;
import org.jaudiotagger.audio.asf.util.Utils;

public class StreamBitratePropertiesReader {
    public static StreamBitratePropertiesChunk read(RandomAccessFile raf, Chunk candidate) throws IOException {
        if (raf == null || candidate == null) {
            throw new IllegalArgumentException("Arguments must not be null.");
        }
        if (GUID.GUID_STREAM_BITRATE_PROPERTIES.equals(candidate.getGuid())) {
            raf.seek(candidate.getPosition());
            return new StreamBitratePropertiesReader().parseData(raf);
        }
        return null;
    }

    protected StreamBitratePropertiesReader() {
    }

    private StreamBitratePropertiesChunk parseData(RandomAccessFile raf) throws IOException {
        StreamBitratePropertiesChunk result = null;
        long chunkStart = raf.getFilePointer();
        GUID guid = Utils.readGUID(raf);
        if (GUID.GUID_STREAM_BITRATE_PROPERTIES.equals(guid)) {
            BigInteger chunkLen = Utils.readBig64(raf);
            result = new StreamBitratePropertiesChunk(chunkStart, chunkLen);
            long recordCount = Utils.readUINT16(raf);
            int i = 0;
            while ((long)i < recordCount) {
                int flags = Utils.readUINT16(raf);
                long avgBitrate = Utils.readUINT32(raf);
                result.addBitrateRecord(flags & 0xFF, avgBitrate);
                ++i;
            }
        }
        return result;
    }
}

