/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.flac;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.flac.FlacTagCreator;
import org.jaudiotagger.audio.flac.FlacTagReader;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlock;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockData;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataApplication;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataCueSheet;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPadding;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPicture;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataSeekTable;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockHeader;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.flac.FlacTag;

public class FlacTagWriter {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.flac");
    private List<MetadataBlock> metadataBlockPadding = new ArrayList<MetadataBlock>(1);
    private List<MetadataBlock> metadataBlockApplication = new ArrayList<MetadataBlock>(1);
    private List<MetadataBlock> metadataBlockSeekTable = new ArrayList<MetadataBlock>(1);
    private List<MetadataBlock> metadataBlockCueSheet = new ArrayList<MetadataBlock>(1);
    private FlacTagCreator tc = new FlacTagCreator();
    private FlacTagReader reader = new FlacTagReader();

    public void delete(RandomAccessFile raf, RandomAccessFile tempRaf) throws IOException, CannotWriteException {
        FlacTag emptyTag = new FlacTag(null, new ArrayList<MetadataBlockDataPicture>());
        raf.seek(0L);
        tempRaf.seek(0L);
        this.write(emptyTag, raf, tempRaf);
    }

    public void write(Tag tag, RandomAccessFile raf, RandomAccessFile rafTemp) throws CannotWriteException, IOException {
        logger.info("Writing tag");
        this.metadataBlockPadding.clear();
        this.metadataBlockApplication.clear();
        this.metadataBlockSeekTable.clear();
        this.metadataBlockCueSheet.clear();
        byte[] b = new byte[4];
        raf.readFully(b);
        String flac = new String(b);
        if (!flac.equals("fLaC")) {
            throw new CannotWriteException("This is not a FLAC file");
        }
        boolean isLastBlock = false;
        while (!isLastBlock) {
            MetadataBlockHeader mbh = MetadataBlockHeader.readHeader(raf);
            switch (mbh.getBlockType()) {
                case VORBIS_COMMENT: 
                case PADDING: 
                case PICTURE: {
                    raf.seek(raf.getFilePointer() + (long)mbh.getDataLength());
                    MetadataBlockData mbd = new MetadataBlockDataPadding(mbh.getDataLength());
                    this.metadataBlockPadding.add(new MetadataBlock(mbh, mbd));
                    break;
                }
                case APPLICATION: {
                    MetadataBlockData mbd = new MetadataBlockDataApplication(mbh, raf);
                    this.metadataBlockApplication.add(new MetadataBlock(mbh, mbd));
                    break;
                }
                case SEEKTABLE: {
                    MetadataBlockData mbd = new MetadataBlockDataSeekTable(mbh, raf);
                    this.metadataBlockSeekTable.add(new MetadataBlock(mbh, mbd));
                    break;
                }
                case CUESHEET: {
                    MetadataBlockData mbd = new MetadataBlockDataCueSheet(mbh, raf);
                    this.metadataBlockCueSheet.add(new MetadataBlock(mbh, mbd));
                    break;
                }
                default: {
                    raf.seek(raf.getFilePointer() + (long)mbh.getDataLength());
                }
            }
            isLastBlock = mbh.isLastBlock();
        }
        int availableRoom = this.computeAvailableRoom();
        int newTagSize = this.tc.convert(tag).limit();
        int neededRoom = newTagSize + this.computeNeededRoom();
        raf.seek(0L);
        logger.info("Writing tag available bytes:" + availableRoom + ":needed bytes:" + neededRoom);
        if (availableRoom == neededRoom || availableRoom > neededRoom + 4) {
            int i;
            raf.seek(42L);
            for (i = 0; i < this.metadataBlockApplication.size(); ++i) {
                raf.write(this.metadataBlockApplication.get(i).getHeader().getBytesWithoutIsLastBlockFlag());
                raf.write(this.metadataBlockApplication.get(i).getData().getBytes());
            }
            for (i = 0; i < this.metadataBlockSeekTable.size(); ++i) {
                raf.write(this.metadataBlockSeekTable.get(i).getHeader().getBytesWithoutIsLastBlockFlag());
                raf.write(this.metadataBlockSeekTable.get(i).getData().getBytes());
            }
            for (i = 0; i < this.metadataBlockCueSheet.size(); ++i) {
                raf.write(this.metadataBlockCueSheet.get(i).getHeader().getBytesWithoutIsLastBlockFlag());
                raf.write(this.metadataBlockCueSheet.get(i).getData().getBytes());
            }
            raf.getChannel().write(this.tc.convert(tag, availableRoom - neededRoom));
        } else {
            int i;
            FileChannel fc = raf.getChannel();
            b = new byte[42];
            raf.readFully(b);
            raf.seek(availableRoom + 4 + 4 + 34);
            FileChannel tempFC = rafTemp.getChannel();
            rafTemp.write(b);
            for (i = 0; i < this.metadataBlockApplication.size(); ++i) {
                rafTemp.write(this.metadataBlockApplication.get(i).getHeader().getBytesWithoutIsLastBlockFlag());
                rafTemp.write(this.metadataBlockApplication.get(i).getData().getBytes());
            }
            for (i = 0; i < this.metadataBlockSeekTable.size(); ++i) {
                rafTemp.write(this.metadataBlockSeekTable.get(i).getHeader().getBytesWithoutIsLastBlockFlag());
                rafTemp.write(this.metadataBlockSeekTable.get(i).getData().getBytes());
            }
            for (i = 0; i < this.metadataBlockCueSheet.size(); ++i) {
                rafTemp.write(this.metadataBlockCueSheet.get(i).getHeader().getBytesWithoutIsLastBlockFlag());
                rafTemp.write(this.metadataBlockCueSheet.get(i).getData().getBytes());
            }
            rafTemp.write(this.tc.convert(tag, 4000).array());
            tempFC.transferFrom(fc, tempFC.position(), fc.size());
        }
    }

    private int computeAvailableRoom() {
        int i;
        int length = 0;
        for (i = 0; i < this.metadataBlockApplication.size(); ++i) {
            length += this.metadataBlockApplication.get(i).getLength();
        }
        for (i = 0; i < this.metadataBlockSeekTable.size(); ++i) {
            length += this.metadataBlockSeekTable.get(i).getLength();
        }
        for (i = 0; i < this.metadataBlockCueSheet.size(); ++i) {
            length += this.metadataBlockCueSheet.get(i).getLength();
        }
        for (i = 0; i < this.metadataBlockPadding.size(); ++i) {
            length += this.metadataBlockPadding.get(i).getLength();
        }
        return length;
    }

    private int computeNeededRoom() {
        int i;
        int length = 0;
        for (i = 0; i < this.metadataBlockApplication.size(); ++i) {
            length += this.metadataBlockApplication.get(i).getLength();
        }
        for (i = 0; i < this.metadataBlockSeekTable.size(); ++i) {
            length += this.metadataBlockSeekTable.get(i).getLength();
        }
        for (i = 0; i < this.metadataBlockCueSheet.size(); ++i) {
            length += this.metadataBlockCueSheet.get(i).getLength();
        }
        return length;
    }
}

