/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.mp4;

import java.util.EnumMap;
import java.util.List;
import org.jaudiotagger.audio.generic.AbstractTag;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagFieldKey;
import org.jaudiotagger.tag.mp4.Mp4FieldKey;
import org.jaudiotagger.tag.mp4.Mp4TagField;
import org.jaudiotagger.tag.mp4.field.Mp4DiscNoField;
import org.jaudiotagger.tag.mp4.field.Mp4GenreField;
import org.jaudiotagger.tag.mp4.field.Mp4TagByteField;
import org.jaudiotagger.tag.mp4.field.Mp4TagCoverField;
import org.jaudiotagger.tag.mp4.field.Mp4TagReverseDnsField;
import org.jaudiotagger.tag.mp4.field.Mp4TagTextField;
import org.jaudiotagger.tag.mp4.field.Mp4TagTextNumberField;
import org.jaudiotagger.tag.mp4.field.Mp4TrackField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mp4Tag
extends AbstractTag {
    static EnumMap<TagFieldKey, Mp4FieldKey> tagFieldToMp4Field = new EnumMap(TagFieldKey.class);

    @Override
    protected String getArtistId() {
        return Mp4FieldKey.ARTIST.getFieldName();
    }

    @Override
    protected String getAlbumId() {
        return Mp4FieldKey.ALBUM.getFieldName();
    }

    @Override
    protected String getTitleId() {
        return Mp4FieldKey.TITLE.getFieldName();
    }

    @Override
    protected String getTrackId() {
        return Mp4FieldKey.TRACK.getFieldName();
    }

    @Override
    protected String getYearId() {
        return Mp4FieldKey.DAY.getFieldName();
    }

    @Override
    protected String getCommentId() {
        return Mp4FieldKey.COMMENT.getFieldName();
    }

    @Override
    protected String getGenreId() {
        return Mp4FieldKey.GENRE.getFieldName();
    }

    @Override
    public List<TagField> getGenre() {
        List<TagField> genres = this.get(Mp4FieldKey.GENRE.getFieldName());
        if (genres.size() == 0) {
            genres = this.get(Mp4FieldKey.GENRE_CUSTOM.getFieldName());
        }
        return genres;
    }

    @Override
    public TagField createArtistField(String content) {
        return new Mp4TagTextField(this.getArtistId(), content);
    }

    @Override
    public TagField createAlbumField(String content) {
        return new Mp4TagTextField(this.getAlbumId(), content);
    }

    @Override
    public TagField createTitleField(String content) {
        return new Mp4TagTextField(this.getTitleId(), content);
    }

    @Override
    public TagField createTrackField(String content) throws FieldDataInvalidException {
        return new Mp4TrackField(content);
    }

    @Override
    public TagField createYearField(String content) {
        return new Mp4TagTextField(this.getYearId(), content);
    }

    @Override
    public TagField createCommentField(String content) {
        return new Mp4TagTextField(this.getCommentId(), content);
    }

    @Override
    public TagField createGenreField(String content) {
        if (Mp4GenreField.isValidGenre(content)) {
            return new Mp4GenreField(content);
        }
        return new Mp4TagTextField(Mp4FieldKey.GENRE_CUSTOM.getFieldName(), content);
    }

    @Override
    protected boolean isAllowedEncoding(String enc) {
        return enc.equals("UTF-8");
    }

    @Override
    public String toString() {
        return "Mpeg4 " + super.toString();
    }

    @Override
    public List<TagField> get(TagFieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        return super.get(tagFieldToMp4Field.get((Object)genericKey).getFieldName());
    }

    public List<TagField> get(Mp4FieldKey mp4FieldKey) throws KeyNotFoundException {
        if (mp4FieldKey == null) {
            throw new KeyNotFoundException();
        }
        return super.get(mp4FieldKey.getFieldName());
    }

    @Override
    public String getFirst(TagFieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        return super.getFirst(tagFieldToMp4Field.get((Object)genericKey).getFieldName());
    }

    public String getFirst(Mp4FieldKey mp4Key) throws KeyNotFoundException {
        if (mp4Key == null) {
            throw new KeyNotFoundException();
        }
        return super.getFirst(mp4Key.getFieldName());
    }

    public Mp4TagField getFirstField(Mp4FieldKey mp4Key) throws KeyNotFoundException {
        if (mp4Key == null) {
            throw new KeyNotFoundException();
        }
        return (Mp4TagField)super.getFirstField(mp4Key.getFieldName());
    }

    @Override
    public void deleteTagField(TagFieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        super.deleteField(tagFieldToMp4Field.get((Object)genericKey).getFieldName());
    }

    public void deleteTagField(Mp4FieldKey mp4Key) throws KeyNotFoundException {
        if (mp4Key == null) {
            throw new KeyNotFoundException();
        }
        super.deleteField(mp4Key.getFieldName());
    }

    public TagField createDiscNoField(String content) throws FieldDataInvalidException {
        return new Mp4DiscNoField(content);
    }

    public TagField createArtworkField(byte[] data) throws FieldDataInvalidException {
        return new Mp4TagCoverField(data);
    }

    @Override
    public TagField createTagField(TagFieldKey genericKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        return this.createTagField(tagFieldToMp4Field.get((Object)genericKey), value);
    }

    public TagField createTagField(Mp4FieldKey mp4FieldKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        if (mp4FieldKey == null) {
            throw new KeyNotFoundException();
        }
        switch (mp4FieldKey) {
            case BPM: 
            case COMPILATION: 
            case RATING: 
            case CONTENT_TYPE: 
            case TV_SEASON: 
            case TV_EPISODE: {
                return new Mp4TagByteField(mp4FieldKey, value, mp4FieldKey.getFieldLength());
            }
            case GENRE: {
                return this.createGenreField(value);
            }
            case PODCAST_URL: 
            case EPISODE_GLOBAL_ID: {
                return new Mp4TagTextNumberField(mp4FieldKey.getFieldName(), value);
            }
            case DISCNUMBER: {
                return new Mp4DiscNoField(value);
            }
            case TRACK: {
                return new Mp4TrackField(value);
            }
            case MUSICBRAINZ_TRACKID: 
            case MUSICBRAINZ_ARTISTID: 
            case MUSICBRAINZ_ALBUMID: 
            case MUSICBRAINZ_ALBUMARTISTID: 
            case MUSICBRAINZ_DISCID: 
            case MUSICIP_PUID: 
            case ASIN: 
            case MUSICBRAINZ_ALBUM_STATUS: 
            case MUSICBRAINZ_ALBUM_TYPE: 
            case RELEASECOUNTRY: 
            case PART_OF_GAPLESS_ALBUM: 
            case ITUNES_SMPB: 
            case ITUNES_NORM: {
                return new Mp4TagReverseDnsField(mp4FieldKey, value);
            }
        }
        return new Mp4TagTextField(mp4FieldKey.getFieldName(), value);
    }

    static {
        tagFieldToMp4Field.put(TagFieldKey.ARTIST, Mp4FieldKey.ARTIST);
        tagFieldToMp4Field.put(TagFieldKey.ALBUM, Mp4FieldKey.ALBUM);
        tagFieldToMp4Field.put(TagFieldKey.TITLE, Mp4FieldKey.TITLE);
        tagFieldToMp4Field.put(TagFieldKey.TRACK, Mp4FieldKey.TRACK);
        tagFieldToMp4Field.put(TagFieldKey.YEAR, Mp4FieldKey.DAY);
        tagFieldToMp4Field.put(TagFieldKey.GENRE, Mp4FieldKey.GENRE);
        tagFieldToMp4Field.put(TagFieldKey.COMMENT, Mp4FieldKey.COMMENT);
        tagFieldToMp4Field.put(TagFieldKey.ALBUM_ARTIST, Mp4FieldKey.ALBUM_ARTIST);
        tagFieldToMp4Field.put(TagFieldKey.COMPOSER, Mp4FieldKey.COMPOSER);
        tagFieldToMp4Field.put(TagFieldKey.GROUPING, Mp4FieldKey.GROUPING);
        tagFieldToMp4Field.put(TagFieldKey.DISC_NO, Mp4FieldKey.DISCNUMBER);
        tagFieldToMp4Field.put(TagFieldKey.BPM, Mp4FieldKey.BPM);
        tagFieldToMp4Field.put(TagFieldKey.ENCODER, Mp4FieldKey.ENCODER);
        tagFieldToMp4Field.put(TagFieldKey.MUSICBRAINZ_ARTISTID, Mp4FieldKey.MUSICBRAINZ_ARTISTID);
        tagFieldToMp4Field.put(TagFieldKey.MUSICBRAINZ_RELEASEID, Mp4FieldKey.MUSICBRAINZ_ALBUMID);
        tagFieldToMp4Field.put(TagFieldKey.MUSICBRAINZ_RELEASEARTISTID, Mp4FieldKey.MUSICBRAINZ_ALBUMARTISTID);
        tagFieldToMp4Field.put(TagFieldKey.MUSICBRAINZ_TRACK_ID, Mp4FieldKey.MUSICBRAINZ_TRACKID);
        tagFieldToMp4Field.put(TagFieldKey.MUSICBRAINZ_DISC_ID, Mp4FieldKey.MUSICBRAINZ_DISCID);
        tagFieldToMp4Field.put(TagFieldKey.MUSICIP_ID, Mp4FieldKey.MUSICIP_PUID);
        tagFieldToMp4Field.put(TagFieldKey.AMAZON_ID, Mp4FieldKey.ASIN);
        tagFieldToMp4Field.put(TagFieldKey.MUSICBRAINZ_RELEASE_STATUS, Mp4FieldKey.MUSICBRAINZ_ALBUM_STATUS);
        tagFieldToMp4Field.put(TagFieldKey.MUSICBRAINZ_RELEASE_TYPE, Mp4FieldKey.MUSICBRAINZ_ALBUM_TYPE);
        tagFieldToMp4Field.put(TagFieldKey.MUSICBRAINZ_RELEASE_COUNTRY, Mp4FieldKey.RELEASECOUNTRY);
        tagFieldToMp4Field.put(TagFieldKey.LYRICS, Mp4FieldKey.LYRICS);
        tagFieldToMp4Field.put(TagFieldKey.IS_COMPILATION, Mp4FieldKey.COMPILATION);
        tagFieldToMp4Field.put(TagFieldKey.ARTIST_SORT, Mp4FieldKey.ARTIST_SORT);
        tagFieldToMp4Field.put(TagFieldKey.ALBUM_ARTIST_SORT, Mp4FieldKey.ALBUM_ARTIST_SORT);
        tagFieldToMp4Field.put(TagFieldKey.ALBUM_SORT, Mp4FieldKey.ALBUM_SORT);
        tagFieldToMp4Field.put(TagFieldKey.TITLE_SORT, Mp4FieldKey.TITLE_SORT);
        tagFieldToMp4Field.put(TagFieldKey.COMPOSER_SORT, Mp4FieldKey.COMPOSER_SORT);
        tagFieldToMp4Field.put(TagFieldKey.COVER_ART, Mp4FieldKey.ARTWORK);
    }
}

