/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.mp3;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import junit.framework.Assert;
import org.junit.Test;
import org.modeshape.jcr.sequencer.AbstractSequencerTest;

public class Mp3SequencerTest
extends AbstractSequencerTest {
    @Test
    public void shouldSequenceMp3() throws Exception {
        this.createNodeWithContentFromFile("sample.mp3", "sample1.mp3");
        Node sequencedNodeSameLocation = this.getOutputNode(this.rootNode, "sample.mp3/mp3:metadata");
        this.assertSequencedMp3(sequencedNodeSameLocation);
        Node sequencedNodeDifferentLocation = this.getOutputNode(this.rootNode, "mp3s/sample.mp3");
        this.assertSequencedMp3(sequencedNodeDifferentLocation);
    }

    private void assertSequencedMp3(Node sequencedNode) throws RepositoryException {
        Assert.assertEquals((String)"mp3:metadata", (String)sequencedNode.getPrimaryNodeType().getName());
        Assert.assertEquals((String)"Badwater Slim Performs Live", (String)sequencedNode.getProperty("mp3:album").getString());
        Assert.assertEquals((String)"Badwater Slim", (String)sequencedNode.getProperty("mp3:author").getString());
        Assert.assertEquals((String)"This is a test audio file.", (String)sequencedNode.getProperty("mp3:comment").getString());
        Assert.assertEquals((String)"Sample MP3", (String)sequencedNode.getProperty("mp3:title").getString());
        Assert.assertEquals((String)"2008", (String)sequencedNode.getProperty("mp3:year").getString());
    }
}

