/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.mp3;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.jcr.sequencer.AbstractSequencerTest;

public class Mp3SequencerTest
extends AbstractSequencerTest {
    @Test
    public void shouldSequenceMp3() throws Exception {
        this.createNodeWithContentFromFile("sample.mp3", "sample1.mp3");
        Node sequencedNodeSameLocation = this.getOutputNode(this.rootNode, "sample.mp3/mp3:metadata");
        this.assertSequencedMp3(sequencedNodeSameLocation);
        Node sequencedNodeDifferentLocation = this.getOutputNode(this.rootNode, "mp3s/sample.mp3");
        this.assertSequencedMp3(sequencedNodeDifferentLocation);
    }

    private void assertSequencedMp3(Node sequencedNode) throws RepositoryException {
        Assert.assertEquals((Object)"mp3:metadata", (Object)sequencedNode.getPrimaryNodeType().getName());
        Assert.assertEquals((Object)"Badwater Slim Performs Live", (Object)sequencedNode.getProperty("mp3:album").getString());
        Assert.assertEquals((Object)"Badwater Slim", (Object)sequencedNode.getProperty("mp3:author").getString());
        Assert.assertEquals((Object)"This is a test audio file.", (Object)sequencedNode.getProperty("mp3:comment").getString());
        Assert.assertEquals((Object)"Sample MP3", (Object)sequencedNode.getProperty("mp3:title").getString());
        Assert.assertEquals((Object)"2008", (Object)sequencedNode.getProperty("mp3:year").getString());
    }
}

