/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.cf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.poi.ss.util.CellRangeAddress;

public final class CellRangeUtil {
    public static final int NO_INTERSECTION = 1;
    public static final int OVERLAP = 2;
    public static final int INSIDE = 3;
    public static final int ENCLOSES = 4;

    private CellRangeUtil() {
    }

    public static int intersect(CellRangeAddress crA, CellRangeAddress crB) {
        int firstRow = crB.getFirstRow();
        int lastRow = crB.getLastRow();
        int firstCol = crB.getFirstColumn();
        int lastCol = crB.getLastColumn();
        if (CellRangeUtil.gt(crA.getFirstRow(), lastRow) || CellRangeUtil.lt(crA.getLastRow(), firstRow) || CellRangeUtil.gt(crA.getFirstColumn(), lastCol) || CellRangeUtil.lt(crA.getLastColumn(), firstCol)) {
            return 1;
        }
        if (CellRangeUtil.contains(crA, crB)) {
            return 3;
        }
        if (CellRangeUtil.contains(crB, crA)) {
            return 4;
        }
        return 2;
    }

    public static CellRangeAddress[] mergeCellRanges(CellRangeAddress[] cellRanges) {
        if (cellRanges.length < 1) {
            return cellRanges;
        }
        List temp = CellRangeUtil.mergeCellRanges(Arrays.asList(cellRanges));
        return CellRangeUtil.toArray(temp);
    }

    private static List mergeCellRanges(List cellRangeList) {
        while (cellRangeList.size() > 1) {
            boolean somethingGotMerged = false;
            for (int i = 0; i < cellRangeList.size(); ++i) {
                CellRangeAddress range1 = (CellRangeAddress)cellRangeList.get(i);
                for (int j = i + 1; j < cellRangeList.size(); ++j) {
                    CellRangeAddress range2 = (CellRangeAddress)cellRangeList.get(j);
                    CellRangeAddress[] mergeResult = CellRangeUtil.mergeRanges(range1, range2);
                    if (mergeResult == null) continue;
                    somethingGotMerged = true;
                    cellRangeList.set(i, mergeResult[0]);
                    cellRangeList.remove(j--);
                    for (int k = 1; k < mergeResult.length; ++k) {
                        cellRangeList.add(++j, mergeResult[k]);
                    }
                }
            }
            if (somethingGotMerged) continue;
            break;
        }
        return cellRangeList;
    }

    private static CellRangeAddress[] mergeRanges(CellRangeAddress range1, CellRangeAddress range2) {
        int x = CellRangeUtil.intersect(range1, range2);
        switch (x) {
            case 1: {
                if (CellRangeUtil.hasExactSharedBorder(range1, range2)) {
                    return new CellRangeAddress[]{CellRangeUtil.createEnclosingCellRange(range1, range2)};
                }
                return null;
            }
            case 2: {
                return CellRangeUtil.resolveRangeOverlap(range1, range2);
            }
            case 3: {
                return new CellRangeAddress[]{range1};
            }
            case 4: {
                return new CellRangeAddress[]{range2};
            }
        }
        throw new RuntimeException("unexpected intersection result (" + x + ")");
    }

    static CellRangeAddress[] resolveRangeOverlap(CellRangeAddress rangeA, CellRangeAddress rangeB) {
        if (rangeA.isFullColumnRange()) {
            if (rangeA.isFullRowRange()) {
                return null;
            }
            return CellRangeUtil.sliceUp(rangeA, rangeB);
        }
        if (rangeA.isFullRowRange()) {
            if (rangeB.isFullColumnRange()) {
                return null;
            }
            return CellRangeUtil.sliceUp(rangeA, rangeB);
        }
        if (rangeB.isFullColumnRange()) {
            return CellRangeUtil.sliceUp(rangeB, rangeA);
        }
        if (rangeB.isFullRowRange()) {
            return CellRangeUtil.sliceUp(rangeB, rangeA);
        }
        return CellRangeUtil.sliceUp(rangeA, rangeB);
    }

    private static CellRangeAddress[] sliceUp(CellRangeAddress crA, CellRangeAddress crB) {
        List<CellRangeAddress> temp = new ArrayList<CellRangeAddress>();
        temp.add(crB);
        if (!crA.isFullColumnRange()) {
            temp = CellRangeUtil.cutHorizontally(crA.getFirstRow(), temp);
            temp = CellRangeUtil.cutHorizontally(crA.getLastRow() + 1, temp);
        }
        if (!crA.isFullRowRange()) {
            temp = CellRangeUtil.cutVertically(crA.getFirstColumn(), temp);
            temp = CellRangeUtil.cutVertically(crA.getLastColumn() + 1, temp);
        }
        CellRangeAddress[] crParts = CellRangeUtil.toArray(temp);
        temp.clear();
        temp.add(crA);
        for (int i = 0; i < crParts.length; ++i) {
            CellRangeAddress crPart = crParts[i];
            if (CellRangeUtil.intersect(crA, crPart) == 4) continue;
            temp.add(crPart);
        }
        return CellRangeUtil.toArray(temp);
    }

    private static List cutHorizontally(int cutRow, List input) {
        ArrayList<CellRangeAddress> result = new ArrayList<CellRangeAddress>();
        CellRangeAddress[] crs = CellRangeUtil.toArray(input);
        for (int i = 0; i < crs.length; ++i) {
            CellRangeAddress cr = crs[i];
            if (cr.getFirstRow() < cutRow && cutRow < cr.getLastRow()) {
                result.add(new CellRangeAddress(cr.getFirstRow(), cutRow, cr.getFirstColumn(), cr.getLastColumn()));
                result.add(new CellRangeAddress(cutRow + 1, cr.getLastRow(), cr.getFirstColumn(), cr.getLastColumn()));
                continue;
            }
            result.add(cr);
        }
        return result;
    }

    private static List cutVertically(int cutColumn, List input) {
        ArrayList<CellRangeAddress> result = new ArrayList<CellRangeAddress>();
        CellRangeAddress[] crs = CellRangeUtil.toArray(input);
        for (int i = 0; i < crs.length; ++i) {
            CellRangeAddress cr = crs[i];
            if (cr.getFirstColumn() < cutColumn && cutColumn < cr.getLastColumn()) {
                result.add(new CellRangeAddress(cr.getFirstRow(), cr.getLastRow(), cr.getFirstColumn(), cutColumn));
                result.add(new CellRangeAddress(cr.getFirstRow(), cr.getLastRow(), cutColumn + 1, cr.getLastColumn()));
                continue;
            }
            result.add(cr);
        }
        return result;
    }

    private static CellRangeAddress[] toArray(List temp) {
        CellRangeAddress[] result = new CellRangeAddress[temp.size()];
        temp.toArray(result);
        return result;
    }

    public static boolean contains(CellRangeAddress crA, CellRangeAddress crB) {
        int firstRow = crB.getFirstRow();
        int lastRow = crB.getLastRow();
        int firstCol = crB.getFirstColumn();
        int lastCol = crB.getLastColumn();
        return CellRangeUtil.le(crA.getFirstRow(), firstRow) && CellRangeUtil.ge(crA.getLastRow(), lastRow) && CellRangeUtil.le(crA.getFirstColumn(), firstCol) && CellRangeUtil.ge(crA.getLastColumn(), lastCol);
    }

    public static boolean hasExactSharedBorder(CellRangeAddress crA, CellRangeAddress crB) {
        int oFirstRow = crB.getFirstRow();
        int oLastRow = crB.getLastRow();
        int oFirstCol = crB.getFirstColumn();
        int oLastCol = crB.getLastColumn();
        if (crA.getFirstRow() > 0 && crA.getFirstRow() - 1 == oLastRow || oFirstRow > 0 && oFirstRow - 1 == crA.getLastRow()) {
            return crA.getFirstColumn() == oFirstCol && crA.getLastColumn() == oLastCol;
        }
        if (crA.getFirstColumn() > 0 && crA.getFirstColumn() - 1 == oLastCol || oFirstCol > 0 && crA.getLastColumn() == oFirstCol - 1) {
            return crA.getFirstRow() == oFirstRow && crA.getLastRow() == oLastRow;
        }
        return false;
    }

    public static CellRangeAddress createEnclosingCellRange(CellRangeAddress crA, CellRangeAddress crB) {
        if (crB == null) {
            return crA.copy();
        }
        return new CellRangeAddress(CellRangeUtil.lt(crB.getFirstRow(), crA.getFirstRow()) ? crB.getFirstRow() : crA.getFirstRow(), CellRangeUtil.gt(crB.getLastRow(), crA.getLastRow()) ? crB.getLastRow() : crA.getLastRow(), CellRangeUtil.lt(crB.getFirstColumn(), crA.getFirstColumn()) ? crB.getFirstColumn() : crA.getFirstColumn(), CellRangeUtil.gt(crB.getLastColumn(), crA.getLastColumn()) ? crB.getLastColumn() : crA.getLastColumn());
    }

    private static boolean lt(int a, int b) {
        return a == -1 ? false : (b == -1 ? true : a < b);
    }

    private static boolean le(int a, int b) {
        return a == b || CellRangeUtil.lt(a, b);
    }

    private static boolean gt(int a, int b) {
        return CellRangeUtil.lt(b, a);
    }

    private static boolean ge(int a, int b) {
        return !CellRangeUtil.lt(a, b);
    }
}

