/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.msoffice.excel;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.modeshape.sequencer.msoffice.excel.ExcelMetadata;

public class ExcelMetadataReader {
    private static final char ROW_DELIMITER_CHAR = '\n';
    private static final char CELL_DELIMITER_CHAR = '\t';

    public static ExcelMetadata instance(InputStream stream) throws IOException {
        ExcelMetadata metadata = new ExcelMetadata();
        HSSFWorkbook wb = new HSSFWorkbook(new POIFSFileSystem(stream));
        StringBuffer buff = new StringBuffer();
        ArrayList<String> sheets = new ArrayList<String>();
        for (int sheetInd = 0; sheetInd < wb.getNumberOfSheets(); ++sheetInd) {
            sheets.add(wb.getSheetName(sheetInd));
            HSSFSheet worksheet = wb.getSheetAt(sheetInd);
            int lastRowNum = worksheet.getLastRowNum();
            for (int rowNum = worksheet.getFirstRowNum(); rowNum <= lastRowNum; ++rowNum) {
                HSSFRow row = worksheet.getRow(rowNum);
                if (row == null) continue;
                short lastCellNum = row.getLastCellNum();
                for (int cellNum = row.getFirstCellNum(); cellNum < lastCellNum; ++cellNum) {
                    HSSFCell cell = row.getCell(cellNum);
                    switch (cell.getCellType()) {
                        case 1: {
                            buff.append(cell.getRichStringCellValue().getString());
                            break;
                        }
                        case 0: {
                            buff.append(cell.getNumericCellValue());
                            break;
                        }
                        case 2: {
                            buff.append(cell.getCellFormula());
                        }
                    }
                    HSSFComment comment = cell.getCellComment();
                    if (comment != null) {
                        String commentText = comment.getString().getString().replace('\n', ' ');
                        buff.append(" [");
                        buff.append(commentText);
                        buff.append(" by ");
                        buff.append(comment.getAuthor());
                        buff.append(']');
                    }
                    if (cellNum < lastCellNum - 1) {
                        buff.append('\t');
                        continue;
                    }
                    buff.append('\n');
                }
            }
        }
        metadata.setText(buff.toString());
        metadata.setSheets(sheets);
        return metadata;
    }
}

