/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.poi.hwpf.model.SavedByEntry;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public final class SavedByTable {
    private short unknownValue = (short)-1;
    private SavedByEntry[] entries;

    public SavedByTable(byte[] tableStream, int offset, int size) {
        this.unknownValue = LittleEndian.getShort(tableStream, offset);
        int numEntries = LittleEndian.getInt(tableStream, offset += 2) / 2;
        offset += 4;
        this.entries = new SavedByEntry[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            short len = LittleEndian.getShort(tableStream, offset);
            String userName = StringUtil.getFromUnicodeLE(tableStream, offset += 2, len);
            offset += len * 2;
            len = LittleEndian.getShort(tableStream, offset);
            String saveLocation = StringUtil.getFromUnicodeLE(tableStream, offset += 2, len);
            offset += len * 2;
            this.entries[i] = new SavedByEntry(userName, saveLocation);
        }
    }

    public List getEntries() {
        return Collections.unmodifiableList(Arrays.asList(this.entries));
    }

    public void writeTo(HWPFOutputStream tableStream) throws IOException {
        byte[] header = new byte[6];
        LittleEndian.putShort(header, 0, this.unknownValue);
        LittleEndian.putInt(header, 2, this.entries.length * 2);
        tableStream.write(header);
        for (int i = 0; i < this.entries.length; ++i) {
            this.writeStringValue(tableStream, this.entries[i].getUserName());
            this.writeStringValue(tableStream, this.entries[i].getSaveLocation());
        }
    }

    private void writeStringValue(HWPFOutputStream tableStream, String value) throws IOException {
        byte[] buf = new byte[value.length() * 2 + 2];
        LittleEndian.putShort(buf, 0, (short)value.length());
        StringUtil.putUnicodeLE(value, buf, 2);
        tableStream.write(buf);
    }
}

