/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.UnsupportedEncodingException;
import org.apache.poi.hwpf.model.PieceDescriptor;
import org.apache.poi.hwpf.model.PropertyNode;

public final class TextPiece
extends PropertyNode
implements Comparable {
    private boolean _usesUnicode;
    private PieceDescriptor _pd;

    public TextPiece(int start, int end, byte[] text, PieceDescriptor pd, int cpStart) {
        super(start, end, TextPiece.buildInitSB(text, pd));
        this._usesUnicode = pd.isUnicode();
        this._pd = pd;
        int textLength = ((StringBuffer)this._buf).length();
        if (end - start != textLength) {
            throw new IllegalStateException("Told we're for characters " + start + " -> " + end + ", but actually covers " + textLength + " characters!");
        }
        if (end < start) {
            throw new IllegalStateException("Told we're of negative size! start=" + start + " end=" + end);
        }
    }

    private static StringBuffer buildInitSB(byte[] text, PieceDescriptor pd) {
        String str;
        try {
            str = pd.isUnicode() ? new String(text, "UTF-16LE") : new String(text, "Cp1252");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Your Java is broken! It doesn't know about basic, required character encodings!");
        }
        return new StringBuffer(str);
    }

    public boolean isUnicode() {
        return this._usesUnicode;
    }

    public PieceDescriptor getPieceDescriptor() {
        return this._pd;
    }

    public StringBuffer getStringBuffer() {
        return (StringBuffer)this._buf;
    }

    public byte[] getRawBytes() {
        try {
            return ((StringBuffer)this._buf).toString().getBytes(this._usesUnicode ? "UTF-16LE" : "Cp1252");
        }
        catch (UnsupportedEncodingException ignore) {
            throw new RuntimeException("Your Java is broken! It doesn't know about basic, required character encodings!");
        }
    }

    public String substring(int start, int end) {
        StringBuffer buf = (StringBuffer)this._buf;
        if (start < 0) {
            throw new StringIndexOutOfBoundsException("Can't request a substring before 0 - asked for " + start);
        }
        if (end > buf.length()) {
            throw new StringIndexOutOfBoundsException("Index " + end + " out of range 0 -> " + buf.length());
        }
        if (end < start) {
            throw new StringIndexOutOfBoundsException("Asked for text from " + start + " to " + end + ", which has an end before the start!");
        }
        return buf.substring(start, end);
    }

    public void adjustForDelete(int start, int length) {
        int numChars = length;
        int myStart = this.getStart();
        int myEnd = this.getEnd();
        int end = start + numChars;
        if (start <= myEnd && end >= myStart) {
            int overlapStart = Math.max(myStart, start);
            int overlapEnd = Math.min(myEnd, end);
            ((StringBuffer)this._buf).delete(overlapStart, overlapEnd);
        }
        super.adjustForDelete(start, length);
    }

    public int characterLength() {
        return this.getEnd() - this.getStart();
    }

    public int bytesLength() {
        return (this.getEnd() - this.getStart()) * (this._usesUnicode ? 2 : 1);
    }

    public boolean equals(Object o) {
        if (this.limitsAreEqual(o)) {
            TextPiece tp = (TextPiece)o;
            return this.getStringBuffer().toString().equals(tp.getStringBuffer().toString()) && tp._usesUnicode == this._usesUnicode && this._pd.equals(tp._pd);
        }
        return false;
    }

    public int getCP() {
        return this.getStart();
    }
}

