/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.msoffice;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.property.BinaryFactory;
import org.modeshape.graph.property.DateTimeFactory;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencer;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.msoffice.MSOfficeMetadata;
import org.modeshape.sequencer.msoffice.MSOfficeMetadataI18n;
import org.modeshape.sequencer.msoffice.MSOfficeMetadataLexicon;
import org.modeshape.sequencer.msoffice.excel.ExcelMetadata;
import org.modeshape.sequencer.msoffice.excel.ExcelMetadataReader;
import org.modeshape.sequencer.msoffice.excel.ExcelSheetMetadata;
import org.modeshape.sequencer.msoffice.powerpoint.PowerPointMetadataReader;
import org.modeshape.sequencer.msoffice.powerpoint.SlideDeckMetadata;
import org.modeshape.sequencer.msoffice.powerpoint.SlideMetadata;
import org.modeshape.sequencer.msoffice.word.WordMetadata;
import org.modeshape.sequencer.msoffice.word.WordMetadataReader;

public class MSOfficeMetadataSequencer
implements StreamSequencer {
    public void sequence(InputStream stream, SequencerOutput output, StreamSequencerContext context) {
        String mimeType = context.getMimeType();
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        Path inputPath = context.getInputPath();
        Name docName = inputPath.getLastSegment().getName();
        if (!inputPath.isRoot() && docName.equals(JcrLexicon.CONTENT) && !(inputPath = inputPath.getParent()).isRoot()) {
            docName = inputPath.getLastSegment().getName();
        }
        Path docNode = pathFactory.createRelativePath(new Name[]{docName});
        Path metadataNode = pathFactory.create(docNode, new Name[]{MSOfficeMetadataLexicon.METADATA_NODE});
        if (mimeType.equals("application/vnd.ms-powerpoint") || mimeType.equals("application/mspowerpoint")) {
            try {
                SlideDeckMetadata deck = PowerPointMetadataReader.instance(stream);
                List<SlideMetadata> ppt_metadata = deck.getHeadings();
                this.recordMetadata(output, context, metadataNode, deck.getMetadata());
                if (ppt_metadata != null) {
                    int index = 0;
                    for (SlideMetadata sm : ppt_metadata) {
                        Path pptPath = pathFactory.create(docNode, MSOfficeMetadataLexicon.SLIDE, ++index);
                        output.setProperty(pptPath, MSOfficeMetadataLexicon.TITLE, new Object[]{sm.getTitle()});
                        output.setProperty(pptPath, MSOfficeMetadataLexicon.TEXT, new Object[]{sm.getText()});
                        output.setProperty(pptPath, MSOfficeMetadataLexicon.NOTES, new Object[]{sm.getNotes()});
                        output.setProperty(pptPath, MSOfficeMetadataLexicon.THUMBNAIL, new Object[]{sm.getThumbnail()});
                    }
                }
            }
            catch (IOException e) {
                context.getProblems().addError((Throwable)e, MSOfficeMetadataI18n.errorExtractingPowerpointMetadata, new Object[]{e.getMessage()});
            }
        }
        if (mimeType.equals("application/vnd.ms-word") || mimeType.equals("application/msword")) {
            try {
                WordMetadata wordMetadata = WordMetadataReader.instance(stream);
                this.recordMetadata(output, context, metadataNode, wordMetadata.getMetadata());
                int index = 0;
                for (WordMetadata.WordHeading heading : wordMetadata.getHeadings()) {
                    Path wordPath = pathFactory.create(docNode, MSOfficeMetadataLexicon.HEADING_NODE, ++index);
                    output.setProperty(wordPath, MSOfficeMetadataLexicon.HEADING_NAME, new Object[]{heading.getText()});
                    output.setProperty(wordPath, MSOfficeMetadataLexicon.HEADING_LEVEL, new Object[]{heading.getHeaderLevel()});
                }
            }
            catch (IOException e) {
                context.getProblems().addError((Throwable)e, MSOfficeMetadataI18n.errorExtractingWordMetadata, new Object[]{e.getMessage()});
            }
        }
        if (mimeType.equals("application/vnd.ms-excel") || mimeType.equals("application/msexcel")) {
            try {
                ExcelMetadata excel_metadata = ExcelMetadataReader.instance(stream);
                if (excel_metadata != null) {
                    this.recordMetadata(output, context, metadataNode, excel_metadata.getMetadata());
                    output.setProperty(metadataNode, MSOfficeMetadataLexicon.FULL_CONTENT, new Object[]{excel_metadata.getText()});
                    for (ExcelSheetMetadata sheet : excel_metadata.getSheets()) {
                        Path sheetPath = pathFactory.create(docNode, sheet.getName());
                        output.setProperty(sheetPath, MSOfficeMetadataLexicon.SHEET_NAME, new Object[]{sheet.getName()});
                        output.setProperty(sheetPath, MSOfficeMetadataLexicon.TEXT, new Object[]{sheet.getText()});
                    }
                }
            }
            catch (IOException e) {
                context.getProblems().addError((Throwable)e, MSOfficeMetadataI18n.errorExtractingExcelMetadata, new Object[]{e.getMessage()});
            }
        }
    }

    protected void recordMetadata(SequencerOutput output, StreamSequencerContext context, Path metadataNode, MSOfficeMetadata metadata) {
        if (metadata != null) {
            DateTimeFactory dates = context.getValueFactories().getDateFactory();
            BinaryFactory binary = context.getValueFactories().getBinaryFactory();
            output.setProperty(metadataNode, JcrLexicon.PRIMARY_TYPE, new Object[]{MSOfficeMetadataLexicon.METADATA_NODE});
            output.setProperty(metadataNode, MSOfficeMetadataLexicon.TITLE, new Object[]{metadata.getTitle()});
            output.setProperty(metadataNode, MSOfficeMetadataLexicon.SUBJECT, new Object[]{metadata.getSubject()});
            output.setProperty(metadataNode, MSOfficeMetadataLexicon.AUTHOR, new Object[]{metadata.getAuthor()});
            output.setProperty(metadataNode, MSOfficeMetadataLexicon.KEYWORDS, new Object[]{metadata.getKeywords()});
            output.setProperty(metadataNode, MSOfficeMetadataLexicon.COMMENT, new Object[]{metadata.getComment()});
            output.setProperty(metadataNode, MSOfficeMetadataLexicon.TEMPLATE, new Object[]{metadata.getTemplate()});
            output.setProperty(metadataNode, MSOfficeMetadataLexicon.SAVED, new Object[]{dates.create(metadata.getLastSaved())});
            output.setProperty(metadataNode, MSOfficeMetadataLexicon.REVISION, new Object[]{metadata.getRevision()});
            output.setProperty(metadataNode, MSOfficeMetadataLexicon.TOTAL_EDITING_TIME, new Object[]{metadata.getTotalEditingTime()});
            output.setProperty(metadataNode, MSOfficeMetadataLexicon.LAST_PRINTED, new Object[]{dates.create(metadata.getLastPrinted())});
            output.setProperty(metadataNode, MSOfficeMetadataLexicon.CREATED, new Object[]{dates.create(metadata.getCreated())});
            output.setProperty(metadataNode, MSOfficeMetadataLexicon.PAGES, new Object[]{metadata.getPages()});
            output.setProperty(metadataNode, MSOfficeMetadataLexicon.WORDS, new Object[]{metadata.getWords()});
            output.setProperty(metadataNode, MSOfficeMetadataLexicon.CHARACTERS, new Object[]{metadata.getCharacters()});
            output.setProperty(metadataNode, MSOfficeMetadataLexicon.CREATING_APPLICATION, new Object[]{metadata.getCreatingApplication()});
            output.setProperty(metadataNode, MSOfficeMetadataLexicon.THUMBNAIL, new Object[]{binary.create(metadata.getThumbnail())});
        }
    }
}

