/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.msoffice.powerpoint;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.sequencer.msoffice.powerpoint.PowerPointMetadataReader;
import org.modeshape.sequencer.msoffice.powerpoint.SlideDeckMetadata;
import org.modeshape.sequencer.msoffice.powerpoint.SlideMetadata;

public class PowerPointMetadataReaderTest {
    private SlideDeckMetadata pptReader;
    private InputStream imageStream;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.imageStream != null) {
            try {
                this.imageStream.close();
            }
            finally {
                this.imageStream = null;
            }
        }
    }

    protected InputStream getTestDocument(String resourcePath) {
        return this.getClass().getResourceAsStream("/" + resourcePath);
    }

    @Test
    public void shouldBeAbleToCreateMetadataForPowerPoint() throws Exception {
        this.pptReader = PowerPointMetadataReader.instance((InputStream)this.getTestDocument("powerpoint.ppt"));
        SlideMetadata slide = (SlideMetadata)this.pptReader.getHeadings().get(0);
        Assert.assertThat((Object)slide.getTitle(), (Matcher)Is.is((Object)"Test Slide"));
        Assert.assertThat((Object)slide.getText(), (Matcher)Is.is((Object)"This is some text"));
        Assert.assertThat((Object)slide.getNotes(), (Matcher)Is.is((Object)"My notes"));
        try {
            FileOutputStream out = new FileOutputStream("slide.png");
            out.write(slide.getThumbnail());
            out.close();
            File f = new File("slide.png");
            Assert.assertThat((Object)f.exists(), (Matcher)Is.is((Object)true));
            f.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

