/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;

@Internal
public final class ParagraphHeight {
    private short infoField;
    private BitField fSpare = BitFieldFactory.getInstance((int)1);
    private BitField fUnk = BitFieldFactory.getInstance((int)2);
    private BitField fDiffLines = BitFieldFactory.getInstance((int)4);
    private BitField clMac = BitFieldFactory.getInstance((int)65280);
    private short reserved;
    private int dxaCol;
    private int dymLineOrHeight;

    public ParagraphHeight(byte[] buf, int offset) {
        this.infoField = LittleEndian.getShort((byte[])buf, (int)offset);
        this.reserved = LittleEndian.getShort((byte[])buf, (int)(offset += 2));
        this.dxaCol = LittleEndian.getInt((byte[])buf, (int)(offset += 2));
        this.dymLineOrHeight = LittleEndian.getInt((byte[])buf, (int)(offset += 4));
    }

    public ParagraphHeight() {
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.toByteArray());
    }

    protected byte[] toByteArray() {
        byte[] buf = new byte[12];
        int offset = 0;
        LittleEndian.putShort((byte[])buf, (int)offset, (short)this.infoField);
        LittleEndian.putShort((byte[])buf, (int)(offset += 2), (short)this.reserved);
        LittleEndian.putInt((byte[])buf, (int)(offset += 2), (int)this.dxaCol);
        LittleEndian.putInt((byte[])buf, (int)(offset += 4), (int)this.dymLineOrHeight);
        return buf;
    }

    public boolean equals(Object o) {
        ParagraphHeight ph = (ParagraphHeight)o;
        return this.infoField == ph.infoField && this.reserved == ph.reserved && this.dxaCol == ph.dxaCol && this.dymLineOrHeight == ph.dymLineOrHeight;
    }
}

