/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.crypt.standard;

import java.io.IOException;
import org.apache.poi.poifs.crypt.ChainingMode;
import org.apache.poi.poifs.crypt.CipherAlgorithm;
import org.apache.poi.poifs.crypt.CipherProvider;
import org.apache.poi.poifs.crypt.CryptoFunctions;
import org.apache.poi.poifs.crypt.EncryptionHeader;
import org.apache.poi.poifs.crypt.HashAlgorithm;
import org.apache.poi.poifs.crypt.standard.EncryptionRecord;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndianByteArrayOutputStream;
import org.apache.poi.util.LittleEndianOutput;

public class StandardEncryptionHeader
extends EncryptionHeader
implements EncryptionRecord {
    private static BitField flagsCryptoAPI = new BitField(4);
    private static BitField flagsDocProps = new BitField(8);
    private static BitField flagsExternal = new BitField(16);
    private static BitField flagsAES = new BitField(32);

    protected StandardEncryptionHeader(DocumentInputStream is) throws IOException {
        this.setFlags(is.readInt());
        this.setSizeExtra(is.readInt());
        this.setCipherAlgorithm(CipherAlgorithm.fromEcmaId(is.readInt()));
        this.setHashAlgorithm(HashAlgorithm.fromEcmaId(is.readInt()));
        this.setKeySize(is.readInt());
        this.setBlockSize(this.getKeySize());
        this.setCipherProvider(CipherProvider.fromEcmaId(is.readInt()));
        is.readLong();
        is.mark(5);
        int checkForSalt = is.readInt();
        is.reset();
        if (checkForSalt == 16) {
            this.setCspName("");
        } else {
            char c;
            StringBuilder builder = new StringBuilder();
            while ((c = (char)is.readShort()) != '\u0000') {
                builder.append(c);
            }
            this.setCspName(builder.toString());
        }
        this.setChainingMode(ChainingMode.ecb);
        this.setKeySalt(null);
    }

    protected StandardEncryptionHeader(CipherAlgorithm cipherAlgorithm, HashAlgorithm hashAlgorithm, int keyBits, int blockSize, ChainingMode chainingMode) {
        this.setCipherAlgorithm(cipherAlgorithm);
        this.setHashAlgorithm(hashAlgorithm);
        this.setKeySize(keyBits);
        this.setBlockSize(blockSize);
        this.setCipherProvider(cipherAlgorithm.provider);
        this.setFlags(flagsCryptoAPI.setBoolean(0, true) | flagsAES.setBoolean(0, cipherAlgorithm.provider == CipherProvider.aes));
    }

    public void write(LittleEndianByteArrayOutputStream bos) {
        int startIdx = bos.getWriteIndex();
        LittleEndianOutput sizeOutput = bos.createDelayedOutput(4);
        bos.writeInt(this.getFlags());
        bos.writeInt(0);
        bos.writeInt(this.getCipherAlgorithm().ecmaId);
        bos.writeInt(this.getHashAlgorithmEx().ecmaId);
        bos.writeInt(this.getKeySize());
        bos.writeInt(this.getCipherProvider().ecmaId);
        bos.writeInt(0);
        bos.writeInt(0);
        if (this.getCspName() != null) {
            bos.write(CryptoFunctions.getUtf16LeString(this.getCspName()));
            bos.writeShort(0);
        }
        int headerSize = bos.getWriteIndex() - startIdx - 4;
        sizeOutput.writeInt(headerSize);
    }
}

