/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.Ole10NativeException;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public class Ole10Native {
    public static final String OLE10_NATIVE = "\u0001Ole10Native";
    protected static final String ISO1 = "ISO-8859-1";
    private int totalSize;
    private short flags1 = (short)2;
    private String label;
    private String fileName;
    private short flags2 = 0;
    private short unknown1 = (short)3;
    private String command;
    private byte[] dataBuffer;
    private short flags3 = 0;

    public static Ole10Native createFromEmbeddedOleObject(POIFSFileSystem poifs) throws IOException, Ole10NativeException {
        return Ole10Native.createFromEmbeddedOleObject(poifs.getRoot());
    }

    public static Ole10Native createFromEmbeddedOleObject(DirectoryNode directory) throws IOException, Ole10NativeException {
        boolean plain = false;
        try {
            directory.getEntry("\u0001Ole10ItemName");
            plain = true;
        }
        catch (FileNotFoundException ex) {
            plain = false;
        }
        DocumentEntry nativeEntry = (DocumentEntry)directory.getEntry(OLE10_NATIVE);
        byte[] data = new byte[nativeEntry.getSize()];
        directory.createDocumentInputStream(nativeEntry).read(data);
        return new Ole10Native(data, 0, plain);
    }

    public Ole10Native(String label, String filename, String command, byte[] data) {
        this.setLabel(label);
        this.setFileName(filename);
        this.setCommand(command);
        this.setDataBuffer(data);
    }

    public Ole10Native(byte[] data, int offset) throws Ole10NativeException {
        this(data, offset, false);
    }

    public Ole10Native(byte[] data, int offset, boolean plain) throws Ole10NativeException {
        int ofs = offset;
        if (data.length < offset + 2) {
            throw new Ole10NativeException("data is too small");
        }
        this.totalSize = LittleEndian.getInt(data, ofs);
        ofs += 4;
        if (plain) {
            this.dataBuffer = new byte[this.totalSize - 4];
            System.arraycopy(data, 4, this.dataBuffer, 0, this.dataBuffer.length);
            byte[] oleLabel = new byte[8];
            System.arraycopy(this.dataBuffer, 0, oleLabel, 0, Math.min(this.dataBuffer.length, 8));
            this.fileName = this.label = "ole-" + HexDump.toHex(oleLabel);
            this.command = this.label;
        } else {
            this.flags1 = LittleEndian.getShort(data, ofs);
            int len = Ole10Native.getStringLength(data, ofs += 2);
            this.label = StringUtil.getFromCompressedUnicode(data, ofs, len - 1);
            ofs += len;
            len = Ole10Native.getStringLength(data, ofs);
            this.fileName = StringUtil.getFromCompressedUnicode(data, ofs, len - 1);
            this.flags2 = LittleEndian.getShort(data, ofs += len);
            this.unknown1 = LittleEndian.getShort(data, ofs += 2);
            len = LittleEndian.getInt(data, ofs += 2);
            this.command = StringUtil.getFromCompressedUnicode(data, ofs += 4, len - 1);
            if (this.totalSize < (ofs += len)) {
                throw new Ole10NativeException("Invalid Ole10Native");
            }
            int dataSize = LittleEndian.getInt(data, ofs);
            if (dataSize < 0 || this.totalSize - ((ofs += 4) - 4) < dataSize) {
                throw new Ole10NativeException("Invalid Ole10Native");
            }
            this.dataBuffer = new byte[dataSize];
            System.arraycopy(data, ofs, this.dataBuffer, 0, dataSize);
            ofs += dataSize;
        }
    }

    private static int getStringLength(byte[] data, int ofs) {
        int len = 0;
        while (len + ofs < data.length && data[ofs + len] != 0) {
            ++len;
        }
        return ++len;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public short getFlags1() {
        return this.flags1;
    }

    public String getLabel() {
        return this.label;
    }

    public String getFileName() {
        return this.fileName;
    }

    public short getFlags2() {
        return this.flags2;
    }

    public short getUnknown1() {
        return this.unknown1;
    }

    public String getCommand() {
        return this.command;
    }

    public int getDataSize() {
        return this.dataBuffer.length;
    }

    public byte[] getDataBuffer() {
        return this.dataBuffer;
    }

    public short getFlags3() {
        return this.flags3;
    }

    public void writeOut(OutputStream out) throws IOException {
        byte[] intbuf = new byte[4];
        byte[] shortbuf = new byte[2];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(intbuf);
        LittleEndian.putShort(shortbuf, 0, this.getFlags1());
        bos.write(shortbuf);
        bos.write(this.getLabel().getBytes(ISO1));
        bos.write(0);
        bos.write(this.getFileName().getBytes(ISO1));
        bos.write(0);
        LittleEndian.putShort(shortbuf, 0, this.getFlags2());
        bos.write(shortbuf);
        LittleEndian.putShort(shortbuf, 0, this.getUnknown1());
        bos.write(shortbuf);
        LittleEndian.putInt(intbuf, 0, this.getCommand().length() + 1);
        bos.write(intbuf);
        bos.write(this.getCommand().getBytes(ISO1));
        bos.write(0);
        LittleEndian.putInt(intbuf, 0, this.getDataBuffer().length);
        bos.write(intbuf);
        bos.write(this.getDataBuffer());
        LittleEndian.putShort(shortbuf, 0, this.getFlags3());
        bos.write(shortbuf);
        byte[] data = bos.toByteArray();
        this.totalSize = data.length - 4;
        LittleEndian.putInt(data, 0, this.totalSize);
        out.write(data);
    }

    public void setFlags1(short flags1) {
        this.flags1 = flags1;
    }

    public void setFlags2(short flags2) {
        this.flags2 = flags2;
    }

    public void setFlags3(short flags3) {
        this.flags3 = flags3;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setUnknown1(short unknown1) {
        this.unknown1 = unknown1;
    }

    public void setDataBuffer(byte[] dataBuffer) {
        this.dataBuffer = dataBuffer;
    }
}

