/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.LittleEndian;

public final class HeadersFootersAtom
extends RecordAtom {
    public static final int fHasDate = 1;
    public static final int fHasTodayDate = 2;
    public static final int fHasUserDate = 4;
    public static final int fHasSlideNumber = 8;
    public static final int fHasHeader = 16;
    public static final int fHasFooter = 32;
    private byte[] _header;
    private byte[] _recdata;

    protected HeadersFootersAtom(byte[] source, int start, int len) {
        this._header = new byte[8];
        System.arraycopy(source, start, this._header, 0, 8);
        this._recdata = new byte[len - 8];
        System.arraycopy(source, start + 8, this._recdata, 0, len - 8);
    }

    public HeadersFootersAtom() {
        this._recdata = new byte[4];
        this._header = new byte[8];
        LittleEndian.putShort((byte[])this._header, (int)2, (short)((short)this.getRecordType()));
        LittleEndian.putInt((byte[])this._header, (int)4, (int)this._recdata.length);
    }

    public long getRecordType() {
        return RecordTypes.HeadersFootersAtom.typeID;
    }

    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._recdata);
    }

    public int getFormatId() {
        return LittleEndian.getShort((byte[])this._recdata, (int)0);
    }

    public void setFormatId(int formatId) {
        LittleEndian.putUShort((byte[])this._recdata, (int)0, (int)formatId);
    }

    public int getMask() {
        return LittleEndian.getShort((byte[])this._recdata, (int)2);
    }

    public void setMask(int mask) {
        LittleEndian.putUShort((byte[])this._recdata, (int)2, (int)mask);
    }

    public boolean getFlag(int bit) {
        return (this.getMask() & bit) != 0;
    }

    public void setFlag(int bit, boolean value) {
        int mask = this.getMask();
        mask = value ? (mask |= bit) : (mask &= ~bit);
        this.setMask(mask);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("HeadersFootersAtom\n");
        buf.append("\tFormatId: " + this.getFormatId() + "\n");
        buf.append("\tMask    : " + this.getMask() + "\n");
        buf.append("\t  fHasDate        : " + this.getFlag(1) + "\n");
        buf.append("\t  fHasTodayDate   : " + this.getFlag(2) + "\n");
        buf.append("\t  fHasUserDate    : " + this.getFlag(4) + "\n");
        buf.append("\t  fHasSlideNumber : " + this.getFlag(8) + "\n");
        buf.append("\t  fHasHeader      : " + this.getFlag(16) + "\n");
        buf.append("\t  fHasFooter      : " + this.getFlag(32) + "\n");
        return buf.toString();
    }
}

