/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.poi.ddf.DefaultEscherRecordFactory;
import org.apache.poi.ddf.EscherBSERecord;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherDggRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.LittleEndian;

public final class PPDrawingGroup
extends RecordAtom {
    private byte[] _header = new byte[8];
    private EscherContainerRecord dggContainer;
    private EscherDggRecord dgg;

    protected PPDrawingGroup(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        byte[] contents = new byte[len];
        System.arraycopy(source, start, contents, 0, len);
        DefaultEscherRecordFactory erf = new DefaultEscherRecordFactory();
        EscherRecord child = erf.createRecord(contents, 0);
        child.fillFields(contents, 0, (EscherRecordFactory)erf);
        this.dggContainer = (EscherContainerRecord)child.getChild(0);
    }

    public long getRecordType() {
        return RecordTypes.PPDrawingGroup.typeID;
    }

    public Record[] getChildRecords() {
        return null;
    }

    public void writeOut(OutputStream out) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Iterator iter = this.dggContainer.getChildIterator();
        while (iter.hasNext()) {
            EscherRecord r = (EscherRecord)iter.next();
            if (r.getRecordId() == -4095) {
                EscherContainerRecord bstore = (EscherContainerRecord)r;
                ByteArrayOutputStream b2 = new ByteArrayOutputStream();
                Iterator it = bstore.getChildIterator();
                while (it.hasNext()) {
                    EscherBSERecord bse = (EscherBSERecord)it.next();
                    byte[] b = new byte[44];
                    bse.serialize(0, b);
                    b2.write(b);
                }
                byte[] bstorehead = new byte[8];
                LittleEndian.putShort((byte[])bstorehead, (int)0, (short)bstore.getOptions());
                LittleEndian.putShort((byte[])bstorehead, (int)2, (short)bstore.getRecordId());
                LittleEndian.putInt((byte[])bstorehead, (int)4, (int)b2.size());
                bout.write(bstorehead);
                bout.write(b2.toByteArray());
                continue;
            }
            bout.write(r.serialize());
        }
        int size = bout.size();
        LittleEndian.putInt((byte[])this._header, (int)4, (int)(size + 8));
        out.write(this._header);
        byte[] dgghead = new byte[8];
        LittleEndian.putShort((byte[])dgghead, (int)0, (short)this.dggContainer.getOptions());
        LittleEndian.putShort((byte[])dgghead, (int)2, (short)this.dggContainer.getRecordId());
        LittleEndian.putInt((byte[])dgghead, (int)4, (int)size);
        out.write(dgghead);
        out.write(bout.toByteArray());
    }

    public EscherContainerRecord getDggContainer() {
        return this.dggContainer;
    }

    public EscherDggRecord getEscherDggRecord() {
        if (this.dgg == null) {
            Iterator it = this.dggContainer.getChildIterator();
            while (it.hasNext()) {
                EscherRecord r = (EscherRecord)it.next();
                if (!(r instanceof EscherDggRecord)) continue;
                this.dgg = (EscherDggRecord)r;
                break;
            }
        }
        return this.dgg;
    }
}

