/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.sequencer.teiid.DefaultProperties;

public class DefaultPropertiesTest {
    @Test
    public void shouldFindDefaultValuesGivenExplicitlyOnTypes() throws IOException {
        this.assertDefault("xmi:model", "xmi:version", "2.0");
        this.assertDefault("mmcore:model", "mmcore:modelType", "UNKNOWN");
        this.assertDefault("mmcore:model", "mmcore:supportsDistinct", true);
        this.assertDefault("mmcore:model", "mmcore:supportsWhereAll", true);
        this.assertDefault("mmcore:import", "mmcore:modelType", "UNKNOWN");
        this.assertDefault("relational:column", "relational:nullable", "NULLABLE");
        this.assertDefault("relational:column", "relational:autoIncremented", false);
        this.assertDefault("relational:column", "relational:selectable", true);
        this.assertDefault("relational:column", "relational:searchability", "SEARCHABLE");
        this.assertDefault("relational:column", "relational:radix", 10L);
        this.assertDefault("relational:column", "relational:nullValueCount", -1L);
        this.assertDefault("relational:foreignKey", "relational:foreignKeyMultiplicity", "ZERO_TO_MANY");
        this.assertDefault("relational:foreignKey", "relational:primaryKeyMultiplicity", "ONE");
        this.assertDefault("relational:index", "relational:nullable", true);
        this.assertDefault("relational:table", "relational:system", false);
        this.assertDefault("relational:procedureParameter", "relational:direction", null);
        this.assertDefault("relational:procedureParameter", "relational:nullable", "NULLABLE");
        this.assertDefault("relational:procedure", "relational:updateCount", null);
        this.assertDefault("relational:logicalRelationshipEnd", "relational:multiplicity", null);
        this.assertDefault("transform:withSql", "transform:insertAllowed", true);
        this.assertDefault("transform:withSql", "transform:outputLocked", false);
        this.assertDefault("jdbcs:imported", "jdbcs:convertCaseInModel", null);
        this.assertDefault("jdbcs:imported", "jdbcs:generateSourceNamesInModel", "UNQUALIFIED");
    }

    @Test
    public void shouldFindDefaultValuesInheritedByTypes() throws IOException {
        this.assertDefault("relational:baseTable", "relational:system", false);
        this.assertDefault("relational:view", "relational:system", false);
    }

    @Test
    public void shouldFindSupertypeNames() {
        this.assertSupertypes("relational:column, foo:bar mixin someting", "relational:column", "foo:bar");
    }

    protected void assertDefault(String nodeTypeName, String propertyName, Object value) throws IOException {
        Assert.assertThat((Object)DefaultProperties.getDefaults().getDefaultFor(nodeTypeName, propertyName), (Matcher)Is.is((Object)value));
    }

    protected void assertSupertypes(String line, String ... supertypeNames) {
        List actual = DefaultProperties.findSupertypes((String)line);
        Assert.assertThat((Object)actual, (Matcher)Is.is(Arrays.asList(supertypeNames)));
    }
}

