/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.extractor.teiid;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.modeshape.common.text.UrlEncoder;
import org.modeshape.common.util.IoUtil;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.text.TextExtractor;
import org.modeshape.graph.text.TextExtractorContext;
import org.modeshape.graph.text.TextExtractorOutput;
import org.modeshape.sequencer.teiid.TeiidI18n;
import org.modeshape.sequencer.teiid.VdbManifest;
import org.modeshape.sequencer.teiid.VdbModel;
import org.modeshape.sequencer.teiid.VdbSequencer;
import org.modeshape.sequencer.teiid.lexicon.VdbLexicon;

public class TeiidVdbTextExtractor
implements TextExtractor {
    private static final UrlEncoder URL_ENCODER = new UrlEncoder();

    public boolean supportsMimeType(String mimeType) {
        return "application/vnd.teiid.vdb".equals(mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractFrom(InputStream stream, TextExtractorOutput output, TextExtractorContext context) throws IOException {
        ValueFactory stringFactory = context.getValueFactories().getStringFactory();
        AtomicInteger version = new AtomicInteger(0);
        Path pathToArchiveFile = context.getInputPath();
        Name zipFileName = VdbLexicon.VIRTUAL_DATABASE;
        if (pathToArchiveFile != null && !pathToArchiveFile.isRoot()) {
            if (pathToArchiveFile.getLastSegment().getName().equals(JcrLexicon.CONTENT)) {
                pathToArchiveFile = pathToArchiveFile.getParent();
            }
            if (!pathToArchiveFile.isRoot()) {
                zipFileName = pathToArchiveFile.getLastSegment().getName();
                String fileNameWithoutExtension = zipFileName.getLocalName().replaceAll("\\.vdb$", "");
                zipFileName = context.getValueFactories().getNameFactory().create(zipFileName.getNamespaceUri(), fileNameWithoutExtension);
                String name = (String)stringFactory.create(zipFileName);
                zipFileName = VdbSequencer.extractVersionInfomation((ExecutionContext)context, name, version);
            }
        }
        assert (zipFileName != null);
        File vdbArchiveFile = null;
        try {
            String prefix = "modeshape" + URL_ENCODER.encode((String)stringFactory.create(zipFileName));
            vdbArchiveFile = File.createTempFile(prefix, "vdb");
            BufferedOutputStream ostream = new BufferedOutputStream(new FileOutputStream(vdbArchiveFile));
            IoUtil.write((InputStream)stream, (OutputStream)ostream);
            ZipFile vdbArchive = new ZipFile(vdbArchiveFile);
            ZipEntry vdbXml = vdbArchive.getEntry("META-INF/vdb.xml");
            if (vdbXml == null) {
                return;
            }
            VdbManifest manifest = VdbManifest.read(vdbArchive.getInputStream(vdbXml), (ExecutionContext)context);
            if (version.get() != 0) {
                manifest.setVersion(version.get());
            }
            output.recordText((String)stringFactory.create(zipFileName));
            output.recordText(manifest.getName());
            output.recordText(manifest.getDescription());
            output.recordText(Integer.toString(manifest.getVersion()));
            for (VdbModel model : manifest.getModels()) {
                output.recordText(model.getName());
                output.recordText(model.getType());
                output.recordText(model.getSourceName());
                output.recordText(model.getSourceTranslator());
                output.recordText(model.getSourceJndiName());
            }
        }
        catch (Exception e) {
            String location = (String)context.getValueFactories().getStringFactory().create(context.getInputPath());
            context.getProblems().addError((Throwable)e, TeiidI18n.errorReadingVdbFile, new Object[]{location, e.getMessage()});
        }
        finally {
            if (vdbArchiveFile != null) {
                vdbArchiveFile.delete();
            }
        }
    }
}

