/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.modeshape.common.collection.Multimap;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.teiid.TeiidI18n;
import org.modeshape.sequencer.teiid.VdbModel;
import org.modeshape.sequencer.teiid.model.CoreModelObjectHandler;
import org.modeshape.sequencer.teiid.model.DiagramModelObjectHandler;
import org.modeshape.sequencer.teiid.model.JdbcModelObjectHandler;
import org.modeshape.sequencer.teiid.model.ModelObjectHandler;
import org.modeshape.sequencer.teiid.model.ModelReader;
import org.modeshape.sequencer.teiid.model.ReferenceResolver;
import org.modeshape.sequencer.teiid.model.RelationalModelObjectHandler;
import org.modeshape.sequencer.teiid.model.TransformationModelObjectHandler;
import org.modeshape.sequencer.teiid.xmi.XmiElement;

public final class ModelNodeWriter {
    private static final Logger LOGGER = Logger.getLogger(ModelNodeWriter.class);
    private static final boolean DEBUG = false;
    private final Sequencer.Context context;
    private final Map<String, ModelObjectHandler> handlers = new HashMap<String, ModelObjectHandler>();
    private final Node outputNode;
    private final ModelReader reader;
    private final Map<String, Class<? extends ModelObjectHandler>> registry = new HashMap<String, Class<? extends ModelObjectHandler>>();
    private final ReferenceResolver resolver;
    private final VdbModel vdbModel;

    private void debug(String message) {
        LOGGER.debug(message, new Object[0]);
    }

    ModelNodeWriter(Node modelNode, ModelReader reader, ReferenceResolver resolver, VdbModel vdbModel, Sequencer.Context context) throws Exception {
        CheckArg.isNotNull((Object)modelNode, (String)"modelNode");
        CheckArg.isNotNull((Object)reader, (String)"reader");
        CheckArg.isNotNull((Object)resolver, (String)"resolver");
        CheckArg.isNotNull((Object)context, (String)"context");
        if (!modelNode.isNodeType("mmcore:model")) {
            throw new RuntimeException(TeiidI18n.invalidModelNodeType.text(new Object[]{modelNode.getPath()}));
        }
        this.outputNode = modelNode;
        this.resolver = resolver;
        this.reader = reader;
        this.vdbModel = vdbModel;
        this.context = context;
    }

    private ModelObjectHandler getHandler(String namespaceUri) throws Exception {
        CheckArg.isNotEmpty((String)namespaceUri, (String)"namespaceUri");
        ModelObjectHandler handler = this.handlers.get(namespaceUri);
        if (handler == null && this.registry.containsKey(namespaceUri)) {
            Class<? extends ModelObjectHandler> handlerClass = this.registry.get(namespaceUri);
            handler = handlerClass.newInstance();
            this.handlers.put(namespaceUri, handler);
            handler.setContext(this.context);
            handler.setReader(this.reader);
            handler.setResolver(this.resolver);
            handler.setVdbModel(this.vdbModel);
        }
        return handler;
    }

    public boolean isAcceptedPrimaryMetamodel(String uri) {
        return "http://www.metamatrix.com/metamodels/Relational".equals(uri);
    }

    private void loadRegistry() {
        this.registry.put("http://www.metamatrix.com/metamodels/Core", CoreModelObjectHandler.class);
        this.registry.put("http://www.metamatrix.com/metamodels/Diagram", DiagramModelObjectHandler.class);
        this.registry.put("http://www.metamatrix.com/metamodels/JDBC", JdbcModelObjectHandler.class);
        this.registry.put("http://www.metamatrix.com/metamodels/Relational", RelationalModelObjectHandler.class);
        this.registry.put("http://www.metamatrix.com/metamodels/Transformation", TransformationModelObjectHandler.class);
    }

    public boolean write() throws Exception {
        long startTime = System.currentTimeMillis();
        boolean result = true;
        String primaryMetamodelUri = this.reader.getPrimaryMetamodelUri();
        if (primaryMetamodelUri == null || !this.isAcceptedPrimaryMetamodel(primaryMetamodelUri)) {
            result = false;
        } else {
            this.loadRegistry();
            result = !this.writeModelObjects() ? false : this.writeUnresolvedReferences();
        }
        this.debug("\n\nmodel write time=" + (System.currentTimeMillis() - startTime));
        return result;
    }

    private boolean writeModelObjects() throws Exception {
        this.debug("\n\n[begin writeModelObjects()]");
        for (XmiElement element : this.reader.getElements()) {
            String nsUri = element.getNamespaceUri();
            ModelObjectHandler handler = this.getHandler(nsUri);
            if (handler == null) {
                this.debug("ModelObjectHandler for namespace " + nsUri + " cannot be found");
                continue;
            }
            handler.process(element, this.outputNode);
        }
        this.debug("[end writeModelObjects()]\n\n");
        return true;
    }

    public boolean writeUnresolvedReferences() throws Exception {
        this.debug("\n\n[begin writeUnresolvedReferences()]");
        ArrayList resolvedReferences = new ArrayList();
        for (Map.Entry<String, ReferenceResolver.UnresolvedReference> entry : this.resolver.getUnresolved().entrySet()) {
            int i;
            boolean multiValued;
            Node resolved = this.resolver.getNode(entry.getKey());
            if (resolved == null) {
                this.debug("**** uuid " + entry.getKey() + " is still unresolved during last phase of writing model");
                continue;
            }
            ReferenceResolver.UnresolvedReference unresolved = entry.getValue();
            ValueFactory valueFactory = resolved.getSession().getValueFactory();
            for (String mixin : unresolved.getMixins()) {
                resolved.addMixin(mixin);
                this.debug("adding mixin " + mixin + " to resolved node " + resolved.getName());
            }
            for (String propName : unresolved.getProperties().keySet()) {
                ReferenceResolver.UnresolvedProperty property = unresolved.getProperties().get(propName);
                assert (property != null);
                multiValued = property.isMulti();
                if (multiValued) {
                    Value[] propertyValues = new Value[property.getValues().size()];
                    i = 0;
                    for (String value : property.getValues()) {
                        propertyValues[i++] = valueFactory.createValue(value);
                    }
                    continue;
                }
                resolved.setProperty(propName, property.getValue());
                this.debug("setting property '" + propName + "' with value '" + property.getValue() + "' to resolved node " + resolved.getName());
            }
            for (String propertyName : unresolved.getReferences().keySet()) {
                Collection refs = unresolved.getReferences().get((Object)propertyName);
                if (refs == null || refs.isEmpty()) continue;
                multiValued = false;
                if (resolved.hasProperty(propertyName)) {
                    multiValued = resolved.getProperty(propertyName).isMultiple();
                    if (multiValued) {
                        Value[] values = new Value[refs.size()];
                        i = 0;
                        for (String value : refs) {
                            Node referencedNode = this.resolver.getNode(value);
                            if (referencedNode == null) {
                                this.resolver.addUnresolvedReference(value);
                                continue;
                            }
                            values[i++] = valueFactory.createValue(referencedNode, true);
                        }
                        resolved.setProperty(propertyName, values);
                        continue;
                    }
                    resolved.setProperty(propertyName, (String)refs.iterator().next());
                    continue;
                }
                this.debug("**** resolved property is multi-value and is not being processed");
            }
            for (String propertyName : unresolved.getReferenceNames().keySet()) {
                Collection referencerUuids = unresolved.getReferenceNames().get((Object)propertyName);
                if (referencerUuids == null || referencerUuids.isEmpty()) continue;
                for (String uuid : referencerUuids) {
                    Node referencerNode = this.resolver.getNode(uuid);
                    if (referencerNode == null) {
                        ReferenceResolver.UnresolvedReference unresolvedReferencer = this.resolver.addUnresolvedReference(uuid);
                        unresolvedReferencer.addProperty(propertyName, resolved.getName(), true);
                        continue;
                    }
                    referencerNode.setProperty(propertyName, new Value[]{this.context.valueFactory().createValue(resolved.getName())});
                }
            }
            Multimap<String, String> refRefs = unresolved.getReferencerReferences();
            for (String propertyName : refRefs.keySet()) {
                if (!resolved.isNodeType("mix:referenceable")) {
                    resolved.addMixin("mix:referenceable");
                }
                Value weakRef = valueFactory.createValue(resolved, true);
                for (String referencerUuuid : refRefs.get((Object)propertyName)) {
                    Node referencer = this.resolver.getNode(referencerUuuid);
                    if (referencer == null) {
                        ReferenceResolver.UnresolvedReference unresolvedReferencer = this.resolver.addUnresolvedReference(referencerUuuid);
                        unresolvedReferencer.addReference(propertyName, entry.getKey());
                        continue;
                    }
                    if (referencer.hasProperty(propertyName)) {
                        Property prop = referencer.getProperty(propertyName);
                        if (prop.isMultiple()) {
                            Value[] currentValues = prop.getValues();
                            Value[] newValues = new Value[currentValues.length + 1];
                            System.arraycopy(currentValues, 0, newValues, 0, currentValues.length);
                            newValues[currentValues.length] = weakRef;
                            referencer.setProperty(propertyName, newValues);
                            continue;
                        }
                        referencer.setProperty(propertyName, weakRef);
                        continue;
                    }
                    this.debug("**** weak reference property could be multi-value here");
                }
            }
        }
        if (!resolvedReferences.isEmpty()) {
            for (ReferenceResolver.UnresolvedReference unresolved : resolvedReferences) {
                this.resolver.resolved(unresolved);
            }
        }
        this.debug("number unresolved at end=" + this.resolver.getUnresolved().size());
        this.debug("[end writeUnresolvedReferences()]\n\n");
        return true;
    }
}

