/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid.xmi;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.sequencer.teiid.xmi.XmiAttribute;
import org.modeshape.sequencer.teiid.xmi.XmiElement;

public class XmiReader {
    protected Logger logger = Logger.getLogger(this.getClass());
    protected static final boolean DEBUG = false;
    private final List<XmiElement> elements = new ArrayList<XmiElement>();
    private boolean keepReading = true;
    private final Map<String, String> namespaces = new HashMap<String, String>();
    private final String path;
    private final Stack<XmiElement> stack = new Stack();

    protected void debug(String message) {
        this.logger.debug(message, new Object[0]);
    }

    private static String getIndent(int stackSize) {
        StringBuilder indent = new StringBuilder();
        for (int i = 0; i < stackSize; ++i) {
            if (i == 0) continue;
            indent.append("  ");
        }
        return indent.toString();
    }

    protected XmiReader(String path) {
        CheckArg.isNotEmpty((String)path, (String)"path");
        this.path = path;
    }

    protected void addAttribute(XmiElement element, XmiAttribute attribute) {
        CheckArg.isNotNull((Object)element, (String)"element");
        CheckArg.isNotNull((Object)attribute, (String)"attribute");
        element.addAttribute(attribute);
    }

    protected void addChild(XmiElement parent, XmiElement newChild) {
        CheckArg.isNotNull((Object)parent, (String)"parent");
        CheckArg.isNotNull((Object)newChild, (String)"newChild");
        parent.addChild(newChild);
    }

    protected void addElement(XmiElement newElement) {
        CheckArg.isNotNull((Object)newElement, (String)"newElement");
        this.elements.add(newElement);
    }

    protected void createAttributes(XMLStreamReader streamReader, XmiElement element) {
        CheckArg.isNotNull((Object)streamReader, (String)"streamReader");
        CheckArg.isNotNull((Object)element, (String)"element");
        int size = streamReader.getAttributeCount();
        for (int i = 0; i < size; ++i) {
            XmiAttribute newAttribute = new XmiAttribute(streamReader.getAttributeName(i).getLocalPart());
            newAttribute.setNamespacePrefix(streamReader.getAttributePrefix(i));
            newAttribute.setNamespaceUri(streamReader.getAttributeNamespace(i));
            newAttribute.setValue(streamReader.getAttributeValue(i));
            this.addAttribute(element, newAttribute);
            this.debug(XmiReader.getIndent(this.stack.size()) + "  added attribute: " + newAttribute);
        }
    }

    public List<XmiElement> getElements() {
        return this.elements;
    }

    protected List<XmiElement> getElements(String namespaceUri) {
        CheckArg.isNotEmpty((String)namespaceUri, (String)"namespaceUri");
        ArrayList<XmiElement> namespacedElements = new ArrayList<XmiElement>();
        for (XmiElement element : this.getElements()) {
            if (!namespaceUri.equals(element.getNamespaceUri())) continue;
            namespacedElements.add(element);
        }
        return namespacedElements;
    }

    protected Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public String getPath() {
        return this.path;
    }

    public String getResourceName() {
        int index = this.path.lastIndexOf(File.separator);
        if (index == -1) {
            return this.path;
        }
        return this.path.substring(index + 1);
    }

    protected int getStackSize() {
        return this.stack.size();
    }

    protected void handleCharacters(XMLStreamReader streamReader) {
        CheckArg.isNotNull((Object)streamReader, (String)"streamReader");
        String value = streamReader.getText();
        if (!StringUtil.isBlank((String)value) && !this.stack.isEmpty()) {
            this.stack.peek().setValue(value);
        } else if (!StringUtil.isBlank((String)value)) {
            this.debug("**** unhandled XmiReader CHARACTERS event type. Character=" + streamReader.getText());
        }
    }

    protected XmiElement handleEndElement(XMLStreamReader streamReader) {
        CheckArg.isNotNull((Object)streamReader, (String)"streamReader");
        XmiElement popped = this.pop(streamReader);
        this.debug(XmiReader.getIndent(this.stack.size() + 1) + "end:elementName=" + streamReader.getLocalName() + ", popped=" + popped);
        return popped;
    }

    protected void handleOtherEvents(XMLStreamReader streamReader) {
        CheckArg.isNotNull((Object)streamReader, (String)"streamReader");
        this.debug("**** unhandled XmiReader event of type " + streamReader.getEventType());
    }

    protected XmiElement handleStartElement(XMLStreamReader streamReader) throws Exception {
        CheckArg.isNotNull((Object)streamReader, (String)"streamReader");
        XmiElement element = new XmiElement(streamReader.getLocalName());
        element.setNamespaceUri(streamReader.getNamespaceURI());
        element.setNamespacePrefix(streamReader.getPrefix());
        if (streamReader.hasText()) {
            element.setValue(streamReader.getElementText());
        }
        this.push(element);
        this.debug(XmiReader.getIndent(this.stack.size()) + "startElement: " + element);
        this.createAttributes(streamReader, element);
        if ("XMI".equals(streamReader.getLocalName())) {
            int size = streamReader.getNamespaceCount();
            for (int i = 0; i < size; ++i) {
                String nsPrefix = streamReader.getNamespacePrefix(i);
                String nsUri = streamReader.getNamespaceURI(i);
                this.namespaces.put(nsPrefix, nsUri);
                this.debug("registered namespace " + nsPrefix + '=' + nsUri + " to model");
            }
        }
        return element;
    }

    protected XmiElement pop(XMLStreamReader streamReader) {
        CheckArg.isNotNull((Object)streamReader, (String)"streamReader");
        return this.stack.pop();
    }

    protected void push(XmiElement element) {
        CheckArg.isNotNull((Object)element, (String)"element");
        if (this.stack.isEmpty()) {
            this.addElement(element);
        } else {
            this.addChild(this.stack.peek(), element);
        }
        this.stack.push(element);
    }

    protected final List<XmiElement> read(InputStream stream) throws Exception {
        CheckArg.isNotNull((Object)stream, (String)"stream");
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader streamReader = factory.createXMLStreamReader(stream);
        while (this.keepReading && streamReader.hasNext()) {
            streamReader.next();
            if (streamReader.isStartElement()) {
                this.handleStartElement(streamReader);
                continue;
            }
            if (streamReader.isEndElement()) {
                this.handleEndElement(streamReader);
                continue;
            }
            if (streamReader.isCharacters()) {
                this.handleCharacters(streamReader);
                continue;
            }
            this.handleOtherEvents(streamReader);
        }
        return this.elements;
    }

    protected void stop() {
        this.keepReading = false;
    }
}

