/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.teiid.TeiidI18n;
import org.modeshape.sequencer.teiid.VdbDataRole;
import org.modeshape.sequencer.teiid.VdbEntry;
import org.modeshape.sequencer.teiid.VdbManifest;
import org.modeshape.sequencer.teiid.VdbModel;
import org.modeshape.sequencer.teiid.VdbTranslator;
import org.modeshape.sequencer.teiid.model.ModelSequencer;
import org.modeshape.sequencer.teiid.model.ReferenceResolver;

public class VdbSequencer
extends Sequencer {
    private static final Logger LOGGER = Logger.getLogger(VdbSequencer.class);
    private static final boolean DEBUG = false;
    private static final String MANIFEST_FILE = "/META-INF/vdb.xml";
    private static final Pattern VERSION_REGEX = Pattern.compile("(.*)[.]\\s*[+-]?([0-9]+)\\s*$");
    private ModelSequencer modelSequencer;
    private ReferenceResolver resolver;

    private void debug(String message) {
        LOGGER.debug(message, new Object[0]);
    }

    public static String extractVersionInfomation(String fileNameWithoutExtension, AtomicInteger version) {
        Matcher matcher = VERSION_REGEX.matcher(fileNameWithoutExtension);
        if (matcher.matches()) {
            fileNameWithoutExtension = matcher.group(1);
            version.set(Integer.parseInt(matcher.group(2)));
        }
        return fileNameWithoutExtension.replaceAll("[.]*$", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        boolean entryName222;
        ZipInputStream vdbStream;
        block18: {
            this.debug("VdbSequencer.execute called:outputNode name=" + outputNode.getName() + ", path=" + outputNode.getPath());
            javax.jcr.Binary binaryValue = inputProperty.getBinary();
            CheckArg.isNotNull((Object)binaryValue, (String)"binary");
            vdbStream = null;
            vdbStream = new ZipInputStream(binaryValue.getStream());
            VdbManifest manifest = null;
            ZipEntry entry = null;
            while ((entry = vdbStream.getNextEntry()) != null) {
                String entryName222 = entry.getName();
                if (entryName222.endsWith(MANIFEST_FILE)) {
                    this.debug("----before reading vdb.xml");
                    manifest = VdbManifest.read(vdbStream, context);
                    assert (manifest != null) : "manifest is null";
                    outputNode.setPrimaryType("vdb:virtualDatabase");
                    outputNode.addMixin("mix:referenceable");
                    outputNode.setProperty("vdb:version", (long)manifest.getVersion());
                    outputNode.setProperty("vdb:originalFile", outputNode.getPath());
                    outputNode.setProperty("mode:sha1", ((Binary)binaryValue).getHexHash());
                    this.setProperty(outputNode, "vdb:description", manifest.getDescription());
                    this.sequenceTranslators(manifest, outputNode);
                    this.sequenceDataRoles(manifest, outputNode);
                    this.sequenceEntries(manifest, outputNode);
                    this.sequenceProperties(manifest, outputNode);
                    this.debug(">>>>done reading vdb.xml\n\n");
                    continue;
                }
                if (!entry.isDirectory() && this.modelSequencer.hasModelFileExtension(entryName222)) {
                    int index;
                    this.debug("----before reading model " + entryName222);
                    VdbModel vdbModel = null;
                    if (manifest != null) {
                        String pathInVdb = entryName222;
                        int index2 = entryName222.indexOf(47);
                        if (index2 != -1) {
                            pathInVdb = entryName222.substring(index2);
                        }
                        vdbModel = manifest.getModel(pathInVdb);
                    }
                    if ((index = entryName222.lastIndexOf(47) + 1) != -1 && index < entryName222.length()) {
                        entryName222 = entryName222.substring(index);
                    }
                    Node modelNode = outputNode.addNode(entryName222, "vdb:model");
                    this.modelSequencer.sequenceVdbModel(vdbStream, modelNode, vdbModel, context);
                    this.debug(">>>>done reading model " + entryName222 + "\n\n");
                    continue;
                }
                this.debug("----ignoring resource " + entryName222);
            }
            entryName222 = true;
            if (vdbStream == null) break block18;
            try {
                vdbStream.close();
            }
            catch (Exception e) {
                this.getLogger().warn((Throwable)e, TeiidI18n.errorClosingVdbFile.text(new Object[]{inputProperty.getPath(), e.getMessage()}), new Object[0]);
            }
        }
        return entryName222;
        catch (Exception e) {
            boolean bl;
            block19: {
                try {
                    this.getLogger().error((Throwable)e, TeiidI18n.errorReadingVdbFile.text(new Object[]{inputProperty.getPath(), e.getMessage()}), new Object[0]);
                    bl = false;
                    if (vdbStream == null) break block19;
                }
                catch (Throwable throwable) {
                    if (vdbStream != null) {
                        try {
                            vdbStream.close();
                        }
                        catch (Exception e2) {
                            this.getLogger().warn((Throwable)e2, TeiidI18n.errorClosingVdbFile.text(new Object[]{inputProperty.getPath(), e2.getMessage()}), new Object[0]);
                        }
                    }
                    throw throwable;
                }
                try {
                    vdbStream.close();
                }
                catch (Exception e3) {
                    this.getLogger().warn((Throwable)e3, TeiidI18n.errorClosingVdbFile.text(new Object[]{inputProperty.getPath(), e3.getMessage()}), new Object[0]);
                }
            }
            return bl;
        }
    }

    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        registry.registerNamespace("vdb", "http://www.metamatrix.com/metamodels/VirtualDatabase");
        registry.registerNamespace("xmi", "http://www.omg.org/XMI");
        registry.registerNamespace("mmcore", "http://www.metamatrix.com/metamodels/Core");
        this.registerNodeTypes("xmi.cnd", nodeTypeManager, true);
        this.registerNodeTypes("mmcore.cnd", nodeTypeManager, true);
        this.registerNodeTypes("vdb.cnd", nodeTypeManager, true);
        this.resolver = new ReferenceResolver();
        this.modelSequencer = new ModelSequencer(this.resolver);
        this.modelSequencer.initialize(registry, nodeTypeManager);
    }

    private void sequenceDataRoles(VdbManifest manifest, Node outputNode) throws Exception {
        assert (manifest != null) : "manifest is null";
        assert (outputNode != null) : "outputNode is null";
        List<VdbDataRole> dataRolesGroup = manifest.getDataRoles();
        if (!dataRolesGroup.isEmpty()) {
            Node dataRolesGroupNode = outputNode.addNode("vdb:dataRoles", "vdb:dataRoles");
            for (VdbDataRole dataRole : dataRolesGroup) {
                List<VdbDataRole.Permission> permissionsGroup;
                Node dataRoleNode = dataRolesGroupNode.addNode(dataRole.getName(), "vdb:dataRole");
                this.setProperty(dataRoleNode, "vdb:description", dataRole.getDescription());
                dataRoleNode.setProperty("vdb:anyAuthenticated", dataRole.isAnyAuthenticated());
                dataRoleNode.setProperty("vdb:allowCreateTemporaryTables", dataRole.isAllowCreateTempTables());
                List<String> roleNames = dataRole.getMappedRoleNames();
                if (!roleNames.isEmpty()) {
                    dataRoleNode.setProperty("vdb:mappedRoleNames", roleNames.toArray(new String[roleNames.size()]));
                }
                if ((permissionsGroup = dataRole.getPermissions()).isEmpty()) continue;
                Node permissionsGroupNode = dataRoleNode.addNode("vdb:permissions", "vdb:permissions");
                for (VdbDataRole.Permission permission : permissionsGroup) {
                    Node permissionNode = permissionsGroupNode.addNode(permission.getResourceName(), "vdb:permission");
                    permissionNode.setProperty("vdb:allowAlter", permission.canAlter());
                    permissionNode.setProperty("vdb:allowCreate", permission.canCreate());
                    permissionNode.setProperty("vdb:allowDelete", permission.canDelete());
                    permissionNode.setProperty("vdb:allowExecute", permission.canExecute());
                    permissionNode.setProperty("vdb:allowRead", permission.canRead());
                    permissionNode.setProperty("vdb:allowUpdate", permission.canUpdate());
                }
            }
        }
    }

    private void sequenceEntries(VdbManifest manifest, Node outputNode) throws Exception {
        assert (manifest != null) : "manifest is null";
        assert (outputNode != null) : "outputNode is null";
        List<VdbEntry> entriesGroup = manifest.getEntries();
        if (!entriesGroup.isEmpty()) {
            Node entriesGroupNode = outputNode.addNode("vdb:entries", "vdb:entries");
            for (VdbEntry entry : entriesGroup) {
                Node entryNode = entriesGroupNode.addNode("vdb:entry", "vdb:entry");
                this.setProperty(entryNode, "vdb:path", entry.getPath());
                this.setProperty(entryNode, "vdb:description", entry.getDescription());
                Map<String, String> props = entry.getProperties();
                if (props.isEmpty()) continue;
                for (Map.Entry<String, String> prop : props.entrySet()) {
                    this.setProperty(entryNode, prop.getKey(), prop.getValue());
                }
            }
        }
    }

    private void sequenceProperties(VdbManifest manifest, Node outputNode) throws Exception {
        assert (manifest != null) : "manifest is null";
        assert (outputNode != null) : "outputNode is null";
        Map<String, String> props = manifest.getProperties();
        if (!props.isEmpty()) {
            for (Map.Entry<String, String> prop : props.entrySet()) {
                if ("preview".equals(prop.getKey())) {
                    outputNode.setProperty("vdb:preview", Boolean.parseBoolean(prop.getValue()));
                    continue;
                }
                this.setProperty(outputNode, prop.getKey(), prop.getValue());
            }
        }
    }

    private void sequenceTranslators(VdbManifest manifest, Node outputNode) throws Exception {
        assert (manifest != null) : "manifest is null";
        assert (outputNode != null) : "outputNode is null";
        List<VdbTranslator> translatorsGroup = manifest.getTranslators();
        if (!translatorsGroup.isEmpty()) {
            Node translatorsGroupNode = outputNode.addNode("vdb:translators", "vdb:translators");
            for (VdbTranslator translator : translatorsGroup) {
                Node translatorNode = translatorsGroupNode.addNode(translator.getName(), "vdb:translator");
                this.setProperty(translatorNode, "vdb:type", translator.getType());
                this.setProperty(translatorNode, "vdb:description", translator.getDescription());
                Map<String, String> props = translator.getProperties();
                if (props.isEmpty()) continue;
                for (Map.Entry<String, String> prop : props.entrySet()) {
                    this.setProperty(translatorNode, prop.getKey(), prop.getValue());
                }
            }
        }
    }

    private void setProperty(Node node, String name, String value) throws Exception {
        assert (node != null);
        assert (!StringUtil.isBlank((String)name));
        if (!StringUtil.isBlank((String)value)) {
            node.setProperty(name, value);
        }
    }
}

