/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid.xmi;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.sequencer.teiid.xmi.XmiBasePart;

public class XmiBasePartTest {
    private static final String INITIAL_NAME = "partName";
    private XmiBasePart part;

    @Before
    public void beforeEach() {
        this.part = new XmiBasePart(INITIAL_NAME){};
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowEmptyNameAtConstruction() {
        new XmiBasePart(""){};
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullNameAtConstruction() {
        new XmiBasePart(null){};
    }

    @Test
    public void shouldSetNameAtConstruction() {
        Assert.assertThat((Object)this.part.getName(), (Matcher)Is.is((Object)INITIAL_NAME));
    }

    @Test
    public void shouldSetNamespacePrefix() {
        String expected = "newPrefix";
        this.part.setNamespacePrefix("newPrefix");
        Assert.assertThat((Object)this.part.getNamespacePrefix(), (Matcher)Is.is((Object)"newPrefix"));
    }

    @Test
    public void shouldSetNamespacePrefixToNull() {
        String expected = null;
        this.part.setNamespacePrefix(expected);
        Assert.assertThat((Object)this.part.getNamespacePrefix(), (Matcher)Is.is(expected));
    }

    @Test
    public void shouldSetNamespacePrefixToEmpty() {
        String expected = "";
        this.part.setNamespacePrefix("");
        Assert.assertThat((Object)this.part.getNamespacePrefix(), (Matcher)Is.is((Object)""));
    }

    @Test
    public void shouldSetNamespaceUri() {
        String expected = "newUri";
        this.part.setNamespaceUri("newUri");
        Assert.assertThat((Object)this.part.getNamespaceUri(), (Matcher)Is.is((Object)"newUri"));
    }

    @Test
    public void shouldSetNamespaceUriToNull() {
        String expected = null;
        this.part.setNamespaceUri(expected);
        Assert.assertThat((Object)this.part.getNamespaceUri(), (Matcher)Is.is(expected));
    }

    @Test
    public void shouldSetNamespaceUriToEmpty() {
        String expected = "";
        this.part.setNamespaceUri("");
        Assert.assertThat((Object)this.part.getNamespaceUri(), (Matcher)Is.is((Object)""));
    }

    @Test
    public void shouldSetValue() {
        String expected = "newValue";
        this.part.setValue("newValue");
        Assert.assertThat((Object)this.part.getValue(), (Matcher)Is.is((Object)"newValue"));
    }

    @Test
    public void shouldSetValueToNull() {
        String expected = null;
        this.part.setValue(expected);
        Assert.assertThat((Object)this.part.getValue(), (Matcher)Is.is(expected));
    }

    @Test
    public void shouldSetValueToEmpty() {
        String expected = "";
        this.part.setValue("");
        Assert.assertThat((Object)this.part.getValue(), (Matcher)Is.is((Object)""));
    }

    @Test
    public void shouldHaveQNameEqualToNameWhenNoPrefix() {
        Assert.assertThat((Object)this.part.getQName(), (Matcher)Is.is((Object)INITIAL_NAME));
    }

    @Test
    public void shouldHaveCorrectQName() {
        String prefix = "prefix";
        this.part.setNamespacePrefix("prefix");
        Assert.assertThat((Object)this.part.getQName(), (Matcher)Is.is((Object)"prefix:partName"));
    }

    @Test
    public void shouldBeEqualWhenStateIsTheSame() {
        XmiBasePart thatPart = new XmiBasePart(this.part.getName()){};
        thatPart.setNamespacePrefix("prefix");
        this.part.setNamespacePrefix(thatPart.getNamespacePrefix());
        thatPart.setNamespaceUri("uri");
        this.part.setNamespaceUri(thatPart.getNamespaceUri());
        thatPart.setValue("value");
        this.part.setValue(thatPart.getValue());
        Assert.assertThat((Object)this.part, (Matcher)Is.is((Object)thatPart));
    }

    @Test
    public void shouldNotBeEqualWhenStateIsDifferent() {
        XmiBasePart thatPart = new XmiBasePart(this.part.getName()){};
        thatPart.setNamespacePrefix("prefix");
        Assert.assertFalse((boolean)this.part.equals((Object)thatPart));
        this.part.setNamespacePrefix(thatPart.getNamespacePrefix());
        thatPart.setNamespaceUri("uri");
        Assert.assertFalse((boolean)this.part.equals((Object)thatPart));
        this.part.setNamespaceUri(thatPart.getNamespaceUri());
        thatPart.setValue("value");
        Assert.assertFalse((boolean)this.part.equals((Object)thatPart));
        this.part.setValue(thatPart.getValue());
        Assert.assertThat((Object)this.part, (Matcher)Is.is((Object)thatPart));
    }

    @Test
    public void shouldHaveSameHascodeWhenStateIsEqual() {
        XmiBasePart thatPart = new XmiBasePart(this.part.getName()){};
        thatPart.setNamespacePrefix("prefix");
        this.part.setNamespacePrefix(thatPart.getNamespacePrefix());
        thatPart.setNamespaceUri("uri");
        this.part.setNamespaceUri(thatPart.getNamespaceUri());
        thatPart.setValue("value");
        this.part.setValue(thatPart.getValue());
        Assert.assertThat((Object)this.part.hashCode(), (Matcher)Is.is((Object)thatPart.hashCode()));
    }
}

