/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.jcr.Node;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.collection.ArrayListMultimap;
import org.modeshape.common.collection.Multimap;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.sequencer.teiid.TeiidI18n;
import org.modeshape.sequencer.teiid.xmi.XmiElement;

@NotThreadSafe
public class ReferenceResolver {
    static final Logger LOGGER = Logger.getLogger(ReferenceResolver.class);
    public static final Map<String, String> STANDARD_DATA_TYPE_URLS_BY_UUID;
    public static final Map<String, String> STANDARD_DATA_TYPE_URLS_TO_NAMES;
    public static final Map<String, String> STANDARD_DATA_TYPE_UUIDS_BY_NAMES;
    private final Map<String, UnresolvedReference> unresolved = new HashMap<String, UnresolvedReference>();
    private final Map<String, Node> uuidToNode = new HashMap<String, Node>();
    private final Map<String, XmiElement> uuidToXmiElement = new HashMap<String, XmiElement>();

    public UnresolvedReference addUnresolvedReference(String xmiUuid) throws Exception {
        CheckArg.isNotEmpty((String)xmiUuid, (String)"xmiUuid");
        xmiUuid = this.resolveInternalReference(xmiUuid);
        if (this.uuidToNode.containsKey(xmiUuid)) {
            throw new Exception(TeiidI18n.illegalUnresolvedReference.text(new Object[]{xmiUuid}));
        }
        UnresolvedReference unresolved = this.unresolved.get(xmiUuid);
        if (unresolved == null) {
            unresolved = new UnresolvedReference(xmiUuid);
            this.unresolved.put(xmiUuid, unresolved);
            LOGGER.debug("added '{0}' to the list of unresolved references", new Object[]{xmiUuid});
        }
        return unresolved;
    }

    Node getNode(String xmiUuid) {
        CheckArg.isNotEmpty((String)xmiUuid, (String)"xmiUuid");
        return this.uuidToNode.get(xmiUuid);
    }

    public Map<String, UnresolvedReference> getUnresolved() {
        return this.unresolved;
    }

    Map<String, XmiElement> getUuidMappings() {
        return this.uuidToXmiElement;
    }

    public boolean isReference(String value) {
        CheckArg.isNotEmpty((String)value, (String)"value");
        return value.startsWith("mmuuid/");
    }

    public void record(String xmiUuid, Node node) {
        CheckArg.isNotEmpty((String)xmiUuid, (String)"xmiUuid");
        CheckArg.isNotNull((Object)node, (String)"node");
        if (xmiUuid.startsWith("mmuuid:")) {
            xmiUuid = xmiUuid.substring("mmuuid:".length() + 1);
        }
        this.uuidToNode.put(xmiUuid, node);
    }

    void record(String xmiUuid, XmiElement xmiElement) {
        CheckArg.isNotEmpty((String)xmiUuid, (String)"xmiUuid");
        CheckArg.isNotNull((Object)xmiElement, (String)"xmiElement");
        this.uuidToXmiElement.put(xmiUuid, xmiElement);
    }

    public void resolved(UnresolvedReference unresolved) {
        CheckArg.isNotNull((Object)unresolved, (String)"unresolved");
        UnresolvedReference resolved = this.unresolved.remove(unresolved.getUuid());
        assert (unresolved == resolved);
        LOGGER.debug("UUID '{0}' has been resolved", new Object[]{unresolved.getUuid()});
    }

    public String resolveInternalReference(String proposedUuid) {
        CheckArg.isNotNull((Object)proposedUuid, (String)"proposedUuid");
        String mmuuid = null;
        int index = proposedUuid.indexOf("mmuuid/");
        if (index != -1) {
            try {
                mmuuid = UUID.fromString(proposedUuid.substring(index + "mmuuid/".length())).toString();
            }
            catch (IllegalArgumentException e) {}
        } else {
            try {
                mmuuid = UUID.fromString(proposedUuid).toString();
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        return mmuuid;
    }

    static {
        HashMap<String, String> dataTypes = new HashMap<String, String>();
        String sdtUrl = "http://www.metamatrix.com/metamodels/SimpleDatatypes-instance#mmuuid:";
        dataTypes.put(sdtUrl + "4ca2ae00-3a95-1e20-921b-eeee28353879", "NMTOKEN");
        dataTypes.put(sdtUrl + "4df43700-3b13-1e20-921b-eeee28353879", "normalizedString");
        dataTypes.put(sdtUrl + "3425cb80-d844-1e20-9027-be6d2c3b8b3a", "token");
        dataTypes.put(sdtUrl + "d4d980c0-e623-1e20-8c26-a038c6ed7576", "language");
        dataTypes.put(sdtUrl + "e66c4600-e65b-1e20-8c26-a038c6ed7576", "Name");
        dataTypes.put(sdtUrl + "ac00e000-e676-1e20-8c26-a038c6ed7576", "NCName");
        dataTypes.put(sdtUrl + "4b0f8500-e6a6-1e20-8c26-a038c6ed7576", "NMTOKENS");
        dataTypes.put(sdtUrl + "dd33ff40-e6df-1e20-8c26-a038c6ed7576", "IDREF");
        dataTypes.put(sdtUrl + "88b13dc0-e702-1e20-8c26-a038c6ed7576", "ID");
        dataTypes.put(sdtUrl + "9fece300-e71a-1e20-8c26-a038c6ed7576", "ENTITY");
        dataTypes.put(sdtUrl + "3c99f780-e72d-1e20-8c26-a038c6ed7576", "IDREFS");
        dataTypes.put(sdtUrl + "20360100-e742-1e20-8c26-a038c6ed7576", "ENTITIES");
        dataTypes.put(sdtUrl + "45da3500-e78f-1e20-8c26-a038c6ed7576", "integer");
        dataTypes.put(sdtUrl + "cbdd6e40-b9d2-1e21-8c26-a038c6ed7576", "nonPositiveInteger");
        dataTypes.put(sdtUrl + "0e081200-b8a4-1e21-b812-969c8fc8b016", "nonNegativeInteger");
        dataTypes.put(sdtUrl + "86d29280-b8d3-1e21-b812-969c8fc8b016", "negativeInteger");
        dataTypes.put(sdtUrl + "8cdee840-b900-1e21-b812-969c8fc8b016", "long");
        dataTypes.put(sdtUrl + "33add3c0-b98d-1e21-b812-969c8fc8b016", "int");
        dataTypes.put(sdtUrl + "5bbcf140-b9ae-1e21-b812-969c8fc8b016", "short");
        dataTypes.put(sdtUrl + "26dc1cc0-b9c8-1e21-b812-969c8fc8b016", "byte");
        dataTypes.put(sdtUrl + "1cbbd380-b9ea-1e21-b812-969c8fc8b016", "positiveInteger");
        dataTypes.put(sdtUrl + "54b98780-ba14-1e21-b812-969c8fc8b016", "unsignedLong");
        dataTypes.put(sdtUrl + "badcbd80-ba63-1e21-b812-969c8fc8b016", "unsignedInt");
        dataTypes.put(sdtUrl + "327093c0-ba88-1e21-b812-969c8fc8b016", "unsignedShort");
        dataTypes.put(sdtUrl + "cff745c0-baa2-1e21-b812-969c8fc8b016", "unsignedByte");
        dataTypes.put(sdtUrl + "bf6c34c0-c442-1e24-9b01-c8207cd53eb7", "string");
        dataTypes.put(sdtUrl + "dc476100-c483-1e24-9b01-c8207cd53eb7", "boolean");
        dataTypes.put(sdtUrl + "569dfa00-c456-1e24-9b01-c8207cd53eb7", "decimal");
        dataTypes.put(sdtUrl + "d86b0d00-c48a-1e24-9b01-c8207cd53eb7", "float");
        dataTypes.put(sdtUrl + "1f18b140-c4a3-1e24-9b01-c8207cd53eb7", "double");
        dataTypes.put(sdtUrl + "3b892180-c4a7-1e24-9b01-c8207cd53eb7", "time");
        dataTypes.put(sdtUrl + "65dcde00-c4ab-1e24-9b01-c8207cd53eb7", "date");
        dataTypes.put(sdtUrl + "62472700-a064-1e26-9b08-d6079ebe1f0d", "char");
        dataTypes.put(sdtUrl + "822b9a40-a066-1e26-9b08-d6079ebe1f0d", "biginteger");
        dataTypes.put(sdtUrl + "f2249740-a078-1e26-9b08-d6079ebe1f0d", "bigdecimal");
        dataTypes.put(sdtUrl + "6d9809c0-a07e-1e26-9b08-d6079ebe1f0d", "timestamp");
        dataTypes.put(sdtUrl + "051a0640-b4e8-1e26-9f33-b76fd9d5fa79", "object");
        dataTypes.put(sdtUrl + "559646c0-4941-1ece-b22b-f49159d22ad3", "clob");
        dataTypes.put(sdtUrl + "5a793100-1836-1ed0-ba0f-f2334f5fbf95", "blob");
        dataTypes.put(sdtUrl + "43f5274e-55e1-1f87-ba1c-eea49143eb32", "XMLLiteral");
        dataTypes.put(sdtUrl + "28d98540-b3e7-1e2a-9a03-beb8638ffd21", "duration");
        dataTypes.put(sdtUrl + "5c69dec0-b3ea-1e2a-9a03-beb8638ffd21", "dateTime");
        dataTypes.put(sdtUrl + "17d08040-b3ed-1e2a-9a03-beb8638ffd21", "gYearMonth");
        dataTypes.put(sdtUrl + "b02c7600-b3f2-1e2a-9a03-beb8638ffd21", "gYear");
        dataTypes.put(sdtUrl + "6e604140-b3f5-1e2a-9a03-beb8638ffd21", "gMonthDay");
        dataTypes.put(sdtUrl + "860b7dc0-b3f8-1e2a-9a03-beb8638ffd21", "gDay");
        dataTypes.put(sdtUrl + "187f5580-b3fb-1e2a-9a03-beb8638ffd21", "gMonth");
        dataTypes.put(sdtUrl + "6247ec80-e8a4-1e2a-b433-fb67ea35c07e", "anyURI");
        dataTypes.put(sdtUrl + "eeb5d780-e8c3-1e2a-b433-fb67ea35c07e", "QName");
        dataTypes.put(sdtUrl + "3dcaf900-e8dc-1e2a-b433-fb67ea35c07e", "NOTATION");
        dataTypes.put(sdtUrl + "d9998500-ebba-1e2a-9319-8eaa9b2276c7", "hexBinary");
        dataTypes.put(sdtUrl + "b4c99380-ebc6-1e2a-9319-8eaa9b2276c7", "base64Binary");
        HashMap<String, String> dataTypesByUuid = new HashMap<String, String>();
        HashMap<String, String> dataTypeUuidsByName = new HashMap<String, String>();
        for (Map.Entry entry : dataTypes.entrySet()) {
            String url = (String)entry.getKey();
            String name = (String)entry.getValue();
            String uuidString = url.substring(sdtUrl.length());
            try {
                String uuid = UUID.fromString(uuidString).toString();
                dataTypesByUuid.put(uuid, name);
                dataTypeUuidsByName.put(name, uuid);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error((Throwable)e, (I18nResource)TeiidI18n.uuidNotValid, new Object[]{uuidString});
            }
        }
        String xsdUrl = "http://www.w3.org/2001/XMLSchema#";
        for (String value : new HashSet(dataTypes.values())) {
            dataTypes.put("http://www.w3.org/2001/XMLSchema#" + value, value);
        }
        sdtUrl = "http://www.metamatrix.com/metamodels/SimpleDatatypes-instance#";
        for (String value : new HashSet(dataTypes.values())) {
            dataTypes.put(sdtUrl + value, value);
        }
        STANDARD_DATA_TYPE_URLS_TO_NAMES = Collections.unmodifiableMap(dataTypes);
        STANDARD_DATA_TYPE_URLS_BY_UUID = Collections.unmodifiableMap(dataTypesByUuid);
        STANDARD_DATA_TYPE_UUIDS_BY_NAMES = Collections.unmodifiableMap(dataTypeUuidsByName);
    }

    class UnresolvedReference {
        private final Set<String> mixins = new HashSet<String>(2);
        private final Map<String, UnresolvedProperty> properties = new HashMap<String, UnresolvedProperty>();
        private final Multimap<String, String> refNames = ArrayListMultimap.create();
        private final Multimap<String, String> refRefs = ArrayListMultimap.create();
        private final Multimap<String, String> refs = ArrayListMultimap.create();
        private final String uuid;

        UnresolvedReference(String uuid) {
            CheckArg.isNotEmpty((String)uuid, (String)"uuid");
            this.uuid = uuid;
        }

        public boolean addMixin(String newMixin) {
            CheckArg.isNotEmpty((String)newMixin, (String)"newMixin");
            boolean added = this.mixins.add(newMixin);
            if (added) {
                LOGGER.debug("added mixin '{0}' to the unresolved reference '{1}'", new Object[]{newMixin, this.uuid});
            }
            return added;
        }

        public void addProperty(String propertyName, String propertyValue, boolean multiValued) {
            CheckArg.isNotEmpty((String)propertyName, (String)"propertyName");
            if (!StringUtil.isBlank((String)propertyValue)) {
                if (multiValued) {
                    UnresolvedProperty unresolvedProperty = this.properties.get(propertyName);
                    if (unresolvedProperty == null) {
                        unresolvedProperty = new UnresolvedProperty(propertyName, propertyValue, true);
                    } else {
                        unresolvedProperty.addValue(propertyValue);
                    }
                    LOGGER.debug("added multi-valued property '{0}' with value '{1}' to the unresolved reference '{2}'", new Object[]{propertyName, propertyValue, this.uuid});
                } else {
                    this.properties.put(propertyName, new UnresolvedProperty(propertyName, propertyValue, false));
                    LOGGER.debug("added property '{0}' with value '{1}' to the unresolved reference '{2}'", new Object[]{propertyName, propertyValue, this.uuid});
                }
            }
        }

        public void addReference(String propertyName, String referencedUuid) {
            CheckArg.isNotEmpty((String)propertyName, (String)"propertyName");
            CheckArg.isNotEmpty((String)referencedUuid, (String)"referencerUuid");
            this.refs.put((Object)propertyName, (Object)referencedUuid);
        }

        public void addReferencerReference(String referencerUuid, String referencerPropertyName) {
            CheckArg.isNotEmpty((String)referencerUuid, (String)"referencerUuid");
            CheckArg.isNotEmpty((String)referencerPropertyName, (String)"referencerPropertyName");
            this.refRefs.put((Object)referencerPropertyName, (Object)referencerUuid);
        }

        public void addResolvedName(String referencerUuid, String referencerPropertyName) {
            CheckArg.isNotEmpty((String)referencerUuid, (String)"referencerUuid");
            CheckArg.isNotEmpty((String)referencerPropertyName, (String)"referencerPropertyName");
            this.refNames.put((Object)referencerPropertyName, (Object)referencerUuid);
        }

        protected Set<String> getMixins() {
            return this.mixins;
        }

        protected Map<String, UnresolvedProperty> getProperties() {
            return this.properties;
        }

        protected Multimap<String, String> getReferenceNames() {
            return this.refNames;
        }

        protected Multimap<String, String> getReferencerReferences() {
            return this.refRefs;
        }

        protected Multimap<String, String> getReferences() {
            return this.refs;
        }

        public String getUuid() {
            return this.uuid;
        }
    }

    final class UnresolvedProperty {
        private final boolean multi;
        private final String name;
        private final List<String> values;

        protected UnresolvedProperty(String name, String value, boolean multi) {
            this.name = name;
            this.values = new ArrayList<String>();
            this.values.add(value);
            this.multi = multi;
        }

        protected void addValue(String newValue) {
            if (this.multi) {
                this.values.add(newValue);
            }
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            if (this.multi) {
                throw new IllegalArgumentException();
            }
            return this.values.isEmpty() ? null : this.values.get(0);
        }

        public List<String> getValues() {
            if (this.multi) {
                return this.values;
            }
            throw new IllegalArgumentException();
        }

        public boolean isMulti() {
            return this.multi;
        }
    }
}

