/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.text;

import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.JcrNtLexicon;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.sequencer.MockSequencerContext;
import org.modeshape.graph.sequencer.MockSequencerOutput;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.text.DelimitedTextSequencer;
import org.modeshape.sequencer.text.RowFactory;
import org.modeshape.sequencer.text.TextSequencerLexicon;

public class DelimitedTextSequencerTest {
    private DelimitedTextSequencer sequencer;
    private InputStream input;
    private MockSequencerOutput output;
    private StreamSequencerContext context;

    @Before
    public void beforeEach() throws Exception {
        this.sequencer = new DelimitedTextSequencer();
        this.context = new MockSequencerContext();
        this.context.getNamespaceRegistry().register("text", "http://www.modeshape.org/sequencer/text/1.0");
        this.context.getNamespaceRegistry().register("nt", "http://www.jcp.org/jcr/nt/1.0");
        this.output = new MockSequencerOutput(this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.input != null) {
            try {
                this.input.close();
            }
            finally {
                this.input = null;
            }
        }
    }

    protected InputStream getTestDocument(String resourcePath) {
        return this.getClass().getResourceAsStream("/delimited/" + resourcePath);
    }

    @Test
    public void shouldSequenceCommaDelimitedFileWithOneLine() {
        this.input = this.getTestDocument("oneLineCommaDelimitedFile.csv");
        this.sequencer.sequence(this.input, (SequencerOutput)this.output, this.context);
        Assert.assertThat((Object)this.output.getProperty("text:row", "jcr:primaryType"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)((Name)this.output.getProperty("text:row", "jcr:primaryType").getFirstValue()), (Matcher)Is.is((Object)JcrNtLexicon.UNSTRUCTURED));
        String[] columns = new String[]{"foo", "bar", "baz"};
        for (int col = 1; col <= columns.length; ++col) {
            Assert.assertThat((Object)((Name)this.output.getProperty("text:row/text:column[" + col + "]", "jcr:primaryType").getFirstValue()), (Matcher)Is.is((Object)JcrNtLexicon.UNSTRUCTURED));
            Assert.assertThat((Object)((Name)this.output.getProperty("text:row/text:column[" + col + "]", "jcr:mixinTypes").getFirstValue()), (Matcher)Is.is((Object)TextSequencerLexicon.COLUMN));
            Assert.assertThat((Object)((String)this.output.getProperty("text:row/text:column[" + col + "]", "text:data").getFirstValue()), (Matcher)Is.is((Object)columns[col - 1]));
        }
    }

    @Test
    public void shouldSequenceCommaDelimitedFileWithOneLineAndNoTrailingNewLine() {
        this.input = this.getTestDocument("oneLineCommaDelimitedFileNoTrailingNewLine.csv");
        this.sequencer.sequence(this.input, (SequencerOutput)this.output, this.context);
        Assert.assertThat((Object)this.output.getProperty("text:row", "jcr:primaryType"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)((Name)this.output.getProperty("text:row", "jcr:primaryType").getFirstValue()), (Matcher)Is.is((Object)JcrNtLexicon.UNSTRUCTURED));
        String[] columns = new String[]{"foo", "bar", "baz"};
        for (int col = 1; col <= columns.length; ++col) {
            Assert.assertThat((Object)((Name)this.output.getProperty("text:row/text:column[" + col + "]", "jcr:primaryType").getFirstValue()), (Matcher)Is.is((Object)JcrNtLexicon.UNSTRUCTURED));
            Assert.assertThat((Object)((Name)this.output.getProperty("text:row/text:column[" + col + "]", "jcr:mixinTypes").getFirstValue()), (Matcher)Is.is((Object)TextSequencerLexicon.COLUMN));
            Assert.assertThat((Object)((String)this.output.getProperty("text:row/text:column[" + col + "]", "text:data").getFirstValue()), (Matcher)Is.is((Object)columns[col - 1]));
        }
    }

    @Test
    public void shouldSequenceCommaDelimitedFileWithMultipleLines() {
        this.input = this.getTestDocument("multiLineCommaDelimitedFile.csv");
        this.sequencer.sequence(this.input, (SequencerOutput)this.output, this.context);
        Assert.assertThat((Object)this.output.getProperty("text:row", "jcr:primaryType"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)((Name)this.output.getProperty("text:row", "jcr:primaryType").getFirstValue()), (Matcher)Is.is((Object)JcrNtLexicon.UNSTRUCTURED));
        int ROW_COUNT = 6;
        for (int row = 1; row <= 6; ++row) {
            String[] columns = new String[]{"foo", "bar", "baz"};
            for (int col = 1; col <= columns.length; ++col) {
                Assert.assertThat((Object)((Name)this.output.getProperty("text:row[" + row + "]/text:column[" + col + "]", "jcr:primaryType").getFirstValue()), (Matcher)Is.is((Object)JcrNtLexicon.UNSTRUCTURED));
                Assert.assertThat((Object)((Name)this.output.getProperty("text:row[" + row + "]/text:column[" + col + "]", "jcr:mixinTypes").getFirstValue()), (Matcher)Is.is((Object)TextSequencerLexicon.COLUMN));
                Assert.assertThat((Object)((String)this.output.getProperty("text:row[" + row + "]/text:column[" + col + "]", "text:data").getFirstValue()), (Matcher)Is.is((Object)columns[col - 1]));
            }
        }
    }

    @Test
    public void shouldSequenceCommaDelimitedFileWithMultipleLinesAndMissingRecords() {
        this.input = this.getTestDocument("multiLineCommaDelimitedFileMissingRecords.csv");
        this.sequencer.sequence(this.input, (SequencerOutput)this.output, this.context);
        Assert.assertThat((Object)this.output.getProperty("text:row", "jcr:primaryType"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)((Name)this.output.getProperty("text:row", "jcr:primaryType").getFirstValue()), (Matcher)Is.is((Object)JcrNtLexicon.UNSTRUCTURED));
        int ROW_COUNT = 6;
        for (int row = 1; row <= 6; ++row) {
            String[] columns = new String[]{"foo", "bar", "baz"};
            for (int col = 1; col <= columns.length; ++col) {
                if (row == 3 && col > 1) {
                    Assert.assertThat((Object)this.output.hasProperty("text:row[" + row + "]/text:column[" + col + "]", "jcr:primaryType"), (Matcher)Is.is((Object)false));
                    continue;
                }
                Assert.assertThat((Object)((Name)this.output.getProperty("text:row[" + row + "]/text:column[" + col + "]", "jcr:primaryType").getFirstValue()), (Matcher)Is.is((Object)JcrNtLexicon.UNSTRUCTURED));
                Assert.assertThat((Object)((Name)this.output.getProperty("text:row[" + row + "]/text:column[" + col + "]", "jcr:mixinTypes").getFirstValue()), (Matcher)Is.is((Object)TextSequencerLexicon.COLUMN));
                Assert.assertThat((Object)((String)this.output.getProperty("text:row[" + row + "]/text:column[" + col + "]", "text:data").getFirstValue()), (Matcher)Is.is((Object)columns[col - 1]));
            }
        }
    }

    @Test
    public void shouldSequencePipeDelimitedFileWithMultipleLines() {
        this.input = this.getTestDocument("multiLinePipeDelimitedFile.csv");
        this.sequencer.setSplitPattern("\\|");
        this.sequencer.sequence(this.input, (SequencerOutput)this.output, this.context);
        Assert.assertThat((Object)this.output.getProperty("text:row", "jcr:primaryType"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)((Name)this.output.getProperty("text:row", "jcr:primaryType").getFirstValue()), (Matcher)Is.is((Object)JcrNtLexicon.UNSTRUCTURED));
        int ROW_COUNT = 6;
        for (int row = 1; row <= 6; ++row) {
            String[] columns = new String[]{"foo", "bar", "baz"};
            for (int col = 1; col <= columns.length; ++col) {
                Assert.assertThat((Object)((Name)this.output.getProperty("text:row[" + row + "]/text:column[" + col + "]", "jcr:primaryType").getFirstValue()), (Matcher)Is.is((Object)JcrNtLexicon.UNSTRUCTURED));
                Assert.assertThat((Object)((Name)this.output.getProperty("text:row[" + row + "]/text:column[" + col + "]", "jcr:mixinTypes").getFirstValue()), (Matcher)Is.is((Object)TextSequencerLexicon.COLUMN));
                Assert.assertThat((Object)((String)this.output.getProperty("text:row[" + row + "]/text:column[" + col + "]", "text:data").getFirstValue()), (Matcher)Is.is((Object)columns[col - 1]));
            }
        }
    }

    @Test
    public void shouldSequenceCommaDelimitedFileWithCustomRowFactory() throws Exception {
        this.input = this.getTestDocument("multiLineCommaDelimitedFile.csv");
        this.sequencer.setRowFactoryClassName(CustomRowFactory.class.getName());
        this.sequencer.sequence(this.input, (SequencerOutput)this.output, this.context);
        int ROW_COUNT = 6;
        for (int row = 1; row <= 6; ++row) {
            String[] columns = new String[]{"foo", "bar", "baz"};
            for (int col = 0; col < columns.length; ++col) {
                Assert.assertThat((Object)((String)this.output.getProperty("text:row[" + row + "]", "text:data" + col).getFirstValue()), (Matcher)Is.is((Object)columns[col]));
            }
        }
    }

    @Test
    public void shouldSequenceCommaDelimitedFileWithComments() throws Exception {
        int col;
        int row;
        this.input = this.getTestDocument("multiLineCommaDelimitedFileWithComments.csv");
        this.sequencer.setCommentMarker("#");
        this.sequencer.sequence(this.input, (SequencerOutput)this.output, this.context);
        int ROW_COUNT = 4;
        String[] columns = new String[]{"foo", "bar", "baz"};
        for (row = 1; row <= 4; ++row) {
            for (col = 1; col <= columns.length; ++col) {
                Assert.assertThat((Object)((Name)this.output.getProperty("text:row[" + row + "]/text:column[" + col + "]", "jcr:primaryType").getFirstValue()), (Matcher)Is.is((Object)JcrNtLexicon.UNSTRUCTURED));
                Assert.assertThat((Object)((Name)this.output.getProperty("text:row[" + row + "]/text:column[" + col + "]", "jcr:mixinTypes").getFirstValue()), (Matcher)Is.is((Object)TextSequencerLexicon.COLUMN));
                Assert.assertThat((Object)((String)this.output.getProperty("text:row[" + row + "]/text:column[" + col + "]", "text:data").getFirstValue()), (Matcher)Is.is((Object)columns[col - 1]));
            }
        }
        row = 5;
        for (col = 1; col <= columns.length; ++col) {
            Assert.assertThat((Object)this.output.hasProperty("text:row[" + row + "]/text:column[" + col + "]", "jcr:primaryType"), (Matcher)Is.is((Object)false));
            Assert.assertThat((Object)this.output.hasProperty("text:row[" + row + "]/text:column[" + col + "]", "jcr:mixinTypes"), (Matcher)Is.is((Object)false));
            Assert.assertThat((Object)this.output.hasProperty("text:row[" + row + "]/text:column[" + col + "]", "text:data"), (Matcher)Is.is((Object)false));
        }
    }

    @Test
    public void shouldSequenceCommaDelimitedFileUpToMaximumLinesSetting() {
        int col;
        int row;
        this.input = this.getTestDocument("multiLineCommaDelimitedFile.csv");
        this.sequencer.setMaximumLinesToRead(3);
        this.sequencer.sequence(this.input, (SequencerOutput)this.output, this.context);
        Assert.assertThat((Object)this.output.getProperty("text:row", "jcr:primaryType"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)((Name)this.output.getProperty("text:row", "jcr:primaryType").getFirstValue()), (Matcher)Is.is((Object)JcrNtLexicon.UNSTRUCTURED));
        int ROW_COUNT = 3;
        String[] columns = new String[]{"foo", "bar", "baz"};
        for (row = 1; row <= 3; ++row) {
            for (col = 1; col <= columns.length; ++col) {
                Assert.assertThat((Object)((Name)this.output.getProperty("text:row[" + row + "]/text:column[" + col + "]", "jcr:primaryType").getFirstValue()), (Matcher)Is.is((Object)JcrNtLexicon.UNSTRUCTURED));
                Assert.assertThat((Object)((Name)this.output.getProperty("text:row[" + row + "]/text:column[" + col + "]", "jcr:mixinTypes").getFirstValue()), (Matcher)Is.is((Object)TextSequencerLexicon.COLUMN));
                Assert.assertThat((Object)((String)this.output.getProperty("text:row[" + row + "]/text:column[" + col + "]", "text:data").getFirstValue()), (Matcher)Is.is((Object)columns[col - 1]));
            }
        }
        for (row = 4; row <= 6; ++row) {
            for (col = 1; col <= columns.length; ++col) {
                Assert.assertThat((Object)this.output.hasProperty("text:row[" + row + "]/text:column[" + col + "]", "jcr:primaryType"), (Matcher)Is.is((Object)false));
                Assert.assertThat((Object)this.output.hasProperty("text:row[" + row + "]/text:column[" + col + "]", "jcr:mixinTypes"), (Matcher)Is.is((Object)false));
                Assert.assertThat((Object)this.output.hasProperty("text:row[" + row + "]/text:column[" + col + "]", "text:data"), (Matcher)Is.is((Object)false));
            }
        }
    }

    public static class CustomRowFactory
    implements RowFactory {
        int rowNum = 1;

        public void recordRow(StreamSequencerContext context, SequencerOutput output, String[] columns) {
            for (int i = 0; i < columns.length; ++i) {
                output.setProperty("text:row[" + this.rowNum + "]", "text:data" + i, new Object[]{columns[i]});
            }
            ++this.rowNum;
        }
    }
}

