/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.text;

import org.junit.Test;
import org.modeshape.sequencer.text.AbstractTextSequencerTest;

public class DelimitedTextSequencerTest
extends AbstractTextSequencerTest {
    @Test
    public void shouldSequenceCommaDelimitedFileWithOneLine() throws Exception {
        String filename = "oneLineCommaDelimitedFile.csv";
        String filePath = this.getTestFilePath(filename);
        this.createNodeWithContentFromFile(filename, filePath);
        this.assertRows(filePath, 1, TEST_COLUMNS);
    }

    @Test
    public void shouldSequenceCommaDelimitedFileWithOneLineAndNoTrailingNewLine() throws Exception {
        String filename = "oneLineCommaDelimitedFileNoTrailingNewLine.csv";
        String filePath = this.getTestFilePath(filename);
        this.createNodeWithContentFromFile(filename, filePath);
        this.assertRows(filePath, 1, TEST_COLUMNS);
    }

    @Test
    public void shouldSequenceCommaDelimitedFileWithMultipleLines() throws Exception {
        String filename = "multiLineCommaDelimitedFile.csv";
        String filePath = this.getTestFilePath(filename);
        this.createNodeWithContentFromFile(filename, filePath);
        this.assertRows(filePath, 6, TEST_COLUMNS);
    }

    @Test
    public void shouldSequenceCommaDelimitedFileWithMultipleLinesAndMissingRecords() throws Exception {
        String filename = "multiLineCommaDelimitedFileMissingRecords.csv";
        String filePath = this.getTestFilePath(filename);
        this.createNodeWithContentFromFile(filename, filePath);
        this.assertFileWithMissingRecords(filePath);
    }

    @Test
    public void shouldSequencePipeDelimitedFileWithMultipleLines() throws Exception {
        String filename = "multiLinePipeDelimitedFile.csv";
        this.createNodeWithContentFromFile("customsplitpattern/" + filename, "delimited/" + filename);
        String rootSequencedNodePath = "delimited/customsplitpattern/" + filename;
        this.assertRows(rootSequencedNodePath, 6, TEST_COLUMNS);
    }

    @Test
    public void shouldSequenceCommaDelimitedFileWithCustomRowFactory() throws Exception {
        String filename = "multiLineCommaDelimitedFile.csv";
        this.createNodeWithContentFromFile("customrowfactory/" + filename, this.getTestFilePath("multiLineCommaDelimitedFile.csv"));
        String sequencedRootPath = "delimited/customrowfactory/" + filename;
        this.assertRowsWithCustomRowFactory(sequencedRootPath);
    }

    @Test
    public void shouldSequenceCommaDelimitedFileWithComments() throws Exception {
        String filename = "multiLineCommaDelimitedFileWithComments.csv";
        String filePath = this.getTestFilePath(filename);
        this.createNodeWithContentFromFile(filename, filePath);
        this.assertRows(filePath, 4, TEST_COLUMNS);
    }

    @Test
    public void shouldSequenceCommaDelimitedFileUpToMaximumLinesSetting() throws Exception {
        String filename = "multiLineCommaDelimitedFile.csv";
        this.createNodeWithContentFromFile("maxlines/" + filename, "delimited/" + filename);
        String sequencedPath = "delimited/maxlines/" + filename;
        this.assertRows(sequencedPath, 3, TEST_COLUMNS);
    }

    private String getTestFilePath(String filename) {
        return "delimited/" + filename;
    }
}

