/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.text;

import java.util.Arrays;
import org.modeshape.common.util.CheckArg;
import org.modeshape.sequencer.text.AbstractTextSequencer;

public class FixedWidthTextSequencer
extends AbstractTextSequencer {
    private int[] columnStartPositions = new int[0];

    public void setColumnStartPositions(int[] columnStartPositions) {
        CheckArg.isNotNull((Object)columnStartPositions, (String)"columnStartPositions");
        this.columnStartPositions = columnStartPositions;
        Arrays.sort(columnStartPositions);
    }

    public void setColumnStartPositions(String commaDelimitedColumnStartPositions) {
        CheckArg.isNotNull((Object)commaDelimitedColumnStartPositions, (String)"commaDelimitedColumnStartPositions");
        String[] stringStartPositions = commaDelimitedColumnStartPositions.split(",");
        int[] columnStartPositions = new int[stringStartPositions.length];
        for (int i = 0; i < stringStartPositions.length; ++i) {
            columnStartPositions[i] = Integer.valueOf(stringStartPositions[i]);
        }
        this.setColumnStartPositions(columnStartPositions);
    }

    @Override
    protected String[] parseLine(String line) {
        assert (line != null);
        int columnCount = this.columnStartPositions.length + 1;
        int currentPos = 0;
        String[] columns = new String[columnCount];
        for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
            int endPos = columnIndex >= columnCount - 1 ? Integer.MAX_VALUE : this.columnStartPositions[columnIndex];
            String chunk = this.parseColumn(line, currentPos, endPos);
            if (chunk == null) {
                assert (columnIndex > 0) : "parseColumn failed to return the first column in string " + line;
                String[] truncatedColumns = new String[columnIndex - 1];
                System.arraycopy(columns, 0, truncatedColumns, 0, columnIndex - 1);
                return truncatedColumns;
            }
            columns[columnIndex] = chunk;
            currentPos = endPos;
        }
        return columns;
    }

    private String parseColumn(String line, int startPos, int endPos) {
        int length = line.length();
        if (length < startPos) {
            return null;
        }
        if (length < endPos) {
            return line.substring(startPos);
        }
        return line.substring(startPos, endPos);
    }
}

