/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.ecore;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDAttributeUseCategory;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDConstraint;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDLengthFacet;
import org.eclipse.xsd.XSDMaxInclusiveFacet;
import org.eclipse.xsd.XSDMaxLengthFacet;
import org.eclipse.xsd.XSDMinLengthFacet;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.ecore.MapBuilder;
import org.eclipse.xsd.util.XSDConstants;
import org.eclipse.xsd.util.XSDParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EcoreSchemaBuilder
extends MapBuilder {
    protected String defaultXMLSchemaNamespace = "http://www.w3.org/2001/XMLSchema";
    protected String defaultXMLSchemaNamespacePrefix = "xsd";
    protected ExtendedMetaData extendedMetaData;
    protected Map eModelElementToXSDComponentMap = new HashMap();
    protected static final String GEN_MODEL_PACKAGE_NS_URI = "http://www.eclipse.org/emf/2002/GenModel";

    public EcoreSchemaBuilder(ExtendedMetaData extendedMetaData) {
        this.extendedMetaData = extendedMetaData;
    }

    protected void map(XSDComponent xsdComponent, EModelElement eModelElement) {
        super.map(xsdComponent, eModelElement);
        this.eModelElementToXSDComponentMap.put(eModelElement, xsdComponent);
    }

    public XSDSchema getSchema(EPackage ePackage) {
        XSDSchema xsdSchema = (XSDSchema)this.eModelElementToXSDComponentMap.get(ePackage);
        if (xsdSchema == null) {
            xsdSchema = this.buildSchema(ePackage);
        }
        return xsdSchema;
    }

    protected String getQualifiedPackageName(EPackage ePackage) {
        return ePackage.getName();
    }

    protected XSDSchema buildSchema(EPackage ePackage) {
        EClassifier eClassifier;
        Iterator i;
        XSDSchema xsdSchema = XSDFactory.eINSTANCE.createXSDSchema();
        this.addInput(ePackage);
        this.addOutput(xsdSchema);
        this.map(xsdSchema, ePackage);
        String targetNamespace = this.extendedMetaData.getNamespace(ePackage);
        xsdSchema.setTargetNamespace(targetNamespace);
        Map namespaces = xsdSchema.getQNamePrefixToNamespaceMap();
        xsdSchema.setSchemaForSchemaQNamePrefix(this.defaultXMLSchemaNamespacePrefix);
        namespaces.put(this.defaultXMLSchemaNamespacePrefix, this.defaultXMLSchemaNamespace);
        this.handlePrefix(namespaces, ePackage.getNsPrefix(), targetNamespace);
        xsdSchema.updateElement();
        this.buildAnnotations(xsdSchema, ePackage);
        this.createEcoreAnnotation(xsdSchema, "package", this.getQualifiedPackageName(ePackage));
        this.createEcoreAnnotation(xsdSchema, "nsPrefix", ePackage.getNsPrefix());
        EClass documentRootEClass = this.extendedMetaData.getDocumentRoot(ePackage);
        if (documentRootEClass == null) {
            i = ePackage.getEClassifiers().iterator();
            while (i.hasNext()) {
                EClass eClass;
                eClassifier = (EClassifier)i.next();
                if (!(eClassifier instanceof EClass) || this.extendedMetaData.getContentKind(eClass = (EClass)eClassifier) != 0) continue;
                this.buildGlobalElement(xsdSchema, eClass);
            }
        } else {
            if (!"DocumentRoot".equals(documentRootEClass.getName())) {
                this.createEcoreAnnotation(xsdSchema, "documentRoot", documentRootEClass.getName());
            }
            int i2 = 0;
            int size = documentRootEClass.getFeatureCount();
            while (i2 < size) {
                EStructuralFeature eStructuralFeature = documentRootEClass.getEStructuralFeature(i2);
                if (this.extendedMetaData.getName(eStructuralFeature).indexOf(58) == -1) {
                    this.buildGlobalFeature(xsdSchema, eStructuralFeature);
                }
                ++i2;
            }
        }
        i = ePackage.getEClassifiers().iterator();
        while (i.hasNext()) {
            eClassifier = (EClassifier)i.next();
            if (eClassifier == documentRootEClass) continue;
            this.buildTypeDefinition(xsdSchema, eClassifier);
        }
        this.buildAnnotations(xsdSchema, ePackage);
        return xsdSchema;
    }

    protected XSDElementDeclaration buildGlobalElement(XSDSchema xsdSchema, EClass eClass) {
        XSDElementDeclaration xsdElementDeclaration = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElementDeclaration.setName(this.extendedMetaData.getName(eClass));
        XSDTypeDefinition xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(this.getURI(eClass));
        this.handleImport(xsdSchema, xsdTypeDefinition);
        xsdElementDeclaration.setTypeDefinition(xsdTypeDefinition);
        xsdSchema.getContents().add(xsdElementDeclaration);
        this.map(xsdElementDeclaration, eClass);
        this.createEcoreAnnotation(xsdElementDeclaration, "ignore", "true");
        return xsdElementDeclaration;
    }

    protected XSDFeature buildGlobalFeature(XSDSchema xsdSchema, EStructuralFeature eStructuralFeature) {
        switch (this.extendedMetaData.getFeatureKind(eStructuralFeature)) {
            case 4: {
                XSDElementDeclaration xsdElementDeclaration = this.buildGlobalElement(xsdSchema, eStructuralFeature);
                return xsdElementDeclaration;
            }
            case 2: {
                XSDAttributeDeclaration xsdAttributeDeclaration = this.buildGlobalAttribute(xsdSchema, eStructuralFeature);
                return xsdAttributeDeclaration;
            }
        }
        return null;
    }

    protected XSDElementDeclaration buildGlobalElement(XSDSchema xsdSchema, EStructuralFeature eStructuralFeature) {
        String defaultValue;
        XSDElementDeclaration xsdElementDeclaration = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElementDeclaration.setName(this.extendedMetaData.getName(eStructuralFeature));
        XSDTypeDefinition xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(this.getURI(eStructuralFeature.getEType()));
        this.handleImport(xsdSchema, xsdTypeDefinition);
        xsdElementDeclaration.setTypeDefinition(xsdTypeDefinition);
        if (this.isWrapperType(eStructuralFeature.getEType())) {
            xsdElementDeclaration.setNillable(true);
        }
        if ((defaultValue = eStructuralFeature.getDefaultValueLiteral()) != null) {
            xsdElementDeclaration.setConstraint(XSDConstraint.DEFAULT_LITERAL);
            xsdElementDeclaration.setLexicalValue(defaultValue);
        }
        xsdSchema.getContents().add(xsdElementDeclaration);
        this.map(xsdElementDeclaration, eStructuralFeature);
        this.buildAnnotations(xsdElementDeclaration, eStructuralFeature);
        return xsdElementDeclaration;
    }

    protected XSDAttributeDeclaration buildGlobalAttribute(XSDSchema xsdSchema, EStructuralFeature eStructuralFeature) {
        XSDAttributeDeclaration xsdAttributeDeclaration = XSDFactory.eINSTANCE.createXSDAttributeDeclaration();
        xsdAttributeDeclaration.setName(this.extendedMetaData.getName(eStructuralFeature));
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = xsdSchema.resolveSimpleTypeDefinitionURI(this.getURI(eStructuralFeature.getEType()));
        this.handleImport(xsdSchema, xsdSimpleTypeDefinition);
        xsdAttributeDeclaration.setTypeDefinition(xsdSimpleTypeDefinition);
        String defaultValue = eStructuralFeature.getDefaultValueLiteral();
        if (defaultValue != null) {
            xsdAttributeDeclaration.setConstraint(XSDConstraint.DEFAULT_LITERAL);
            xsdAttributeDeclaration.setLexicalValue(defaultValue);
        }
        xsdSchema.getContents().add(xsdAttributeDeclaration);
        this.map(xsdAttributeDeclaration, eStructuralFeature);
        this.buildAnnotations(xsdAttributeDeclaration, eStructuralFeature);
        return xsdAttributeDeclaration;
    }

    protected XSDTypeDefinition buildTypeDefinition(XSDSchema xsdSchema, EClassifier eClassifier) {
        if (eClassifier instanceof EClass) {
            return this.buildComplexTypeDefinition(xsdSchema, (EClass)eClassifier);
        }
        return this.buildSimpleTypeDefinition(xsdSchema, (EDataType)eClassifier);
    }

    protected XSDSimpleTypeDefinition buildSimpleTypeDefinition(XSDSchema xsdSchema, EDataType eDataType) {
        String name = this.extendedMetaData.getName(eDataType);
        boolean isAnonymousWrapperType = name.endsWith(":Object");
        if (isAnonymousWrapperType && "http://www.eclipse.org/emf/2002/Ecore".equals(xsdSchema.getTargetNamespace())) {
            name = eDataType.getName();
            isAnonymousWrapperType = false;
        }
        if (!isAnonymousWrapperType) {
            String constraints;
            String ecoreName;
            String maxInclusive;
            XSDSimpleTypeDefinition xsdSimpleTypeDefinition = XSDFactory.eINSTANCE.createXSDSimpleTypeDefinition();
            xsdSimpleTypeDefinition.setName(name);
            String instanceClass = null;
            EDataType baseType = this.extendedMetaData.getBaseType(eDataType);
            if (baseType != null) {
                XSDSimpleTypeDefinition baseTypeDefinition = xsdSchema.resolveSimpleTypeDefinitionURI(this.getURI(baseType));
                this.handleImport(xsdSchema, baseTypeDefinition);
                xsdSimpleTypeDefinition.setBaseTypeDefinition(baseTypeDefinition);
                instanceClass = eDataType.getInstanceClassName();
                if (instanceClass != null && instanceClass.equals(baseType.getInstanceClassName())) {
                    instanceClass = null;
                }
            } else {
                EDataType itemType = this.extendedMetaData.getItemType(eDataType);
                if (itemType != null) {
                    XSDSimpleTypeDefinition itemTypeDefinition = xsdSchema.resolveSimpleTypeDefinitionURI(this.getURI(itemType));
                    this.handleImport(xsdSchema, itemTypeDefinition);
                    xsdSimpleTypeDefinition.setItemTypeDefinition(itemTypeDefinition);
                } else {
                    List<EDataType> memberTypes = this.extendedMetaData.getMemberTypes(eDataType);
                    if (!memberTypes.isEmpty()) {
                        Iterator<EDataType> i = memberTypes.iterator();
                        while (i.hasNext()) {
                            EDataType memberType = i.next();
                            XSDSimpleTypeDefinition memberTypeDefinition = xsdSchema.resolveSimpleTypeDefinitionURI(this.getURI(memberType));
                            this.handleImport(xsdSchema, memberTypeDefinition);
                            xsdSimpleTypeDefinition.getMemberTypeDefinitions().add(memberTypeDefinition);
                        }
                    } else {
                        xsdSimpleTypeDefinition.setBaseTypeDefinition(xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("string"));
                        if (!(eDataType instanceof EEnum)) {
                            instanceClass = eDataType.getInstanceClassName();
                        }
                    }
                }
            }
            xsdSchema.getContents().add(xsdSimpleTypeDefinition);
            this.map(xsdSimpleTypeDefinition, eDataType);
            if (instanceClass != null) {
                this.createEcoreAnnotation(xsdSimpleTypeDefinition, "instanceClass", instanceClass);
            }
            if ((maxInclusive = this.extendedMetaData.getMaxInclusiveFacet(eDataType)) != null) {
                XSDMaxInclusiveFacet xsdMaxInclusiveFacet = XSDFactory.eINSTANCE.createXSDMaxInclusiveFacet();
                xsdMaxInclusiveFacet.setLexicalValue(maxInclusive);
                xsdSimpleTypeDefinition.getFacetContents().add(xsdMaxInclusiveFacet);
            }
            if (!name.equals(ecoreName = eDataType.getName()) || Character.isLowerCase(ecoreName.charAt(0)) || ecoreName.indexOf(95) != -1) {
                this.createEcoreAnnotation(xsdSimpleTypeDefinition, "name", ecoreName);
            }
            if ((constraints = EcoreUtil.getAnnotation(eDataType, "http://www.eclipse.org/emf/2002/Ecore", "constraints")) != null) {
                this.createEcoreAnnotation(xsdSimpleTypeDefinition, "constraints", constraints);
            }
            if (!eDataType.isSerializable()) {
                this.createEcoreAnnotation(xsdSimpleTypeDefinition, "serializable", "false");
            }
            if (eDataType instanceof EEnum) {
                EEnum eEnum = (EEnum)eDataType;
                ListIterator literals = eEnum.getELiterals().listIterator();
                while (literals.hasNext()) {
                    EEnumLiteral literal = (EEnumLiteral)literals.next();
                    XSDEnumerationFacet facet = XSDFactory.eINSTANCE.createXSDEnumerationFacet();
                    facet.setLexicalValue(literal.getLiteral());
                    xsdSimpleTypeDefinition.getFacetContents().add(facet);
                    this.map(facet, literal);
                    if (!literal.getLiteral().equals(literal.getName())) {
                        this.createEcoreAnnotation(facet, "name", literal.getName());
                    }
                    if (literal.getValue() == literals.previousIndex()) continue;
                    this.createEcoreAnnotation(facet, "value", Integer.toString(literal.getValue()));
                }
            }
            this.buildAnnotations(xsdSimpleTypeDefinition, eDataType);
            return xsdSimpleTypeDefinition;
        }
        return null;
    }

    protected XSDComplexTypeDefinition buildComplexTypeDefinition(XSDSchema xsdSchema, EClass eClass) {
        String constraints;
        String ecoreName;
        EList<EClass> superClasses;
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        String name = this.extendedMetaData.getName(eClass);
        xsdComplexTypeDefinition.setName(name);
        if (eClass.isAbstract()) {
            xsdComplexTypeDefinition.setAbstract(true);
        }
        if (!(superClasses = eClass.getESuperTypes()).isEmpty()) {
            Iterator i = superClasses.iterator();
            EClass superClass = (EClass)i.next();
            XSDTypeDefinition baseType = xsdSchema.resolveTypeDefinitionURI(this.getURI(superClass));
            if (!XSDConstants.isURType(baseType)) {
                this.handleImport(xsdSchema, baseType);
                xsdComplexTypeDefinition.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
                xsdComplexTypeDefinition.setBaseTypeDefinition(baseType);
            }
            xsdSchema.getContents().add(xsdComplexTypeDefinition);
            if (i.hasNext()) {
                StringBuffer additionalSuperTypes = new StringBuffer();
                do {
                    if (XSDConstants.isURType(baseType = xsdSchema.resolveTypeDefinitionURI(this.getURI(superClass = (EClass)i.next())))) continue;
                    this.handleImport(xsdSchema, baseType);
                    String prefix = this.handlePrefix(xsdSchema.getQNamePrefixToNamespaceMap(), superClass.getEPackage().getNsPrefix(), baseType.getTargetNamespace());
                    additionalSuperTypes.append(prefix);
                    additionalSuperTypes.append(':');
                    additionalSuperTypes.append(baseType.getName());
                    additionalSuperTypes.append(' ');
                } while (i.hasNext());
                this.createEcoreAnnotation(xsdComplexTypeDefinition, "implements", additionalSuperTypes.toString().trim());
            }
        } else {
            xsdSchema.getContents().add(xsdComplexTypeDefinition);
        }
        this.map(xsdComplexTypeDefinition, eClass);
        String instanceClass = eClass.getInstanceClassName();
        if (instanceClass != null) {
            this.createEcoreAnnotation(xsdComplexTypeDefinition, "instanceClass", instanceClass);
        }
        if (!name.equals(ecoreName = eClass.getName()) || Character.isLowerCase(ecoreName.charAt(0)) || ecoreName.indexOf(95) != -1) {
            this.createEcoreAnnotation(xsdComplexTypeDefinition, "name", ecoreName);
        }
        if (eClass.isInterface()) {
            this.createEcoreAnnotation(xsdComplexTypeDefinition, "interface", "true");
        }
        if ((constraints = EcoreUtil.getAnnotation(eClass, "http://www.eclipse.org/emf/2002/Ecore", "constraints")) != null) {
            this.createEcoreAnnotation(xsdComplexTypeDefinition, "constraints", constraints);
        }
        Iterator i = eClass.getEStructuralFeatures().iterator();
        while (i.hasNext()) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)i.next();
            this.buildContentFeature(xsdComplexTypeDefinition, eStructuralFeature);
        }
        EList<EOperation> eOperations = eClass.getEOperations();
        if (!eOperations.isEmpty()) {
            XSDAnnotation xsdAnnotation = XSDFactory.eINSTANCE.createXSDAnnotation();
            xsdComplexTypeDefinition.setAnnotation(xsdAnnotation);
            Element applicationInformation = xsdAnnotation.createApplicationInformation("http://www.eclipse.org/emf/2002/Ecore");
            xsdAnnotation.getElement().appendChild(applicationInformation);
            this.createEcoreAnnotation(xsdSchema.getQNamePrefixToNamespaceMap(), applicationInformation, "key", "operations");
            Document document = xsdSchema.getDocument();
            Map qNamePrefixToNamespaceMap = xsdSchema.getQNamePrefixToNamespaceMap();
            Iterator i2 = eOperations.iterator();
            while (i2.hasNext()) {
                String body;
                EList<EClassifier> exceptions;
                XSDTypeDefinition returnType;
                EOperation eOperation = (EOperation)i2.next();
                Element operation = document.createElementNS(null, "operation");
                operation.setAttributeNS(null, "name", eOperation.getName());
                applicationInformation.appendChild(operation);
                this.buildAnnotation(eOperation, operation);
                EClassifier returnEType = eOperation.getEType();
                if (returnEType != null && !XSDConstants.isURType(returnType = xsdSchema.resolveTypeDefinitionURI(this.getURI(returnEType)))) {
                    this.handleImport(xsdSchema, returnType);
                    String prefix = this.handlePrefix(qNamePrefixToNamespaceMap, returnEType.getEPackage().getNsPrefix(), returnType.getTargetNamespace());
                    operation.setAttributeNS(null, "type", String.valueOf(prefix) + ":" + returnType.getName());
                }
                if (!(exceptions = eOperation.getEExceptions()).isEmpty()) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Iterator j = eOperation.getEExceptions().iterator();
                    while (j.hasNext()) {
                        EClassifier eClassifier = (EClassifier)j.next();
                        XSDTypeDefinition exceptionType = xsdSchema.resolveTypeDefinitionURI(this.getURI(eClassifier));
                        this.handleImport(xsdSchema, exceptionType);
                        String prefix = this.handlePrefix(qNamePrefixToNamespaceMap, eClassifier.getEPackage().getNsPrefix(), exceptionType.getTargetNamespace());
                        stringBuffer.append(prefix);
                        stringBuffer.append(':');
                        stringBuffer.append(exceptionType.getName());
                        stringBuffer.append(' ');
                    }
                    operation.setAttributeNS(null, "exceptions", stringBuffer.substring(0, stringBuffer.length() - 1));
                }
                Iterator j = eOperation.getEParameters().iterator();
                while (j.hasNext()) {
                    EParameter eParameter = (EParameter)j.next();
                    Element parameter = document.createElementNS(null, "parameter");
                    parameter.setAttributeNS(null, "name", eParameter.getName());
                    operation.appendChild(parameter);
                    this.buildAnnotation(eParameter, parameter);
                    EClassifier parameterEType = eParameter.getEType();
                    XSDTypeDefinition parameterType = xsdSchema.resolveTypeDefinitionURI(this.getURI(parameterEType));
                    if (!XSDConstants.isURType(parameterType)) {
                        this.handleImport(xsdSchema, parameterType);
                        String prefix = this.handlePrefix(qNamePrefixToNamespaceMap, parameterEType.getEPackage().getNsPrefix(), parameterType.getTargetNamespace());
                        parameter.setAttributeNS(null, "type", String.valueOf(prefix) + ":" + parameterType.getName());
                    }
                    if (eParameter.getLowerBound() != 0) {
                        parameter.setAttributeNS(null, "lowerBound", Integer.toString(eParameter.getLowerBound()));
                    }
                    if (eParameter.getUpperBound() != 1) {
                        parameter.setAttributeNS(null, "upperBound", Integer.toString(eParameter.getUpperBound()));
                    }
                    if (!eParameter.isOrdered()) {
                        parameter.setAttributeNS(null, "ordered", "false");
                    }
                    if (eParameter.isUnique()) continue;
                    parameter.setAttributeNS(null, "unique", "false");
                }
                if (eOperation.getLowerBound() != 0) {
                    operation.setAttributeNS(null, "lowerBound", Integer.toString(eOperation.getLowerBound()));
                }
                if (eOperation.getUpperBound() != 1) {
                    operation.setAttributeNS(null, "upperBound", Integer.toString(eOperation.getUpperBound()));
                }
                if (!eOperation.isOrdered()) {
                    operation.setAttributeNS(null, "ordered", "false");
                }
                if (!eOperation.isUnique()) {
                    operation.setAttributeNS(null, "unique", "false");
                }
                if ((body = EcoreUtil.getAnnotation(eOperation, GEN_MODEL_PACKAGE_NS_URI, "body")) == null) continue;
                Element bodyElement = document.createElementNS(null, "body");
                bodyElement.appendChild(document.createTextNode(body));
                operation.appendChild(bodyElement);
            }
        }
        this.buildAnnotations(xsdComplexTypeDefinition, eClass);
        return xsdComplexTypeDefinition;
    }

    protected XSDComponent buildContentFeature(XSDComplexTypeDefinition xsdComplexTypeDefinition, EStructuralFeature eStructuralFeature) {
        switch (this.extendedMetaData.getFeatureKind(eStructuralFeature)) {
            case 4: {
                XSDParticle xsdParticle = this.buildElementParticle(xsdComplexTypeDefinition, eStructuralFeature);
                return xsdParticle;
            }
            case 2: {
                XSDAttributeUse xsdAttributeUse = this.buildAttributeUse(xsdComplexTypeDefinition, eStructuralFeature);
                return xsdAttributeUse;
            }
            case 6: {
                XSDParticle xsdParticle = this.buildModelGroupParticle(xsdComplexTypeDefinition, eStructuralFeature);
                return xsdParticle;
            }
            case 5: {
                XSDWildcard xsdWildcard = this.buildElementWildcard(xsdComplexTypeDefinition, eStructuralFeature);
                return xsdWildcard;
            }
            case 3: {
                XSDWildcard xsdWildcard = this.buildAttributeWildcard(xsdComplexTypeDefinition, eStructuralFeature);
                return xsdWildcard;
            }
            case 1: {
                XSDSimpleTypeDefinition xsdSimpleTypeDefinition = this.buildSimpleContent(xsdComplexTypeDefinition, eStructuralFeature);
                return xsdSimpleTypeDefinition;
            }
        }
        if (eStructuralFeature instanceof EAttribute) {
            EAttribute eAttribute = (EAttribute)eStructuralFeature;
            if (eAttribute.isMany()) {
                return this.buildElementParticle(xsdComplexTypeDefinition, eAttribute);
            }
            return this.buildAttributeUse(xsdComplexTypeDefinition, eAttribute);
        }
        EReference eReference = (EReference)eStructuralFeature;
        if (eReference.isContainment()) {
            return this.buildElementParticle(xsdComplexTypeDefinition, eReference);
        }
        if (eReference.isContainer() && eReference.isTransient()) {
            return null;
        }
        return this.buildAttributeUse(xsdComplexTypeDefinition, eReference);
    }

    protected XSDParticle buildModelGroupParticle(XSDComplexTypeDefinition xsdComplexTypeDefinition, EStructuralFeature eStructuralFeature) {
        XSDModelGroup xsdModelGroup = this.findOrCreateModelGroup(xsdComplexTypeDefinition);
        XSDModelGroup modelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
        modelGroup.setCompositor(XSDCompositor.CHOICE_LITERAL);
        XSDParticle xsdParticle = XSDFactory.eINSTANCE.createXSDParticle();
        xsdParticle.setContent(modelGroup);
        if (eStructuralFeature.getUpperBound() != 1) {
            xsdParticle.setMaxOccurs(eStructuralFeature.getUpperBound());
        }
        xsdModelGroup.getContents().add(xsdParticle);
        this.map(xsdParticle, eStructuralFeature);
        this.createEcoreAnnotation(xsdParticle, "featureName", eStructuralFeature.getName());
        this.buildAnnotations(xsdModelGroup, eStructuralFeature);
        return xsdParticle;
    }

    protected XSDWildcard buildElementWildcard(XSDComplexTypeDefinition xsdComplexTypeDefinition, EStructuralFeature eStructuralFeature) {
        String name = this.extendedMetaData.getName(eStructuralFeature);
        if (":mixed".equals(name)) {
            xsdComplexTypeDefinition.setMixed(true);
            return null;
        }
        XSDWildcard xsdWildcard = XSDFactory.eINSTANCE.createXSDWildcard();
        xsdWildcard.setStringLexicalNamespaceConstraint(BasicExtendedMetaData.getEncodedWildcards(this.extendedMetaData.getNamespace(eStructuralFeature.getEContainingClass()), this.extendedMetaData.getWildcards(eStructuralFeature)));
        XSDModelGroup xsdModelGroup = this.findOrCreateModelGroup(xsdComplexTypeDefinition);
        XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
        particle.setContent(xsdWildcard);
        xsdModelGroup.getContents().add(particle);
        this.map(particle, eStructuralFeature);
        this.createEcoreAnnotation(xsdWildcard, "name", eStructuralFeature.getName());
        this.buildAnnotations(xsdWildcard, eStructuralFeature);
        return xsdWildcard;
    }

    protected XSDWildcard buildAttributeWildcard(XSDComplexTypeDefinition xsdComplexTypeDefinition, EStructuralFeature eStructuralFeature) {
        XSDWildcard xsdWildcard = XSDFactory.eINSTANCE.createXSDWildcard();
        xsdWildcard.setStringLexicalNamespaceConstraint(BasicExtendedMetaData.getEncodedWildcards(this.extendedMetaData.getNamespace(eStructuralFeature.getEContainingClass()), this.extendedMetaData.getWildcards(eStructuralFeature)));
        xsdComplexTypeDefinition.setAttributeWildcardContent(xsdWildcard);
        this.map(xsdWildcard, eStructuralFeature);
        this.createEcoreAnnotation(xsdWildcard, "name", eStructuralFeature.getName());
        this.buildAnnotations(xsdWildcard, eStructuralFeature);
        return xsdWildcard;
    }

    protected XSDSimpleTypeDefinition buildSimpleContent(XSDComplexTypeDefinition xsdComplexTypeDefinition, EStructuralFeature eStructuralFeature) {
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = XSDFactory.eINSTANCE.createXSDSimpleTypeDefinition();
        XSDSimpleTypeDefinition baseType = xsdComplexTypeDefinition.resolveSimpleTypeDefinitionURI(this.getURI(eStructuralFeature.getEType()));
        this.handleImport(xsdComplexTypeDefinition.getSchema(), baseType);
        xsdComplexTypeDefinition.setBaseTypeDefinition(baseType);
        xsdComplexTypeDefinition.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
        xsdComplexTypeDefinition.setContent(xsdSimpleTypeDefinition);
        this.buildAnnotations(xsdSimpleTypeDefinition, eStructuralFeature);
        return xsdSimpleTypeDefinition;
    }

    protected XSDAttributeUse buildAttributeUse(XSDComplexTypeDefinition xsdComplexTypeDefinition, EStructuralFeature eStructuralFeature) {
        String ecoreName;
        String defaultValue;
        EReference eReference;
        EReference eOpposite;
        boolean isRef;
        String namespace = this.extendedMetaData.getNamespace(eStructuralFeature);
        String name = this.extendedMetaData.getName(eStructuralFeature);
        String typeNamespace = this.extendedMetaData.getNamespace(eStructuralFeature.getEContainingClass());
        boolean bl = isRef = namespace != null && !namespace.equals(typeNamespace);
        if (namespace == null ? typeNamespace == null : namespace.equals(typeNamespace)) {
            EStructuralFeature globalFeature = this.extendedMetaData.getAttribute(namespace, name);
            isRef = globalFeature != null && globalFeature.getEType() == eStructuralFeature.getEType();
        }
        XSDAttributeUse xsdAttributeUse = XSDFactory.eINSTANCE.createXSDAttributeUse();
        XSDAttributeDeclaration xsdAttributeDeclaration = XSDFactory.eINSTANCE.createXSDAttributeDeclaration();
        EClassifier referenceType = null;
        if (isRef) {
            XSDAttributeDeclaration referencedXSDAttributeDeclaration = xsdComplexTypeDefinition.resolveAttributeDeclaration(namespace, name);
            this.handleImport(xsdComplexTypeDefinition.getSchema(), referencedXSDAttributeDeclaration);
            xsdAttributeDeclaration.setResolvedAttributeDeclaration(referencedXSDAttributeDeclaration);
        } else {
            XSDSimpleTypeDefinition xsdSimpleTypeDefinition;
            xsdAttributeDeclaration.setName(name);
            if (namespace != null) {
                xsdAttributeDeclaration.setForm(XSDForm.QUALIFIED_LITERAL);
            }
            EClassifier eType = eStructuralFeature.getEType();
            if (eStructuralFeature instanceof EReference) {
                referenceType = eType;
                xsdSimpleTypeDefinition = xsdComplexTypeDefinition.getSchema().getSchemaForSchema().resolveSimpleTypeDefinition(((EReference)eStructuralFeature).isResolveProxies() ? "anyURI" : "IDREF");
                this.handleMultiplicity(xsdComplexTypeDefinition.getSchema(), eStructuralFeature, xsdAttributeDeclaration, xsdSimpleTypeDefinition);
            } else {
                xsdSimpleTypeDefinition = xsdComplexTypeDefinition.resolveSimpleTypeDefinitionURI(this.getURI(eType));
                this.handleImport(xsdComplexTypeDefinition.getSchema(), xsdSimpleTypeDefinition);
                this.handleMultiplicity(xsdComplexTypeDefinition.getSchema(), eStructuralFeature, xsdAttributeDeclaration, xsdSimpleTypeDefinition);
            }
        }
        xsdAttributeUse.setContent(xsdAttributeDeclaration);
        xsdComplexTypeDefinition.getAttributeContents().add(xsdAttributeUse);
        this.map(xsdAttributeUse, eStructuralFeature);
        if (referenceType == null && eStructuralFeature.isMany()) {
            this.createEcoreAnnotation(xsdAttributeUse, "many", "true");
        }
        if (eStructuralFeature instanceof EReference && (eOpposite = (eReference = (EReference)eStructuralFeature).getEOpposite()) != null) {
            this.createEcoreAnnotation(xsdAttributeUse, "opposite", eOpposite.getName());
        }
        boolean canHaveDefault = true;
        if (eStructuralFeature.isRequired()) {
            if (eStructuralFeature.isTransient()) {
                this.createEcoreAnnotation(xsdAttributeUse, "lowerBound", Integer.toString(eStructuralFeature.getLowerBound()));
            } else {
                xsdAttributeUse.setUse(XSDAttributeUseCategory.REQUIRED_LITERAL);
                canHaveDefault = false;
            }
        }
        if ((defaultValue = eStructuralFeature.getDefaultValueLiteral()) != null) {
            if (canHaveDefault) {
                if (isRef) {
                    xsdAttributeUse.setConstraint(XSDConstraint.DEFAULT_LITERAL);
                    xsdAttributeUse.setLexicalValue(defaultValue);
                } else {
                    xsdAttributeDeclaration.setConstraint(XSDConstraint.DEFAULT_LITERAL);
                    xsdAttributeDeclaration.setLexicalValue(defaultValue);
                }
            } else {
                this.createEcoreAnnotation(xsdAttributeUse, "default", defaultValue);
            }
        }
        if (eStructuralFeature.isMany()) {
            if (eStructuralFeature.isUnsettable()) {
                this.createEcoreAnnotation(xsdAttributeUse, "unsettable", "true");
            }
        } else if ((eStructuralFeature.getEType().getDefaultValue() != null || eStructuralFeature.getDefaultValueLiteral() != null) != eStructuralFeature.isUnsettable()) {
            this.createEcoreAnnotation(xsdAttributeUse, "unsettable", Boolean.toString(eStructuralFeature.isUnsettable()));
        }
        if (!name.equals(ecoreName = eStructuralFeature.getName()) || Character.isUpperCase(ecoreName.charAt(0)) || ecoreName.indexOf(95) != -1) {
            this.createEcoreAnnotation(xsdAttributeUse, "name", ecoreName);
        }
        if (eStructuralFeature.isMany() && !eStructuralFeature.isOrdered()) {
            this.createEcoreAnnotation(xsdAttributeUse, "ordered", "false");
        }
        if (eStructuralFeature.isMany() && eStructuralFeature.isUnique() && eStructuralFeature instanceof EAttribute) {
            this.createEcoreAnnotation(xsdAttributeUse, "unique", "true");
        }
        if (!eStructuralFeature.isChangeable()) {
            this.createEcoreAnnotation(xsdAttributeUse, "changeable", "false");
        }
        if (this.extendedMetaData.getGroup(eStructuralFeature) == null) {
            if (eStructuralFeature.isDerived()) {
                this.createEcoreAnnotation(xsdAttributeUse, "derived", "true");
            }
            if (eStructuralFeature.isTransient()) {
                this.createEcoreAnnotation(xsdAttributeUse, "transient", "true");
            }
            if (eStructuralFeature.isVolatile()) {
                this.createEcoreAnnotation(xsdAttributeUse, "volatile", "true");
            }
        }
        if (referenceType != null) {
            XSDTypeDefinition xsdTypeDefinition = xsdComplexTypeDefinition.resolveTypeDefinitionURI(this.getURI(referenceType));
            this.handleImport(xsdComplexTypeDefinition.getSchema(), xsdTypeDefinition);
            String prefix = this.handlePrefix(xsdComplexTypeDefinition.getSchema().getQNamePrefixToNamespaceMap(), referenceType.getEPackage().getNsPrefix(), xsdTypeDefinition.getTargetNamespace());
            this.createEcoreAnnotation(xsdAttributeUse, "reference", String.valueOf(prefix) + ":" + xsdTypeDefinition.getName());
        }
        if (EcoreUtil.isSuppressedVisibility(eStructuralFeature, 0)) {
            this.createEcoreAnnotation(xsdAttributeUse, "suppressedGetVisibility", "true");
        }
        if (EcoreUtil.isSuppressedVisibility(eStructuralFeature, 1)) {
            this.createEcoreAnnotation(xsdAttributeUse, "suppressedSetVisibility", "true");
        }
        if (EcoreUtil.isSuppressedVisibility(eStructuralFeature, 2)) {
            this.createEcoreAnnotation(xsdAttributeUse, "suppressedIsSetVisibility", "true");
        }
        if (EcoreUtil.isSuppressedVisibility(eStructuralFeature, 3)) {
            this.createEcoreAnnotation(xsdAttributeUse, "suppressedUnsetVisibility", "true");
        }
        this.buildAnnotations(xsdAttributeUse, eStructuralFeature);
        return xsdAttributeUse;
    }

    protected void handleMultiplicity(XSDSchema xsdSchema, EStructuralFeature eStructuralFeature, XSDAttributeDeclaration xsdAttributeDeclaration, XSDSimpleTypeDefinition xsdSimpleTypeDefinition) {
        if (eStructuralFeature.isMany()) {
            XSDSimpleTypeDefinition xsdListTypeDefinition;
            if (xsdSimpleTypeDefinition.hasNameAndTargetNamespace("IDREF", this.defaultXMLSchemaNamespace)) {
                xsdListTypeDefinition = xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("IDREFS");
            } else {
                xsdListTypeDefinition = XSDFactory.eINSTANCE.createXSDSimpleTypeDefinition();
                xsdListTypeDefinition.setItemTypeDefinition(xsdSimpleTypeDefinition);
            }
            if (eStructuralFeature.getLowerBound() > 1 || eStructuralFeature.getUpperBound() > 1) {
                XSDSimpleTypeDefinition xsdRestrictedTypeDefinition = XSDFactory.eINSTANCE.createXSDSimpleTypeDefinition();
                if (xsdListTypeDefinition.getContainer() == null) {
                    xsdRestrictedTypeDefinition.getContents().add(xsdListTypeDefinition);
                } else {
                    xsdRestrictedTypeDefinition.setBaseTypeDefinition(xsdListTypeDefinition);
                }
                if (eStructuralFeature.getLowerBound() == eStructuralFeature.getUpperBound()) {
                    XSDLengthFacet xsdLengthFacet = XSDFactory.eINSTANCE.createXSDLengthFacet();
                    xsdLengthFacet.setLexicalValue(Integer.toString(eStructuralFeature.getLowerBound()));
                    xsdRestrictedTypeDefinition.getFacetContents().add(xsdLengthFacet);
                } else {
                    if (eStructuralFeature.getLowerBound() > 1) {
                        XSDMinLengthFacet xsdMinLengthFacet = XSDFactory.eINSTANCE.createXSDMinLengthFacet();
                        xsdMinLengthFacet.setLexicalValue(Integer.toString(eStructuralFeature.getLowerBound()));
                        xsdRestrictedTypeDefinition.getFacetContents().add(xsdMinLengthFacet);
                    }
                    if (eStructuralFeature.getUpperBound() > 1) {
                        XSDMaxLengthFacet xsdMaxLengthFacet = XSDFactory.eINSTANCE.createXSDMaxLengthFacet();
                        xsdMaxLengthFacet.setLexicalValue(Integer.toString(eStructuralFeature.getUpperBound()));
                        xsdRestrictedTypeDefinition.getFacetContents().add(xsdMaxLengthFacet);
                    }
                }
                xsdAttributeDeclaration.setAnonymousTypeDefinition(xsdRestrictedTypeDefinition);
            } else if (xsdListTypeDefinition.getContainer() == null) {
                xsdAttributeDeclaration.setAnonymousTypeDefinition(xsdListTypeDefinition);
            } else {
                xsdAttributeDeclaration.setTypeDefinition(xsdListTypeDefinition);
            }
        } else {
            xsdAttributeDeclaration.setTypeDefinition(xsdSimpleTypeDefinition);
        }
    }

    protected XSDParticle buildElementParticle(XSDComplexTypeDefinition xsdComplexTypeDefinition, EStructuralFeature eStructuralFeature) {
        String ecoreName;
        XSDParticle xsdParticle;
        boolean isRef;
        String namespace = this.extendedMetaData.getNamespace(eStructuralFeature);
        String name = this.extendedMetaData.getName(eStructuralFeature);
        String typeNamespace = this.extendedMetaData.getNamespace(eStructuralFeature.getEContainingClass());
        boolean bl = isRef = namespace != null && !namespace.equals(typeNamespace);
        if (namespace == null ? typeNamespace == null : namespace.equals(typeNamespace)) {
            EStructuralFeature globalFeature = this.extendedMetaData.getElement(namespace, name);
            isRef = globalFeature != null && globalFeature.getEType() == eStructuralFeature.getEType();
        }
        XSDModelGroup xsdModelGroup = this.findOrCreateModelGroup(xsdComplexTypeDefinition);
        EStructuralFeature group = this.extendedMetaData.getGroup(eStructuralFeature);
        if (group != null && (xsdParticle = (XSDParticle)this.eModelElementToXSDComponentMap.get(group)) != null) {
            xsdModelGroup = (XSDModelGroup)xsdParticle.getContent();
        }
        XSDElementDeclaration xsdElementDeclaration = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        EClassifier referenceType = null;
        EReference eOpposite = null;
        if (isRef) {
            XSDElementDeclaration referencedXSDElementDeclaration = xsdComplexTypeDefinition.resolveElementDeclaration(namespace, name);
            this.handleImport(xsdComplexTypeDefinition.getSchema(), referencedXSDElementDeclaration);
            xsdElementDeclaration.setResolvedElementDeclaration(referencedXSDElementDeclaration);
            if (eStructuralFeature instanceof EReference) {
                eOpposite = ((EReference)eStructuralFeature).getEOpposite();
            }
        } else {
            String defaultValue;
            xsdElementDeclaration.setName(name);
            if (namespace != null) {
                xsdElementDeclaration.setForm(XSDForm.QUALIFIED_LITERAL);
            }
            if ((defaultValue = eStructuralFeature.getDefaultValueLiteral()) != null) {
                xsdElementDeclaration.setConstraint(XSDConstraint.DEFAULT_LITERAL);
                xsdElementDeclaration.setLexicalValue(defaultValue);
            }
            XSDTypeDefinition xsdTypeDefinition = xsdComplexTypeDefinition.resolveTypeDefinitionURI(this.getURI(eStructuralFeature.getEType()));
            if (eStructuralFeature instanceof EReference) {
                EReference eReference = (EReference)eStructuralFeature;
                eOpposite = eReference.getEOpposite();
                if (!eReference.isContainment() && !eReference.isContainer()) {
                    referenceType = eStructuralFeature.getEType();
                    xsdTypeDefinition = xsdComplexTypeDefinition.getSchema().getSchemaForSchema().resolveTypeDefinition(eReference.isResolveProxies() ? "anyURI" : "IDREF");
                }
            }
            this.handleImport(xsdComplexTypeDefinition.getSchema(), xsdTypeDefinition);
            xsdElementDeclaration.setTypeDefinition(xsdTypeDefinition);
            if (this.isWrapperType(eStructuralFeature.getEType()) || eStructuralFeature instanceof EAttribute && eStructuralFeature.getEType().getDefaultValue() == null && (eStructuralFeature.isMany() || !eStructuralFeature.isRequired() && (eStructuralFeature.getDefaultValueLiteral() != null || eStructuralFeature.isUnsettable()))) {
                xsdElementDeclaration.setNillable(true);
            }
        }
        XSDParticle xsdParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
        xsdParticle2.setContent(xsdElementDeclaration);
        xsdModelGroup.getContents().add(xsdParticle2);
        this.map(xsdParticle2, eStructuralFeature);
        if (eStructuralFeature.isMany()) {
            if (eStructuralFeature.isUnsettable()) {
                this.createEcoreAnnotation(xsdParticle2, "unsettable", "true");
            }
        } else if (xsdElementDeclaration.isNillable() ? !eStructuralFeature.isUnsettable() : (eStructuralFeature.getEType().getDefaultValue() != null || eStructuralFeature.getDefaultValueLiteral() != null) != eStructuralFeature.isUnsettable()) {
            this.createEcoreAnnotation(xsdParticle2, "unsettable", Boolean.toString(eStructuralFeature.isUnsettable()));
        }
        if (eOpposite != null) {
            this.createEcoreAnnotation(xsdParticle2, "opposite", eOpposite.getName());
        }
        if (group == null) {
            if (eStructuralFeature.isTransient() && !xsdComplexTypeDefinition.isMixed()) {
                xsdParticle2.setMinOccurs(0);
                if (eStructuralFeature.getLowerBound() != 0) {
                    this.createEcoreAnnotation(xsdParticle2, "lowerBound", Integer.toString(eStructuralFeature.getLowerBound()));
                }
            } else if (eStructuralFeature.getLowerBound() != 1) {
                xsdParticle2.setMinOccurs(eStructuralFeature.getLowerBound());
            }
            if (eStructuralFeature.getUpperBound() != 1) {
                xsdParticle2.setMaxOccurs(eStructuralFeature.getUpperBound());
            }
        } else {
            if (eStructuralFeature.isTransient() && !xsdComplexTypeDefinition.isMixed()) {
                xsdParticle2.setMinOccurs(0);
                if (eStructuralFeature.getLowerBound() != 0) {
                    this.createEcoreAnnotation(xsdParticle2, "lowerBound", Integer.toString(eStructuralFeature.getLowerBound()));
                }
            } else if (eStructuralFeature.getLowerBound() != 1) {
                this.createEcoreAnnotation(xsdParticle2, "lowerBound", Integer.toString(eStructuralFeature.getLowerBound()));
            }
            if (eStructuralFeature.getUpperBound() != 1) {
                this.createEcoreAnnotation(xsdParticle2, "upperBound", Integer.toString(eStructuralFeature.getUpperBound()));
            }
        }
        if (!name.equals(ecoreName = eStructuralFeature.getName()) || Character.isUpperCase(ecoreName.charAt(0)) || ecoreName.indexOf(95) != -1) {
            this.createEcoreAnnotation(xsdParticle2, "name", ecoreName);
        }
        if (eStructuralFeature.isMany() && !eStructuralFeature.isOrdered()) {
            this.createEcoreAnnotation(xsdParticle2, "ordered", "false");
        }
        if (eStructuralFeature.isMany() && eStructuralFeature.isUnique() && eStructuralFeature instanceof EAttribute) {
            this.createEcoreAnnotation(xsdParticle2, "unique", "true");
        }
        if (!eStructuralFeature.isChangeable()) {
            this.createEcoreAnnotation(xsdParticle2, "changeable", "false");
        }
        if (this.extendedMetaData.getContentKind(eStructuralFeature.getEContainingClass()) != 3 && this.extendedMetaData.getGroup(eStructuralFeature) == null) {
            if (eStructuralFeature.isDerived()) {
                this.createEcoreAnnotation(xsdParticle2, "derived", "true");
            }
            if (eStructuralFeature.isTransient()) {
                this.createEcoreAnnotation(xsdParticle2, "transient", "true");
            }
            if (eStructuralFeature.isVolatile()) {
                this.createEcoreAnnotation(xsdParticle2, "volatile", "true");
            }
        }
        if (eStructuralFeature instanceof EReference && ((EReference)eStructuralFeature).isResolveProxies() && ((EReference)eStructuralFeature).isContainment()) {
            this.createEcoreAnnotation(xsdParticle2, "resolveProxies", "true");
        }
        if (referenceType != null) {
            XSDTypeDefinition xsdTypeDefinition = xsdComplexTypeDefinition.resolveTypeDefinitionURI(this.getURI(referenceType));
            this.handleImport(xsdComplexTypeDefinition.getSchema(), xsdTypeDefinition);
            String prefix = this.handlePrefix(xsdComplexTypeDefinition.getSchema().getQNamePrefixToNamespaceMap(), referenceType.getEPackage().getNsPrefix(), xsdTypeDefinition.getTargetNamespace());
            this.createEcoreAnnotation(xsdElementDeclaration, "reference", String.valueOf(prefix) + ":" + xsdTypeDefinition.getName());
        }
        if (EcoreUtil.isSuppressedVisibility(eStructuralFeature, 0)) {
            this.createEcoreAnnotation(xsdElementDeclaration, "suppressedGetVisibility", "true");
        }
        if (EcoreUtil.isSuppressedVisibility(eStructuralFeature, 1)) {
            this.createEcoreAnnotation(xsdElementDeclaration, "suppressedSetVisibility", "true");
        }
        if (EcoreUtil.isSuppressedVisibility(eStructuralFeature, 2)) {
            this.createEcoreAnnotation(xsdElementDeclaration, "suppressedIsSetVisibility", "true");
        }
        if (EcoreUtil.isSuppressedVisibility(eStructuralFeature, 3)) {
            this.createEcoreAnnotation(xsdElementDeclaration, "suppressedUnsetVisibility", "true");
        }
        this.buildAnnotations(xsdParticle2, eStructuralFeature);
        return xsdParticle2;
    }

    protected XSDModelGroup findOrCreateModelGroup(XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        if (xsdComplexTypeDefinition.getContent() == null) {
            return this.buildModelGroup(xsdComplexTypeDefinition);
        }
        XSDParticle xsdParticle = (XSDParticle)xsdComplexTypeDefinition.getContent();
        return (XSDModelGroup)xsdParticle.getContent();
    }

    protected XSDModelGroup buildModelGroup(XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        XSDModelGroup xsdModelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        XSDParticle xsdParticle = XSDFactory.eINSTANCE.createXSDParticle();
        xsdParticle.setContent(xsdModelGroup);
        xsdComplexTypeDefinition.setContent(xsdParticle);
        return xsdModelGroup;
    }

    protected boolean isWrapperType(EClassifier eClassifier) {
        String name = this.extendedMetaData.getName(eClassifier);
        return name.endsWith(":Object") && !"http://www.eclipse.org/emf/2002/Ecore".equals(this.extendedMetaData.getNamespace(eClassifier));
    }

    protected String getURI(EClassifier eClassifier) {
        String namespace = this.extendedMetaData.getNamespace(eClassifier);
        String name = this.extendedMetaData.getName(eClassifier);
        if ("http://www.eclipse.org/emf/2003/XMLType".equals(namespace)) {
            namespace = this.defaultXMLSchemaNamespace;
            if (name.endsWith(":Object")) {
                name = name.substring(0, name.length() - 7);
            }
        } else if ("http://www.eclipse.org/emf/2002/Ecore".equals(namespace)) {
            if ("EObject".equals(name)) {
                namespace = this.defaultXMLSchemaNamespace;
                name = "anyType";
            } else if (name.endsWith(":Object")) {
                name = eClassifier.getName();
            }
        } else if (name.endsWith(":Object")) {
            name = name.substring(0, name.length() - 7);
        }
        String result = namespace == null ? name : String.valueOf(namespace) + "#" + name;
        return result;
    }

    protected void createEcoreAnnotation(XSDComponent xsdComponent, String key, String value) {
        Element element = xsdComponent.getElement();
        if (element != null) {
            this.createEcoreAnnotation(xsdComponent.getSchema().getQNamePrefixToNamespaceMap(), element, key, value);
        }
    }

    protected void createEcoreAnnotation(Map qNamePrefixToNamespaceMap, Element element, String key, String value) {
        String ecorePrefix = this.handlePrefix(qNamePrefixToNamespaceMap, "ecore", "http://www.eclipse.org/emf/2002/Ecore");
        element.setAttributeNS("http://www.eclipse.org/emf/2002/Ecore", String.valueOf(ecorePrefix) + ':' + key, value);
    }

    protected void createAnnotation(XSDComponent xsdComponent, String namespace, String key, String value) {
        Element element = xsdComponent.getElement();
        if (element != null) {
            this.createAnnotation(xsdComponent.getSchema().getQNamePrefixToNamespaceMap(), element, namespace, key, value);
        }
    }

    protected void createAnnotation(Map qNamePrefixToNamespaceMap, Element element, String namespace, String key, String value) {
        String prefix = this.handlePrefix(qNamePrefixToNamespaceMap, this.qualifiedPackageName(namespace), namespace);
        element.setAttributeNS(namespace, String.valueOf(prefix) + ':' + key, value);
    }

    protected void handleImport(XSDSchema xsdSchema, XSDNamedComponent xsdNamedComponent) {
        String namespace = xsdNamedComponent.getTargetNamespace();
        if (!this.defaultXMLSchemaNamespace.equals(namespace) && (namespace == null ? xsdSchema.getTargetNamespace() != null : !namespace.equals(xsdSchema.getTargetNamespace()))) {
            Iterator i = xsdSchema.getContents().iterator();
            while (i.hasNext()) {
                Object content = i.next();
                if (content instanceof XSDImport) {
                    XSDImport xsdImport = (XSDImport)content;
                    if (!(namespace == null ? xsdImport.getNamespace() == null : namespace.equals(xsdImport.getNamespace()))) continue;
                    return;
                }
                if (!(content instanceof XSDAnnotation)) break;
            }
            XSDImport xsdImport = XSDFactory.eINSTANCE.createXSDImport();
            xsdImport.setNamespace(namespace);
            EPackage ePackage = this.extendedMetaData.getPackage(namespace);
            if (ePackage != null) {
                this.handlePrefix(xsdSchema.getQNamePrefixToNamespaceMap(), ePackage.getNsPrefix(), namespace);
                xsdImport.setSchemaLocation(ePackage.getNsURI());
            }
            xsdSchema.getContents().add(0, xsdImport);
        }
    }

    protected String handlePrefix(Map namespaces, String preferredPrefix, String namespace) {
        if ("http://www.w3.org/XML/1998/namespace".equals(namespace)) {
            return "xml";
        }
        String value = (String)namespaces.get(preferredPrefix);
        if (namespace == null ? value == null : namespace.equals(value)) {
            return preferredPrefix;
        }
        if (value != null || this.defaultXMLSchemaNamespace.equals(namespace)) {
            Iterator i = namespaces.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                if (!(namespace == null ? entry.getValue() == null : namespace.equals(entry.getValue()))) continue;
                return (String)entry.getKey();
            }
        }
        String uniquePrefix = preferredPrefix;
        int i = 0;
        while (namespaces.containsKey(uniquePrefix)) {
            uniquePrefix = String.valueOf(preferredPrefix) + "_" + i;
            ++i;
        }
        namespaces.put(uniquePrefix, namespace);
        return uniquePrefix;
    }

    protected boolean isIgnoredAnnotationSource(String sourceURI) {
        return "http://www.eclipse.org/emf/2002/Ecore".equals(sourceURI) || "http:///org/eclipse/emf/ecore/util/ExtendedMetaData".equals(sourceURI) || GEN_MODEL_PACKAGE_NS_URI.equals(sourceURI);
    }

    protected void buildAnnotations(XSDComponent xsdComponent, EModelElement eModelElement) {
        XSDAnnotation xsdAnnotation;
        Iterator i = eModelElement.getEAnnotations().iterator();
        while (i.hasNext()) {
            EAnnotation eAnnotation = (EAnnotation)i.next();
            String source = eAnnotation.getSource();
            if (this.isIgnoredAnnotationSource(source)) continue;
            XSDAnnotation xsdAnnotation2 = null;
            Iterator<Map.Entry<String, String>> j = eAnnotation.getDetails().entrySet().iterator();
            while (j.hasNext()) {
                Map.Entry<String, String> entry = j.next();
                String key = entry.getKey();
                String value = entry.getValue();
                if (key != null && value.indexOf(10) == -1 && value.indexOf(13) == -1) {
                    this.createAnnotation(xsdComponent, source, key, value);
                    continue;
                }
                if (xsdAnnotation2 == null) {
                    xsdAnnotation2 = this.buildAnnotation(xsdComponent, eModelElement);
                }
                if (xsdAnnotation2 == null) continue;
                Element applicationInformation = xsdAnnotation2.createApplicationInformation(source);
                if (key != null) {
                    this.createEcoreAnnotation(xsdComponent.getSchema().getQNamePrefixToNamespaceMap(), applicationInformation, "key", key);
                }
                if (value != null) {
                    applicationInformation.appendChild(xsdAnnotation2.getSchema().getDocument().createTextNode(value));
                }
                xsdAnnotation2.getElement().appendChild(applicationInformation);
            }
        }
        String documentation = EcoreUtil.getDocumentation(eModelElement);
        if (documentation != null && (xsdAnnotation = this.buildAnnotation(xsdComponent, eModelElement)) != null) {
            this.createUserInfo(xsdAnnotation, documentation);
        }
    }

    protected XSDAnnotation buildAnnotation(XSDConcreteComponent xsdComponent, EModelElement eModelElement) {
        XSDAttributeDeclaration xsdAttributeDeclaration;
        XSDAnnotation xsdAnnotation = null;
        if (xsdComponent instanceof XSDAttributeUse) {
            xsdComponent = ((XSDAttributeUse)xsdComponent).getContent();
        } else if (xsdComponent instanceof XSDParticle) {
            xsdComponent = ((XSDParticle)xsdComponent).getContent();
        }
        if (xsdComponent instanceof XSDSchema) {
            xsdAnnotation = XSDFactory.eINSTANCE.createXSDAnnotation();
            ((XSDSchema)xsdComponent).getContents().add(0, xsdAnnotation);
        } else if (xsdComponent instanceof XSDTypeDefinition) {
            XSDTypeDefinition xsdTypeDefinition = (XSDTypeDefinition)xsdComponent;
            xsdAnnotation = xsdTypeDefinition.getAnnotation();
            if (xsdAnnotation == null) {
                xsdAnnotation = XSDFactory.eINSTANCE.createXSDAnnotation();
                xsdTypeDefinition.setAnnotation(xsdAnnotation);
            }
        } else if (xsdComponent instanceof XSDFacet) {
            XSDFacet xsdFacet = (XSDFacet)xsdComponent;
            xsdAnnotation = xsdFacet.getAnnotation();
            if (xsdAnnotation == null) {
                xsdAnnotation = XSDFactory.eINSTANCE.createXSDAnnotation();
                xsdFacet.setAnnotation(xsdAnnotation);
            }
        } else if (xsdComponent instanceof XSDElementDeclaration) {
            XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)xsdComponent;
            xsdAnnotation = xsdElementDeclaration.getAnnotation();
            if (xsdAnnotation == null) {
                xsdAnnotation = XSDFactory.eINSTANCE.createXSDAnnotation();
                xsdElementDeclaration.setAnnotation(xsdAnnotation);
            }
        } else if (xsdComponent instanceof XSDAttributeDeclaration && (xsdAnnotation = (xsdAttributeDeclaration = (XSDAttributeDeclaration)xsdComponent).getAnnotation()) == null) {
            xsdAnnotation = XSDFactory.eINSTANCE.createXSDAnnotation();
            xsdAttributeDeclaration.setAnnotation(xsdAnnotation);
        }
        return xsdAnnotation;
    }

    protected void createUserInfo(XSDAnnotation xsdAnnotation, String documentation) {
        Element userInformation = xsdAnnotation.createUserInformation(null);
        XSDParser xsdParser = new XSDParser(null);
        xsdParser.parseString("<documentation>" + documentation + "</documentation>");
        Document document = xsdParser.getDocument();
        if (xsdParser.getDiagnostics().isEmpty() && document.getDocumentElement().getFirstChild() != null) {
            Document xsdDocument = xsdAnnotation.getSchema().getDocument();
            Node node = document.getDocumentElement().getFirstChild();
            while (node != null) {
                userInformation.appendChild(xsdDocument.importNode(node, true));
                node = node.getNextSibling();
            }
        } else {
            userInformation.appendChild(xsdAnnotation.getSchema().getDocument().createTextNode(documentation));
        }
        xsdAnnotation.getElement().appendChild(userInformation);
    }

    protected void buildAnnotation(EModelElement eModelElement, Element parent) {
        Document document = parent.getOwnerDocument();
        Iterator j = eModelElement.getEAnnotations().iterator();
        while (j.hasNext()) {
            String documentation;
            EAnnotation eAnnotation = (EAnnotation)j.next();
            String source = eAnnotation.getSource();
            if (!this.isIgnoredAnnotationSource(source)) {
                Element annotation = document.createElementNS(null, "annotation");
                if (source != null) {
                    annotation.setAttributeNS(null, "source", source);
                }
                Iterator k = eAnnotation.getDetails().iterator();
                while (k.hasNext()) {
                    Map.Entry entry = (Map.Entry)k.next();
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    Element detail = document.createElementNS(null, "detail");
                    if (key != null) {
                        detail.setAttributeNS(null, "key", key);
                    }
                    if (value != null) {
                        detail.appendChild(document.createTextNode(value));
                    }
                    annotation.appendChild(detail);
                }
                parent.appendChild(annotation);
                continue;
            }
            if (!GEN_MODEL_PACKAGE_NS_URI.equals(source) || !eAnnotation.getDetails().containsKey("documentation") || (documentation = EcoreUtil.getDocumentation(eModelElement)) == null) continue;
            Element annotation = document.createElementNS(null, "annotation");
            annotation.setAttributeNS(null, "source", GEN_MODEL_PACKAGE_NS_URI);
            Element detail = document.createElementNS(null, "detail");
            detail.setAttributeNS(null, "key", "documentation");
            detail.appendChild(document.createTextNode(documentation));
            annotation.appendChild(detail);
            parent.appendChild(annotation);
        }
    }
}

