/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.wsdl;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLElement;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.http.HTTPOperation;
import javax.wsdl.extensions.http.HTTPUrlEncoded;
import javax.wsdl.extensions.http.HTTPUrlReplacement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMimeXml;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Fault;
import javax.wsdl.extensions.soap12.SOAP12Header;
import javax.wsdl.extensions.soap12.SOAP12HeaderFault;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.collection.Collections;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.sramp.SrampLexicon;
import org.modeshape.sequencer.wsdl.WsdlLexicon;
import org.modeshape.sequencer.wsdl.WsdlReader;
import org.modeshape.sequencer.xsd.NamespaceEntityResolver;
import org.modeshape.sequencer.xsd.XsdLexicon;
import org.modeshape.sequencer.xsd.XsdReader;
import org.modeshape.sequencer.xsd.XsdResolvers;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@NotThreadSafe
public class Wsdl11Reader
extends WsdlReader<Definition> {
    protected static final XsdResolvers.SymbolSpace MESSAGES = new XsdResolvers.SymbolSpace("Messages");
    protected static final XsdResolvers.SymbolSpace PORT_TYPES = new XsdResolvers.SymbolSpace("PortTypes");
    protected static final XsdResolvers.SymbolSpace BINDINGS = new XsdResolvers.SymbolSpace("Bindings");
    protected static final XsdResolvers.SymbolSpace PORTS = new XsdResolvers.SymbolSpace("Ports");
    protected static final XsdResolvers.SymbolSpace SERVICES = new XsdResolvers.SymbolSpace("Services");
    protected XsdResolvers typeResolvers;
    protected Map<WSDLElement, UUID> uuidForComponent;
    protected Map<WSDLElement, String> nameForComponent;
    protected static final Set<String> SCHEMA_REFERENCE_ELEMENTS = Collections.unmodifiableSet((Object[])new String[]{"import", "include", "redefine", "annotation"});

    public Wsdl11Reader(SequencerOutput output, StreamSequencerContext context) {
        super(output, context);
    }

    @Override
    protected Definition parse(InputSource source, String baseUri) throws Exception {
        WSDLReader wsdlReader = WSDLFactory.newInstance().newWSDLReader();
        wsdlReader.setFeature("javax.wsdl.verbose", false);
        wsdlReader.setFeature("javax.wsdl.importDocuments", false);
        CustomWSDLLocator locator = new CustomWSDLLocator(source, baseUri);
        Definition def = wsdlReader.readWSDL(locator);
        return def;
    }

    @Override
    protected void process(Definition definition, Path docPath, long sizeOfFile) throws Exception {
        this.uuidForComponent = new HashMap<WSDLElement, UUID>();
        this.nameForComponent = new HashMap<WSDLElement, String>();
        this.output.setProperty(docPath, SrampLexicon.CONTENT_TYPE, new Object[]{"application/wsdl"});
        this.output.setProperty(docPath, SrampLexicon.CONTENT_SIZE, new Object[]{sizeOfFile});
        this.output.setProperty(docPath, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.WSDL_DOCUMENT});
        this.output.setProperty(docPath, JcrLexicon.UUID, new Object[]{UUID.randomUUID()});
        this.processDocumentation(definition, docPath);
        this.processExtensibilityElements(definition, docPath);
        this.processTypes(definition.getTypes(), docPath);
        this.processMessages(definition.getMessages(), docPath);
        this.processPortTypes(definition.getPortTypes(), docPath);
        this.processBindings(definition.getBindings(), docPath);
        this.processServices(definition.getServices(), docPath);
    }

    protected void processTypes(Types types, Path parentPath) throws Exception {
        if (types == null) {
            return;
        }
        XsdReader xsdReader = new XsdReader(this.output, this.context);
        this.typeResolvers = xsdReader.getResolvers();
        for (Object obj : types.getExtensibilityElements()) {
            if (!(obj instanceof Schema)) continue;
            this.process((Schema)obj, parentPath, xsdReader);
        }
    }

    protected void process(Schema schema, Path parentPath, XsdReader xsdReader) throws Exception {
        Element schemaElement = schema.getElement();
        NodeList childNodes = schemaElement.getChildNodes();
        boolean parseSchemaRequired = false;
        int len = childNodes.getLength();
        block3: for (int i = 0; i != len; ++i) {
            Node child = childNodes.item(i);
            switch (child.getNodeType()) {
                case 1: {
                    Element element = (Element)child;
                    if (this.processXsdReference(element, parentPath) || this.processXsdAnnotation(element, parentPath)) continue block3;
                    parseSchemaRequired = true;
                    continue block3;
                }
            }
        }
        if (parseSchemaRequired) {
            String schemaContent = this.writeXml(schemaElement);
            InputSource source = new InputSource(new StringReader(schemaContent));
            Path path = this.nextPath(parentPath, WsdlLexicon.SCHEMA);
            xsdReader.read(source, path);
        }
    }

    protected boolean processXsdReference(Element element, Path parentPath) {
        String localName = element.getLocalName();
        Name type = null;
        if (XsdLexicon.IMPORT.getLocalName().equals(localName)) {
            type = WsdlLexicon.IMPORTED_XSD;
        } else if (XsdLexicon.INCLUDE.getLocalName().equals(localName)) {
            type = WsdlLexicon.INCLUDED_XSD;
        } else if (XsdLexicon.REDEFINE.getLocalName().equals(localName)) {
            type = WsdlLexicon.REDEFINED_XSD;
        } else {
            return false;
        }
        Path path = this.nextPath(parentPath, type);
        String namespace = this.getAttributeValue(element, "http://www.w3.org/2001/XMLSchema", XsdLexicon.NAMESPACE.getLocalName());
        String location = this.getAttributeValue(element, "http://www.w3.org/2001/XMLSchema", XsdLexicon.SCHEMA_LOCATION.getLocalName());
        String id = this.getAttributeValue(element, "http://www.w3.org/2001/XMLSchema", XsdLexicon.ID.getLocalName());
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{type});
        this.output.setProperty(path, XsdLexicon.SCHEMA_LOCATION, new Object[]{location});
        if (namespace != null) {
            this.output.setProperty(path, XsdLexicon.NAMESPACE, new Object[]{namespace});
        }
        if (id != null) {
            this.output.setProperty(path, XsdLexicon.ID, new Object[]{id});
        }
        return true;
    }

    protected String getAttributeValue(Element element, String namespaceUri, String localName) {
        String result = element.getAttributeNS(namespaceUri, localName);
        if (result != null && result.length() != 0) {
            return result;
        }
        result = element.getAttribute(localName);
        if (result != null && result.length() != 0) {
            return result;
        }
        Attr namespaceAttr = element.getAttributeNode(localName);
        return namespaceAttr != null ? namespaceAttr.getValue() : null;
    }

    protected boolean processXsdAnnotation(Element element, Path parentPath) {
        String localName = element.getLocalName();
        return XsdLexicon.ANNOTATION.getLocalName().equals(localName);
    }

    protected void processMessages(Map<String, Message> messages, Path parentPath) throws Exception {
        Path messagesPath = null;
        for (Map.Entry<String, Message> entry : messages.entrySet()) {
            Message message = entry.getValue();
            if (messagesPath == null) {
                messagesPath = this.nextPath(parentPath, WsdlLexicon.MESSAGES);
                this.output.setProperty(messagesPath, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.MESSAGES});
            }
            this.processMessage(message, messagesPath);
        }
    }

    protected void processMessage(Message message, Path parentPath) throws Exception {
        Path path = this.nextPath(parentPath, message.getQName(), WsdlLexicon.MESSAGE);
        this.setReferenceable(path, MESSAGES, message.getQName());
        this.processDocumentation(message, path);
        this.processExtensibilityElements(message, path);
        for (Map.Entry entry : message.getParts().entrySet()) {
            this.processPart((Part)entry.getValue(), path);
        }
    }

    protected void processPart(Part part, Path parentPath) throws Exception {
        QName typeName;
        String ncName = part.getName();
        Path path = this.nextPath(parentPath, this.name(ncName));
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.PART});
        this.output.setProperty(path, WsdlLexicon.NC_NAME, new Object[]{ncName});
        QName elementName = part.getElementName();
        if (elementName != null) {
            this.output.setProperty(path, WsdlLexicon.ELEMENT_NAME, new Object[]{elementName.getLocalPart()});
            this.output.setProperty(path, WsdlLexicon.ELEMENT_NAMESPACE, new Object[]{elementName.getNamespaceURI()});
            this.setReference(path, WsdlLexicon.ELEMENT_REFERENCE, XsdResolvers.SymbolSpace.ELEMENT_DECLARATION, elementName);
        }
        if ((typeName = part.getTypeName()) != null) {
            this.output.setProperty(path, WsdlLexicon.TYPE_NAME, new Object[]{typeName.getLocalPart()});
            this.output.setProperty(path, WsdlLexicon.TYPE_NAMESPACE, new Object[]{typeName.getNamespaceURI()});
            this.setReference(path, WsdlLexicon.TYPE_REFERENCE, XsdResolvers.SymbolSpace.TYPE_DEFINITIONS, typeName);
        }
        this.processDocumentation(part, path);
        this.processExtensibilityElements(part, path);
    }

    protected void processPortTypes(Map<String, PortType> portTypes, Path parentPath) throws Exception {
        Path portTypesPath = null;
        for (PortType portType : portTypes.values()) {
            if (portTypesPath == null) {
                portTypesPath = this.nextPath(parentPath, WsdlLexicon.PORT_TYPES);
                this.output.setProperty(portTypesPath, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.PORT_TYPES});
            }
            this.processPortType(portType, portTypesPath);
        }
    }

    protected void processPortType(PortType portType, Path parentPath) throws Exception {
        QName qname = portType.getQName();
        Path path = this.nextPath(parentPath, qname, WsdlLexicon.PORT_TYPE);
        this.setReferenceable(path, PORT_TYPES, qname);
        for (Operation operation : portType.getOperations()) {
            this.process(operation, path, qname);
        }
        this.processDocumentation(portType, path);
        this.processExtensibilityElements(portType, path);
    }

    protected void process(Operation operation, Path parentPath, QName portTypeName) throws Exception {
        String operationName = operation.getName();
        Path path = this.nextPath(parentPath, this.name(operationName));
        this.output.setProperty(path, WsdlLexicon.NC_NAME, new Object[]{operationName});
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.OPERATION});
        OperationType style = operation.getStyle();
        this.process(operation.getInput(), path, style, operationName, portTypeName);
        this.process(operation.getOutput(), path, style, operationName, portTypeName);
        for (Fault fault : operation.getFaults().values()) {
            this.process(fault, path);
        }
        if (OperationType.REQUEST_RESPONSE.equals(style) || OperationType.SOLICIT_RESPONSE.equals(style)) {
            List partNames = operation.getParameterOrdering();
            this.output.setProperty(path, WsdlLexicon.PARAMETER_ORDER, new Object[]{partNames});
        }
        this.processDocumentation(operation, path);
        this.processExtensibilityElements(operation, path);
    }

    protected void process(Input input, Path parentPath, OperationType style, String operationName, QName portTypeName) throws Exception {
        if (input == null) {
            return;
        }
        String name = input.getName();
        if (name == null) {
            if (OperationType.ONE_WAY.equals(style)) {
                name = operationName;
            } else if (OperationType.NOTIFICATION.equals(style)) {
                name = operationName;
            } else if (OperationType.REQUEST_RESPONSE.equals(style)) {
                name = operationName + "Request";
            } else if (OperationType.SOLICIT_RESPONSE.equals(style)) {
                name = operationName + "Solicit";
            }
        }
        Path path = this.nextPath(parentPath, WsdlLexicon.INPUT);
        UUID uuid = this.uuidForComponent(input);
        this.output.setProperty(path, JcrLexicon.UUID, new Object[]{uuid});
        this.uuidForComponent.put(input, uuid);
        this.nameForComponent.put(input, name);
        this.output.setProperty(path, WsdlLexicon.NC_NAME, new Object[]{name});
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.OPERATION_INPUT});
        Message message = input.getMessage();
        if (message != null) {
            QName messageName = message.getQName();
            this.output.setProperty(path, WsdlLexicon.MESSAGE_NAME, new Object[]{messageName.getLocalPart()});
            this.output.setProperty(path, WsdlLexicon.MESSAGE_NAMESPACE, new Object[]{messageName.getNamespaceURI()});
            this.setReference(path, WsdlLexicon.MESSAGE_REFERENCE, MESSAGES, messageName);
        }
        this.processDocumentation(input, path);
        this.processExtensibilityElements(input, path);
    }

    protected void process(Output out, Path parentPath, OperationType style, String operationName, QName portTypeName) throws Exception {
        if (out == null) {
            return;
        }
        String name = out.getName();
        if (name == null) {
            if (OperationType.ONE_WAY.equals(style)) {
                name = operationName;
            } else if (OperationType.NOTIFICATION.equals(style)) {
                name = operationName;
            } else if (OperationType.REQUEST_RESPONSE.equals(style)) {
                name = operationName + "Response";
            } else if (OperationType.SOLICIT_RESPONSE.equals(style)) {
                name = operationName + "Response";
            }
        }
        Path path = this.nextPath(parentPath, WsdlLexicon.OUTPUT);
        UUID uuid = this.uuidForComponent(out);
        this.output.setProperty(path, JcrLexicon.UUID, new Object[]{uuid});
        this.uuidForComponent.put(out, uuid);
        this.nameForComponent.put(out, name);
        this.output.setProperty(path, WsdlLexicon.NC_NAME, new Object[]{name});
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.OPERATION_OUTPUT});
        Message message = out.getMessage();
        if (message != null) {
            QName messageName = message.getQName();
            this.output.setProperty(path, WsdlLexicon.MESSAGE_NAME, new Object[]{messageName.getLocalPart()});
            this.output.setProperty(path, WsdlLexicon.MESSAGE_NAMESPACE, new Object[]{messageName.getNamespaceURI()});
            this.setReference(path, WsdlLexicon.MESSAGE_REFERENCE, MESSAGES, messageName);
        }
        this.processDocumentation(out, path);
        this.processExtensibilityElements(out, path);
    }

    protected void process(Fault fault, Path parentPath) throws Exception {
        if (fault == null) {
            return;
        }
        Path path = this.nextPath(parentPath, WsdlLexicon.FAULT);
        this.output.setProperty(path, WsdlLexicon.NC_NAME, new Object[]{fault.getName()});
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.FAULT});
        Message message = fault.getMessage();
        if (message != null) {
            QName messageName = message.getQName();
            this.output.setProperty(path, WsdlLexicon.MESSAGE_NAME, new Object[]{messageName.getLocalPart()});
            this.output.setProperty(path, WsdlLexicon.MESSAGE_NAMESPACE, new Object[]{messageName.getNamespaceURI()});
            this.setReference(path, WsdlLexicon.MESSAGE_REFERENCE, MESSAGES, messageName);
        }
        this.processDocumentation(fault, path);
        this.processExtensibilityElements(fault, path);
    }

    protected void processBindings(Map<String, Binding> bindings, Path parentPath) throws Exception {
        Path bindingsPath = null;
        for (Binding binding : bindings.values()) {
            if (bindingsPath == null) {
                bindingsPath = this.nextPath(parentPath, WsdlLexicon.BINDINGS);
                this.output.setProperty(bindingsPath, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.BINDINGS});
            }
            this.processBinding(binding, bindingsPath);
        }
    }

    protected void processBinding(Binding binding, Path parentPath) throws Exception {
        QName qname = binding.getQName();
        Path path = this.nextPath(parentPath, qname, WsdlLexicon.BINDING);
        this.setReferenceable(path, BINDINGS, qname);
        PortType portType = binding.getPortType();
        QName typeName = null;
        if (portType != null) {
            typeName = portType.getQName();
            this.output.setProperty(path, WsdlLexicon.TYPE_NAME, new Object[]{typeName.getLocalPart()});
            this.output.setProperty(path, WsdlLexicon.TYPE_NAMESPACE, new Object[]{typeName.getNamespaceURI()});
            this.setReference(path, WsdlLexicon.TYPE_REFERENCE, PORT_TYPES, typeName);
        }
        binding.getBindingOperations();
        for (BindingOperation operation : binding.getBindingOperations()) {
            this.process(operation, path);
        }
        this.processDocumentation(binding, path);
        this.processExtensibilityElements(binding, path);
    }

    protected void process(BindingOperation operation, Path parentPath) throws Exception {
        String operationName = operation.getName();
        Path path = this.nextPath(parentPath, this.name(operationName));
        this.output.setProperty(path, WsdlLexicon.NC_NAME, new Object[]{operationName});
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.BINDING_OPERATION});
        Operation portTypeOperation = operation.getOperation();
        OperationType type = portTypeOperation.getStyle();
        this.process(operation.getBindingInput(), path, type, operationName, portTypeOperation);
        this.process(operation.getBindingOutput(), path, type, operationName, portTypeOperation);
        for (BindingFault fault : operation.getBindingFaults().values()) {
            this.process(fault, path);
        }
        this.processDocumentation(operation, path);
        this.processExtensibilityElements(operation, path);
    }

    protected void process(BindingInput input, Path parentPath, OperationType style, String operationName, Operation operation) throws Exception {
        if (input == null) {
            return;
        }
        String name = input.getName();
        if (name == null) {
            if (OperationType.ONE_WAY.equals(style)) {
                name = operationName;
            } else if (OperationType.NOTIFICATION.equals(style)) {
                name = operationName;
            } else if (OperationType.REQUEST_RESPONSE.equals(style)) {
                name = operationName + "Request";
            } else if (OperationType.SOLICIT_RESPONSE.equals(style)) {
                name = operationName + "Solicit";
            }
        }
        Path path = this.nextPath(parentPath, WsdlLexicon.INPUT);
        this.output.setProperty(path, WsdlLexicon.NC_NAME, new Object[]{name});
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.BINDING_OPERATION_INPUT});
        Input opInput = operation.getInput();
        this.output.setProperty(path, WsdlLexicon.INPUT_REFERENCE, new Object[]{this.uuidForComponent(opInput)});
        this.output.setProperty(path, WsdlLexicon.INPUT_NAME, new Object[]{this.nameForComponent.get(opInput)});
        this.processDocumentation(input, path);
        this.processExtensibilityElements(input, path);
    }

    protected void process(BindingOutput out, Path parentPath, OperationType style, String operationName, Operation operation) throws Exception {
        if (out == null) {
            return;
        }
        String name = out.getName();
        if (name == null) {
            if (OperationType.ONE_WAY.equals(style)) {
                name = operationName;
            } else if (OperationType.NOTIFICATION.equals(style)) {
                name = operationName;
            } else if (OperationType.REQUEST_RESPONSE.equals(style)) {
                name = operationName + "Response";
            } else if (OperationType.SOLICIT_RESPONSE.equals(style)) {
                name = operationName + "Response";
            }
        }
        Path path = this.nextPath(parentPath, WsdlLexicon.OUTPUT);
        this.output.setProperty(path, WsdlLexicon.NC_NAME, new Object[]{name});
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.BINDING_OPERATION_OUTPUT});
        Output opOutput = operation.getOutput();
        this.output.setProperty(path, WsdlLexicon.OUTPUT_REFERENCE, new Object[]{this.uuidForComponent(opOutput)});
        this.output.setProperty(path, WsdlLexicon.OUTPUT_NAME, new Object[]{this.nameForComponent.get(opOutput)});
        this.processDocumentation(out, path);
        this.processExtensibilityElements(out, path);
    }

    protected void process(BindingFault fault, Path parentPath) throws Exception {
        if (fault == null) {
            return;
        }
        Path path = this.nextPath(parentPath, WsdlLexicon.FAULT);
        this.output.setProperty(path, WsdlLexicon.NC_NAME, new Object[]{fault.getName()});
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.BINDING_OPERATION_FAULT});
        this.processDocumentation(fault, path);
        this.processExtensibilityElements(fault, path);
    }

    protected void processServices(Map<String, Service> services, Path parentPath) throws Exception {
        Path servicePath = null;
        for (Service service : services.values()) {
            if (servicePath == null) {
                servicePath = this.nextPath(parentPath, WsdlLexicon.SERVICES);
                this.output.setProperty(servicePath, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.SERVICES});
            }
            this.processService(service, servicePath);
        }
    }

    protected void processService(Service service, Path parentPath) throws Exception {
        QName qname = service.getQName();
        Path path = this.nextPath(parentPath, qname, WsdlLexicon.SERVICE);
        this.setReferenceable(path, SERVICES, qname);
        for (Port port : service.getPorts().values()) {
            this.process(port, path);
        }
        this.processDocumentation(service, path);
        this.processExtensibilityElements(service, path);
    }

    protected void process(Port port, Path parentPath) throws Exception {
        String name = port.getName();
        Path path = this.nextPath(parentPath, this.name(name));
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.PORT});
        QName bindingName = port.getBinding().getQName();
        this.setReference(path, WsdlLexicon.BINDING_REFERENCE, BINDINGS, bindingName);
        this.output.setProperty(path, WsdlLexicon.NC_NAME, new Object[]{name});
        this.processDocumentation(port, path);
        this.processExtensibilityElements(port, path);
    }

    protected void processDocumentation(WSDLElement wsdlElement, Path path) throws Exception {
        if (wsdlElement == null) {
            return;
        }
        Element docElement = wsdlElement.getDocumentationElement();
        if (docElement == null) {
            return;
        }
        String content = null;
        int numChildNodes = docElement.getChildNodes().getLength();
        content = numChildNodes == 0 ? docElement.getTextContent() : (numChildNodes == 1 ? docElement.getTextContent() : this.writeXml(docElement));
        if (content == null) {
            return;
        }
        if ((content = content.trim()).length() != 0) {
            this.output.setProperty(path, SrampLexicon.DESCRIPTION, new Object[]{this.cleanDocumentationContent(content)});
        }
    }

    protected String cleanDocumentationContent(String content) {
        Pattern REMOVE_WHITESPACE_AND_LINE_FEEDS_PATTERN = Pattern.compile("[\\n\\r\\s]+");
        Matcher matcher = REMOVE_WHITESPACE_AND_LINE_FEEDS_PATTERN.matcher(content);
        return matcher.replaceAll(" ");
    }

    protected void processExtensibilityElements(WSDLElement wsdlElement, Path path) throws Exception {
        if (wsdlElement == null) {
            return;
        }
        for (Map.Entry entry : wsdlElement.getExtensionAttributes().entrySet()) {
            Attr attribute = (Attr)entry.getValue();
            String namespaceUri = attribute.getNamespaceURI();
            if ("http://schemas.xmlsoap.org/wsdl/".equals(namespaceUri)) continue;
            String localName = attribute.getLocalName();
            String value = attribute.getNodeValue();
            if (value == null) continue;
            if (namespaceUri != null) {
                this.prefixForNamespace(namespaceUri, attribute.getPrefix());
                this.output.setProperty(path, this.name(namespaceUri, localName), new Object[]{value});
                continue;
            }
            this.output.setProperty(path, this.name(localName), new Object[]{value});
        }
        for (ExtensibilityElement element : wsdlElement.getExtensibilityElements()) {
            this.process(element, path);
        }
    }

    protected void process(ExtensibilityElement element, Path parentPath) throws Exception {
        if (element == null) {
            return;
        }
        if (element instanceof SOAP12Address) {
            this.process((SOAP12Address)element, parentPath);
        } else if (element instanceof SOAP12Binding) {
            this.process((SOAP12Binding)element, parentPath);
        } else if (element instanceof SOAP12Body) {
            this.process((SOAP12Body)element, parentPath);
        } else if (element instanceof SOAP12Fault) {
            this.process((SOAP12Fault)element, parentPath);
        } else if (element instanceof SOAP12Header) {
            this.process((SOAP12Header)element, parentPath);
        } else if (element instanceof SOAP12HeaderFault) {
            this.process((SOAP12HeaderFault)element, parentPath);
        } else if (element instanceof SOAP12Operation) {
            this.process((SOAP12Operation)element, parentPath);
        } else if (element instanceof SOAPAddress) {
            this.process((SOAPAddress)element, parentPath);
        } else if (element instanceof SOAPBinding) {
            this.process((SOAPBinding)element, parentPath);
        } else if (element instanceof SOAPBody) {
            this.process((SOAPBody)element, parentPath);
        } else if (element instanceof SOAPFault) {
            this.process((SOAPFault)element, parentPath);
        } else if (element instanceof SOAPHeader) {
            this.process((SOAPHeader)element, parentPath);
        } else if (element instanceof SOAPHeaderFault) {
            this.process((SOAPHeaderFault)element, parentPath);
        } else if (element instanceof SOAPOperation) {
            this.process((SOAPOperation)element, parentPath);
        } else if (element instanceof MIMEMultipartRelated) {
            this.process((MIMEMultipartRelated)element, parentPath);
        } else if (element instanceof MIMEContent) {
            this.process((MIMEContent)element, parentPath);
        } else if (element instanceof MIMEPart) {
            this.process((MIMEPart)element, parentPath);
        } else if (element instanceof MIMEMimeXml) {
            this.process((MIMEMimeXml)element, parentPath);
        } else if (element instanceof HTTPAddress) {
            this.process((HTTPAddress)element, parentPath);
        } else if (element instanceof HTTPBinding) {
            this.process((HTTPBinding)element, parentPath);
        } else if (element instanceof HTTPOperation) {
            this.process((HTTPOperation)element, parentPath);
        } else if (element instanceof HTTPUrlEncoded) {
            this.process((HTTPUrlEncoded)element, parentPath);
        } else if (element instanceof HTTPUrlReplacement) {
            this.process((HTTPUrlReplacement)element, parentPath);
        } else {
            this.processUnknownExtensionElement(element, parentPath);
        }
    }

    protected void process(HTTPAddress element, Path parentPath) throws Exception {
        Path path = this.nextPath(parentPath, WsdlLexicon.HTTP_ADDRESS);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.HTTP_ADDRESS});
        this.output.setProperty(path, WsdlLexicon.LOCATION, new Object[]{element.getLocationURI()});
    }

    protected void process(HTTPBinding element, Path parentPath) throws Exception {
        Path path = this.nextPath(parentPath, WsdlLexicon.HTTP_BINDING);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.HTTP_BINDING});
        this.output.setProperty(path, WsdlLexicon.VERB, new Object[]{element.getVerb()});
    }

    protected void process(HTTPOperation element, Path parentPath) throws Exception {
        Path path = this.nextPath(parentPath, WsdlLexicon.HTTP_OPERATION);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.HTTP_OPERATION});
        this.output.setProperty(path, WsdlLexicon.LOCATION, new Object[]{element.getLocationURI()});
    }

    protected void process(HTTPUrlEncoded element, Path parentPath) throws Exception {
        Path path = this.nextPath(parentPath, WsdlLexicon.HTTP_URL_ENCODED);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.HTTP_URL_ENCODED});
    }

    protected void process(HTTPUrlReplacement element, Path parentPath) throws Exception {
        Path path = this.nextPath(parentPath, WsdlLexicon.HTTP_URL_REPLACEMENT);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.HTTP_URL_REPLACEMENT});
    }

    protected void process(SOAP12Address element, Path parentPath) throws Exception {
        Path path = this.nextPath(parentPath, WsdlLexicon.SOAP_ADDRESS);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.SOAP_ADDRESS});
        this.output.setProperty(path, WsdlLexicon.SOAP_LOCATION, new Object[]{element.getLocationURI()});
    }

    protected void process(SOAP12Binding element, Path parentPath) throws Exception {
        Path path = this.nextPath(parentPath, WsdlLexicon.SOAP_BINDING);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.SOAP_BINDING});
        this.output.setProperty(path, WsdlLexicon.STYLE, new Object[]{element.getStyle()});
        this.output.setProperty(path, WsdlLexicon.TRANSPORT, new Object[]{element.getTransportURI()});
    }

    protected void process(SOAP12Operation element, Path parentPath) throws Exception {
        Path path = this.nextPath(parentPath, WsdlLexicon.SOAP_OPERATION);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.SOAP_OPERATION});
        this.output.setProperty(path, WsdlLexicon.STYLE, new Object[]{element.getStyle()});
        this.output.setProperty(path, WsdlLexicon.SOAP_ACTION, new Object[]{element.getSoapActionURI()});
    }

    protected void process(SOAP12Body element, Path parentPath) throws Exception {
        Path path = this.nextPath(parentPath, WsdlLexicon.SOAP_BODY);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.SOAP_BODY});
        this.output.setProperty(path, WsdlLexicon.ENCODING_STYLE, new Object[]{element.getEncodingStyle()});
        this.output.setProperty(path, WsdlLexicon.PARTS, new Object[]{element.getParts()});
        this.output.setProperty(path, WsdlLexicon.USE, new Object[]{element.getUse()});
    }

    protected void process(SOAP12Fault element, Path parentPath) throws Exception {
        Path path = this.nextPath(parentPath, WsdlLexicon.SOAP_FAULT);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.SOAP_FAULT});
        this.output.setProperty(path, WsdlLexicon.ENCODING_STYLE, new Object[]{element.getEncodingStyle()});
        this.output.setProperty(path, WsdlLexicon.USE, new Object[]{element.getUse()});
    }

    protected void process(SOAP12Header element, Path parentPath) throws Exception {
        Path path = this.nextPath(parentPath, WsdlLexicon.SOAP_HEADER);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.SOAP_HEADER});
        this.output.setProperty(path, WsdlLexicon.ENCODING_STYLE, new Object[]{element.getEncodingStyle()});
        this.output.setProperty(path, WsdlLexicon.MESSAGE, new Object[]{element.getMessage()});
        this.output.setProperty(path, WsdlLexicon.PART, new Object[]{element.getPart()});
        this.output.setProperty(path, WsdlLexicon.USE, new Object[]{element.getUse()});
        for (SOAP12HeaderFault fault : element.getSOAP12HeaderFaults()) {
            this.process(fault, path);
        }
    }

    protected void process(SOAP12HeaderFault element, Path parentPath) throws Exception {
        Path path = this.nextPath(parentPath, WsdlLexicon.SOAP_HEADER_FAULT);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.SOAP_HEADER_FAULT});
        this.output.setProperty(path, WsdlLexicon.ENCODING_STYLE, new Object[]{element.getEncodingStyle()});
        this.output.setProperty(path, WsdlLexicon.USE, new Object[]{element.getUse()});
    }

    protected void process(SOAPAddress element, Path parentPath) throws Exception {
        Path path = this.nextPath(parentPath, WsdlLexicon.SOAP_ADDRESS);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.SOAP_ADDRESS});
        this.output.setProperty(path, WsdlLexicon.SOAP_LOCATION, new Object[]{element.getLocationURI()});
    }

    protected void process(SOAPBinding element, Path parentPath) throws Exception {
        Path path = this.nextPath(parentPath, WsdlLexicon.SOAP_BINDING);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.SOAP_BINDING});
        this.output.setProperty(path, WsdlLexicon.STYLE, new Object[]{element.getStyle()});
        this.output.setProperty(path, WsdlLexicon.TRANSPORT, new Object[]{element.getTransportURI()});
    }

    protected void process(SOAPOperation element, Path parentPath) throws Exception {
        Path path = this.nextPath(parentPath, WsdlLexicon.SOAP_OPERATION);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.SOAP_OPERATION});
        this.output.setProperty(path, WsdlLexicon.STYLE, new Object[]{element.getStyle()});
        this.output.setProperty(path, WsdlLexicon.SOAP_ACTION, new Object[]{element.getSoapActionURI()});
    }

    protected void process(SOAPBody element, Path parentPath) throws Exception {
        Path path = this.nextPath(parentPath, WsdlLexicon.SOAP_BODY);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.SOAP_BODY});
        this.output.setProperty(path, WsdlLexicon.ENCODING_STYLE, new Object[]{element.getEncodingStyles()});
        this.output.setProperty(path, WsdlLexicon.PARTS, new Object[]{element.getParts()});
        this.output.setProperty(path, WsdlLexicon.USE, new Object[]{element.getUse()});
    }

    protected void process(SOAPFault element, Path parentPath) throws Exception {
        Path path = this.nextPath(parentPath, WsdlLexicon.SOAP_FAULT);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.SOAP_FAULT});
        this.output.setProperty(path, WsdlLexicon.ENCODING_STYLE, new Object[]{element.getEncodingStyles()});
        this.output.setProperty(path, WsdlLexicon.USE, new Object[]{element.getUse()});
    }

    protected void process(SOAPHeader element, Path parentPath) throws Exception {
        Path path = this.nextPath(parentPath, WsdlLexicon.SOAP_HEADER);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.SOAP_HEADER});
        this.output.setProperty(path, WsdlLexicon.ENCODING_STYLE, new Object[]{element.getEncodingStyles()});
        this.output.setProperty(path, WsdlLexicon.MESSAGE, new Object[]{element.getMessage()});
        this.output.setProperty(path, WsdlLexicon.PART, new Object[]{element.getPart()});
        this.output.setProperty(path, WsdlLexicon.USE, new Object[]{element.getUse()});
        for (SOAP12HeaderFault fault : element.getSOAPHeaderFaults()) {
            this.process(fault, path);
        }
    }

    protected void process(SOAPHeaderFault element, Path parentPath) throws Exception {
        Path path = this.nextPath(parentPath, WsdlLexicon.SOAP_HEADER_FAULT);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.SOAP_HEADER_FAULT});
        this.output.setProperty(path, WsdlLexicon.ENCODING_STYLE, new Object[]{element.getEncodingStyles()});
        this.output.setProperty(path, WsdlLexicon.USE, new Object[]{element.getUse()});
    }

    protected void process(MIMEMultipartRelated element, Path parentPath) throws Exception {
        Path path = this.nextPath(parentPath, WsdlLexicon.MIME_MULTIPART_RELATED);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.MIME_MULTIPART_RELATED});
        for (MIMEPart part : element.getMIMEParts()) {
            this.process(part, path);
        }
    }

    protected void process(MIMEPart element, Path parentPath) throws Exception {
        Path path = this.nextPath(parentPath, WsdlLexicon.MIME_PART);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.MIME_PART});
        for (ExtensibilityElement child : element.getExtensibilityElements()) {
            this.process(child, path);
        }
    }

    protected void process(MIMEContent element, Path parentPath) throws Exception {
        Path path = this.nextPath(parentPath, WsdlLexicon.MIME_CONTENT);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.MIME_CONTENT});
        this.output.setProperty(path, WsdlLexicon.MIME_PART, new Object[]{element.getPart()});
        this.output.setProperty(path, WsdlLexicon.MIME_TYPE, new Object[]{element.getType()});
    }

    protected void process(MIMEMimeXml element, Path parentPath) throws Exception {
        Path path = this.nextPath(parentPath, WsdlLexicon.MIME_XML);
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{WsdlLexicon.MIME_XML});
        this.output.setProperty(path, WsdlLexicon.MIME_PART, new Object[]{element.getPart()});
    }

    protected void processUnknownExtensionElement(ExtensibilityElement element, Path parentPath) throws Exception {
    }

    protected boolean is(QName qname, Name name) {
        return qname != null && name.getLocalName().equals(qname.getLocalPart()) && name.getNamespaceUri().equals(qname.getNamespaceURI());
    }

    protected UUID setReferenceable(Path path, XsdResolvers.SymbolSpace space, QName qname) {
        return this.setReferenceable(path, space, qname.getNamespaceURI(), qname.getLocalPart());
    }

    protected UUID setReferenceable(Path path, XsdResolvers.SymbolSpace space, String namespace, String name) {
        UUID uuid = this.setUuid(path);
        this.resolvers.get(space).register(namespace, name, path, uuid);
        return uuid;
    }

    protected UUID setReference(Path path, Name propertyName, XsdResolvers.SymbolSpace space, QName name) {
        return this.setReference(path, propertyName, space, name.getNamespaceURI(), name.getLocalPart());
    }

    protected String writeXml(Node xmlNode) throws TransformerFactoryConfigurationError, TransformerException {
        DOMSource source = new DOMSource(xmlNode);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.transform(source, result);
        return writer.toString();
    }

    protected Path nextPath(Path parentPath, QName qname, Name primaryType) {
        String localName = qname.getLocalPart();
        String namespace = qname.getNamespaceURI();
        Path path = this.nextPath(parentPath, this.name(localName));
        this.output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{primaryType});
        this.output.setProperty(path, WsdlLexicon.NC_NAME, new Object[]{localName});
        this.output.setProperty(path, WsdlLexicon.NAMESPACE, new Object[]{namespace});
        return path;
    }

    protected UUID uuidForComponent(WSDLElement component) {
        UUID uuid = this.uuidForComponent.get(component);
        if (uuid == null) {
            uuid = this.context.getValueFactories().getUuidFactory().create();
            this.uuidForComponent.put(component, uuid);
        }
        return uuid;
    }

    protected class CustomWSDLLocator
    implements WSDLLocator {
        protected final InputSource baseInputSource;
        protected final InputSource emptyInputSource;
        protected final String baseUri;

        protected CustomWSDLLocator(InputSource baseInputSource, String baseUri) {
            this.baseInputSource = baseInputSource;
            this.emptyInputSource = new InputSource(new StringReader(""));
            this.baseUri = baseUri;
        }

        @Override
        public String getLatestImportURI() {
            return this.baseUri;
        }

        @Override
        public InputSource getImportInputSource(String parentLocation, String importLocation) {
            return this.emptyInputSource;
        }

        @Override
        public String getBaseURI() {
            return this.baseUri;
        }

        @Override
        public InputSource getBaseInputSource() {
            return this.baseInputSource;
        }

        @Override
        public void close() {
        }
    }

    protected class PortTypeResolvers {
        private final Map<QName, NamespaceEntityResolver> resolversByKind = new HashMap<QName, NamespaceEntityResolver>();

        protected PortTypeResolvers() {
        }

        public NamespaceEntityResolver get(QName portTypeName) {
            NamespaceEntityResolver resolver = this.resolversByKind.get(portTypeName);
            if (resolver == null) {
                resolver = new NamespaceEntityResolver();
                this.resolversByKind.put(portTypeName, resolver);
            }
            return resolver;
        }
    }
}

