/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.common.text.Jsr283Encoder;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.JcrNtLexicon;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.sequencer.MockSequencerContext;
import org.modeshape.graph.sequencer.MockSequencerOutput;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.xml.ModeShapeXmlLexicon;
import org.modeshape.sequencer.xml.XmlSequencer;
import org.modeshape.sequencer.xml.XmlSequencerHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlSequencerHandlerTest {
    private XmlSequencerHandler handler;
    private StreamSequencerContext context;
    private MockSequencerOutput output;
    private TextDecoder decoder;
    private Name primaryType;
    private Name nameAttribute;
    private XmlSequencer.AttributeScoping scoping;
    private LinkedList<Path> pathsInCreationOrder;
    private String sequencedNodeName;

    @Before
    public void beforeEach() {
        this.sequencedNodeName = "input";
        this.context = new MockSequencerContext("/some/" + this.sequencedNodeName);
        this.output = new MockSequencerOutput(this.context, true);
        this.context.getNamespaceRegistry().register("jcr", "http://www.jcp.org/jcr/1.0");
        this.context.getNamespaceRegistry().register("nt", "http://www.jcp.org/jcr/nt/1.0");
        this.context.getNamespaceRegistry().register("modexml", "http://www.modeshape.org/xml/1.0");
        this.context.getNamespaceRegistry().register("modedtd", "http://www.modeshape.org/dtd/1.0");
        this.decoder = null;
        this.nameAttribute = JcrLexicon.NAME;
        this.primaryType = JcrNtLexicon.UNSTRUCTURED;
        this.scoping = XmlSequencer.AttributeScoping.USE_DEFAULT_NAMESPACE;
        this.handler = new XmlSequencerHandler((SequencerOutput)this.output, this.context, this.nameAttribute, this.primaryType, this.decoder, this.scoping);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotConstructInstanceWhenGivenNullContext() {
        this.context = null;
        new XmlSequencerHandler((SequencerOutput)this.output, this.context, this.nameAttribute, this.primaryType, this.decoder, this.scoping);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotConstructInstanceWhenGivenNullOutput() {
        this.output = null;
        new XmlSequencerHandler((SequencerOutput)this.output, this.context, this.nameAttribute, this.primaryType, this.decoder, this.scoping);
    }

    @Test
    public void shouldUseDefaultDecoderIfNoneIsProvidedInConstructor() {
        this.decoder = null;
        this.handler = new XmlSequencerHandler((SequencerOutput)this.output, this.context, this.nameAttribute, this.primaryType, this.decoder, this.scoping);
    }

    @Test
    public void shouldUseDecoderProvidedInConstructor() {
        this.decoder = new Jsr283Encoder();
        new XmlSequencerHandler((SequencerOutput)this.output, this.context, this.nameAttribute, this.primaryType, this.decoder, this.scoping);
    }

    @Test
    public void shouldParseXmlDocumentWithoutNamespaces() throws IOException, SAXException {
        this.parse("docWithoutNamespaces.xml");
        this.assertDocumentNode();
        this.assertElement("Cars", new String[0]);
        this.assertElement("Cars/Hybrid", new String[0]);
        this.assertElement("Cars/Hybrid/car[1]", "name=Toyota Prius", "maker=Toyota", "model=Prius");
        this.assertElement("Cars/Hybrid/car[2]", "name=Toyota Highlander", "maker=Toyota", "model=Highlander");
        this.assertElement("Cars/Hybrid/car[3]", "name=Nissan Altima", "maker=Nissan", "model=Altima");
        this.assertElement("Cars/Sports", new String[0]);
        this.assertElement("Cars/Sports/car[1]", "name=Aston Martin DB9", "maker=Aston Martin", "model=DB9");
        this.assertElement("Cars/Sports/car[2]", "name=Infiniti G37", "maker=Infiniti", "model=G37");
        this.assertNoMoreNodes();
    }

    @Test
    public void shouldParseXmlDocumentWithNamespaces() throws IOException, SAXException {
        this.context.getNamespaceRegistry().register("c", "http://default.namespace.com");
        this.parse("docWithNamespaces.xml");
        this.assertDocumentNode();
        this.assertElement("c:Cars", new String[0]);
        this.assertElement("c:Cars/c:Hybrid", new String[0]);
        this.assertElement("c:Cars/c:Hybrid/c:Toyota Prius", "c:maker=Toyota", "c:model=Prius");
        this.assertElement("c:Cars/c:Hybrid/c:Toyota Highlander", "c:maker=Toyota", "c:model=Highlander");
        this.assertElement("c:Cars/c:Hybrid/c:Nissan Altima", "c:maker=Nissan", "c:model=Altima");
        this.assertElement("c:Cars/c:Sports", new String[0]);
        this.assertElement("c:Cars/c:Sports/c:Aston Martin DB9", "c:maker=Aston Martin", "c:model=DB9");
        this.assertElement("c:Cars/c:Sports/c:Infiniti G37", "c:maker=Infiniti", "c:model=G37");
        this.assertNoMoreNodes();
    }

    @Test
    public void shouldParseXmlDocumentWithNestedNamespaceDeclarations() throws IOException, SAXException {
        this.context.getNamespaceRegistry().register("c", "http://default.namespace.com");
        this.context.getNamespaceRegistry().register("i", "http://attributes.com");
        this.parse("docWithNestedNamespaces.xml");
        this.assertDocumentNode();
        this.assertElement("Cars", new String[0]);
        this.assertElement("Cars/c:Hybrid", new String[0]);
        this.assertElement("Cars/c:Hybrid/c:Toyota Prius", "c:maker=Toyota", "c:model=Prius");
        this.assertElement("Cars/c:Hybrid/c:Toyota Highlander", "c:maker=Toyota", "c:model=Highlander");
        this.assertElement("Cars/c:Hybrid/c:Nissan Altima", "c:maker=Nissan", "c:model=Altima");
        this.assertElement("Cars/Sports", new String[0]);
        this.assertElement("Cars/Sports/Aston Martin DB9", "i:maker=Aston Martin", "model=DB9");
        this.assertElement("Cars/Sports/Infiniti G37", "i:maker=Infiniti", "model=G37");
        this.assertNoMoreNodes();
    }

    @Test
    public void shouldParseXmlDocumentWithNamespacePrefixesThatDoNotMatchRegistry() throws IOException, SAXException {
        this.context.getNamespaceRegistry().register("c", "http://default.namespace.com");
        this.parse("docWithNamespaces.xml");
        this.assertDocumentNode();
        this.assertElement("c:Cars", new String[0]);
        this.assertElement("c:Cars/c:Hybrid", new String[0]);
        this.assertElement("c:Cars/c:Hybrid/c:Toyota Prius", "c:maker=Toyota", "c:model=Prius");
        this.assertElement("c:Cars/c:Hybrid/c:Toyota Highlander", "c:maker=Toyota", "c:model=Highlander");
        this.assertElement("c:Cars/c:Hybrid/c:Nissan Altima", "c:maker=Nissan", "c:model=Altima");
        this.assertElement("c:Cars/c:Sports", new String[0]);
        this.assertElement("c:Cars/c:Sports/c:Aston Martin DB9", "c:maker=Aston Martin", "c:model=DB9");
        this.assertElement("c:Cars/c:Sports/c:Infiniti G37", "c:maker=Infiniti", "c:model=G37");
        this.assertNoMoreNodes();
    }

    @Test
    public void shouldParseXmlDocumentWithNamespacesThatAreNotYetInRegistry() throws IOException, SAXException {
        NamespaceRegistry reg = this.context.getNamespaceRegistry();
        reg.unregister("http://www.jcp.org/jcr/1.0");
        reg.unregister("http://www.jcp.org/jcr/nt/1.0");
        Assert.assertThat((Object)reg.getPrefixForNamespaceUri("http://www.jcp.org/jcr/1.0", false), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)reg.getPrefixForNamespaceUri("http://www.jcp.org/jcr/nt/1.0", false), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)reg.getPrefixForNamespaceUri("http://default.namespace.com", false), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        this.parse("docWithNestedNamespaces.xml");
        String c = reg.getPrefixForNamespaceUri("http://default.namespace.com", false);
        String i = reg.getPrefixForNamespaceUri("http://attributes.com", false);
        String d = reg.getPrefixForNamespaceUri(reg.getDefaultNamespaceUri(), false);
        Assert.assertThat((String)"Namespace not properly registered in primary registry", (Object)c, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((String)"Namespace not properly registered in primary registry", (Object)d, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((String)"Namespace not properly registered in primary registry", (Object)i, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        if (c.length() != 0) {
            c = c + ":";
        }
        if (d.length() != 0) {
            d = d + ":";
        }
        if (i.length() != 0) {
            i = i + ":";
        }
        this.assertDocumentNode();
        this.assertElement(d + "Cars", new String[0]);
        this.assertElement(d + "Cars/" + c + "Hybrid", new String[0]);
        this.assertElement(d + "Cars/" + c + "Hybrid/" + c + "Toyota Prius", c + "maker=Toyota", c + "model=Prius");
        this.assertElement(d + "Cars/" + c + "Hybrid/" + c + "Toyota Highlander", c + "maker=Toyota", c + "model=Highlander");
        this.assertElement(d + "Cars/" + c + "Hybrid/" + c + "Nissan Altima", c + "maker=Nissan", c + "model=Altima");
        this.assertElement(d + "Cars/" + d + "Sports", new String[0]);
        this.assertElement(d + "Cars/" + d + "Sports/Aston Martin DB9", i + "maker=Aston Martin", "model=DB9");
        this.assertElement(d + "Cars/" + d + "Sports/Infiniti G37", i + "maker=Infiniti", "model=G37");
        this.assertNoMoreNodes();
    }

    @Test
    public void shouldParseXmlDocumentThatUsesNameAttribute() throws IOException, SAXException {
        this.context.getNamespaceRegistry().register("c", "http://default.namespace.com");
        this.parse("docWithNamespaces.xml");
        this.assertDocumentNode();
        this.assertElement("c:Cars", new String[0]);
        this.assertElement("c:Cars/c:Hybrid", new String[0]);
        this.assertElement("c:Cars/c:Hybrid/c:Toyota Prius", "c:maker=Toyota", "c:model=Prius");
        this.assertElement("c:Cars/c:Hybrid/c:Toyota Highlander", "c:maker=Toyota", "c:model=Highlander");
        this.assertElement("c:Cars/c:Hybrid/c:Nissan Altima", "c:maker=Nissan", "c:model=Altima");
        this.assertElement("c:Cars/c:Sports", new String[0]);
        this.assertElement("c:Cars/c:Sports/c:Aston Martin DB9", "c:maker=Aston Martin", "c:model=DB9");
        this.assertElement("c:Cars/c:Sports/c:Infiniti G37", "c:maker=Infiniti", "c:model=G37");
        this.assertNoMoreNodes();
    }

    @Test
    public void shouldParseXmlDocumentWithoutDefaultNamespaceThatUsesNameAttribute() throws IOException, SAXException {
        this.parse("docWithNamespacesWithoutDefault.xml");
        this.assertDocumentNode();
        this.assertElement("Cars", new String[0]);
        this.assertElement("Cars/Hybrid", new String[0]);
        this.assertElement("Cars/Hybrid/Toyota Prius", "maker=Toyota", "model=Prius");
        this.assertElement("Cars/Hybrid/Toyota Highlander", "maker=Toyota", "model=Highlander");
        this.assertElement("Cars/Hybrid/Nissan Altima", "maker=Nissan", "model=Altima");
        this.assertElement("Cars/Sports", new String[0]);
        this.assertElement("Cars/Sports/Aston Martin DB9", "maker=Aston Martin", "model=DB9");
        this.assertElement("Cars/Sports/Infiniti G37", "maker=Infiniti", "model=G37");
        this.assertNoMoreNodes();
    }

    @Test
    public void shouldParseXmlDocumentWithoutDefaultNamespaceThatUsesNoNameAttribute() throws IOException, SAXException {
        this.nameAttribute = null;
        this.handler = new XmlSequencerHandler((SequencerOutput)this.output, this.context, this.nameAttribute, this.primaryType, this.decoder, this.scoping);
        this.parse("docWithNamespacesWithoutDefault.xml");
        this.assertDocumentNode();
        this.assertElement("Cars", new String[0]);
        this.assertElement("Cars/Hybrid", new String[0]);
        this.assertElement("Cars/Hybrid/car[1]", "maker=Toyota", "model=Prius");
        this.assertElement("Cars/Hybrid/car[2]", "maker=Toyota", "model=Highlander");
        this.assertElement("Cars/Hybrid/car[3]", "maker=Nissan", "model=Altima");
        this.assertElement("Cars/Sports", new String[0]);
        this.assertElement("Cars/Sports/car[1]", "maker=Aston Martin", "model=DB9");
        this.assertElement("Cars/Sports/car[2]", "maker=Infiniti", "model=G37");
        this.assertNoMoreNodes();
    }

    @Test
    public void shouldParseXmlDocumentThatContainsNoContent() throws IOException, SAXException {
        this.parse("docWithOnlyRootElement.xml");
        this.assertElement("", "jcr:primaryType={http://www.modeshape.org/xml/1.0}document");
        this.assertElement("Cars", new String[0]);
        this.assertNoMoreNodes();
    }

    @Test
    public void shouldParseXmlDocumentWithXmlComments() throws IOException, SAXException {
        this.context.getNamespaceRegistry().register("c", "http://default.namespace.com");
        this.parse("docWithComments.xml");
        this.assertDocumentNode();
        this.assertElement("c:Cars", new String[0]);
        this.assertComment("c:Cars/modexml:comment[1]", "This is a comment");
        this.assertElement("c:Cars/c:Hybrid", new String[0]);
        this.assertElement("c:Cars/c:Hybrid/c:Toyota Prius", "c:maker=Toyota", "c:model=Prius");
        this.assertElement("c:Cars/c:Hybrid/c:Toyota Highlander", "c:maker=Toyota", "c:model=Highlander");
        this.assertElement("c:Cars/c:Hybrid/c:Nissan Altima", "c:maker=Nissan", "c:model=Altima");
        this.assertComment("c:Cars/modexml:comment[2]", "This is another comment");
        this.assertElement("c:Cars/c:Sports", new String[0]);
        this.assertElement("c:Cars/c:Sports/c:Aston Martin DB9", "c:maker=Aston Martin", "c:model=DB9");
        this.assertElement("c:Cars/c:Sports/c:Infiniti G37", "c:maker=Infiniti", "c:model=G37");
        this.assertNoMoreNodes();
    }

    @Test
    public void shouldParseXmlDocumentWithXmlElementsContainingOnlyChildElements() throws IOException, SAXException {
        this.context.getNamespaceRegistry().register("xhtml", "http://www.w3.org/1999/xhtml");
        this.context.getNamespaceRegistry().register("mathml", "http://www.w3.org/1998/Math/MathML");
        this.context.getNamespaceRegistry().register("svg", "http://www.w3.org/2000/svg");
        this.context.getNamespaceRegistry().register("dnaxml", "http://www.modeshape.org/xml/1.0");
        this.context.getNamespaceRegistry().register("dnadtd", "http://www.modeshape.org/dtd/1.0");
        this.parse("docWithElementsContainingElements.xml");
        this.assertDocumentNode();
        this.assertElement("xhtml:html", new String[0]);
        this.assertElement("xhtml:html/xhtml:head", new String[0]);
        this.assertElement("xhtml:html/xhtml:head/xhtml:title", new String[0]);
        this.assertContent("xhtml:html/xhtml:head/xhtml:title/dnaxml:elementContent", "Three Namespaces", new String[0]);
        this.assertElement("xhtml:html/xhtml:body", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/xhtml:h1", "{}align=center");
        this.assertContent("xhtml:html/xhtml:body/xhtml:h1/dnaxml:elementContent", "An Ellipse and a Rectangle", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/svg:svg", "{}width=12cm", "{}height=10cm");
        this.assertElement("xhtml:html/xhtml:body/svg:svg/svg:ellipse", "{}rx=110", "{}ry=130");
        this.assertElement("xhtml:html/xhtml:body/svg:svg/svg:rect", "{}x=4cm", "{}y=1cm", "{}width=3cm", "{}height=6cm");
        this.assertElement("xhtml:html/xhtml:body/xhtml:p", new String[0]);
        this.assertContent("xhtml:html/xhtml:body/xhtml:p/dnaxml:elementContent", "The equation for ellipses", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/mathml:math", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/mathml:math/mathml:apply", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:eq", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:cn", new String[0]);
        this.assertContent("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:cn/dnaxml:elementContent", "1", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:plus", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply/mathml:divide", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply/mathml:apply", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply/mathml:apply/mathml:power", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply/mathml:apply/mathml:ci", new String[0]);
        this.assertContent("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply/mathml:apply/mathml:ci/dnaxml:elementContent", "x", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply/mathml:apply/mathml:cn", new String[0]);
        this.assertContent("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply/mathml:apply/mathml:cn/dnaxml:elementContent", "2", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply/mathml:apply[2]", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply/mathml:apply[2]/mathml:power", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply/mathml:apply[2]/mathml:ci", new String[0]);
        this.assertContent("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply/mathml:apply[2]/mathml:ci/dnaxml:elementContent", "a", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply/mathml:apply[2]/mathml:cn", new String[0]);
        this.assertContent("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply/mathml:apply[2]/mathml:cn/dnaxml:elementContent", "2", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply[2]", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply[2]/mathml:divide", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply[2]/mathml:apply", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply[2]/mathml:apply/mathml:power", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply[2]/mathml:apply/mathml:ci", new String[0]);
        this.assertContent("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply[2]/mathml:apply/mathml:ci/dnaxml:elementContent", "y", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply[2]/mathml:apply/mathml:cn", new String[0]);
        this.assertContent("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply[2]/mathml:apply/mathml:cn/dnaxml:elementContent", "2", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply[2]/mathml:apply[2]", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply[2]/mathml:apply[2]/mathml:power", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply[2]/mathml:apply[2]/mathml:ci", new String[0]);
        this.assertContent("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply[2]/mathml:apply[2]/mathml:ci/dnaxml:elementContent", "b", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply[2]/mathml:apply[2]/mathml:cn", new String[0]);
        this.assertContent("xhtml:html/xhtml:body/mathml:math/mathml:apply/mathml:apply/mathml:apply[2]/mathml:apply[2]/mathml:cn/dnaxml:elementContent", "2", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/xhtml:hr", new String[0]);
        this.assertElement("xhtml:html/xhtml:body/xhtml:p[2]", new String[0]);
        this.assertContent("xhtml:html/xhtml:body/xhtml:p[2]/dnaxml:elementContent", "Last Modified January 10, 2002", new String[0]);
        this.assertNoMoreNodes();
    }

    @Test
    public void shouldParseXmlDocumentWithDtdEntities() throws IOException, SAXException {
        String longContent = "This is some long content that spans multiple lines and should span multiple calls to 'character(...)'. Repeating to make really long. This is some long content that spans multiple lines and should span multiple calls to 'character(...)'. Repeating to make really long. This is some long content that spans multiple lines and should span multiple calls to 'character(...)'. Repeating to make really long. This is some long content that spans multiple lines and should span multiple calls to 'character(...)'. Repeating to make really long.";
        this.parse("docWithDtdEntities.xml");
        this.assertDocumentNode("book", "-//OASIS//DTD DocBook XML V4.4//EN", "http://www.oasis-open.org/docbook/xml/4.4/docbookx.dtd");
        this.assertComment("modexml:comment", "Document comment");
        this.assertEntity(1, "%RH-ENTITIES", null, "Common_Config/rh-entities.ent");
        this.assertEntity(2, "versionNumber", "0.1");
        this.assertEntity(3, "copyrightYear", "2008");
        this.assertEntity(4, "copyrightHolder", "Red Hat Middleware, LLC.");
        this.assertElement("book", new String[0]);
        this.assertElement("book/bookinfo", new String[0]);
        this.assertElement("book/bookinfo/title", new String[0]);
        this.assertContent("book/bookinfo/title/modexml:elementContent", "ModeShape", new String[0]);
        this.assertElement("book/bookinfo/releaseinfo", new String[0]);
        this.assertContent("book/bookinfo/releaseinfo/modexml:elementContent", "&versionNumber;", new String[0]);
        this.assertElement("book/bookinfo/productnumber", new String[0]);
        this.assertContent("book/bookinfo/productnumber/modexml:elementContent", "some text with &versionNumber;inside", new String[0]);
        this.assertElement("book/bookinfo/abstract", new String[0]);
        this.assertContent("book/bookinfo/abstract/modexml:elementContent", longContent, new String[0]);
        this.assertElement("book/programlisting1", new String[0]);
        this.assertContent("book/programlisting1/modexml:elementContent", "&lt;dependency&gt; &lt;/dependency&gt;", new String[0]);
        this.assertElement("book/programlisting2", new String[0]);
        this.assertCData("book/programlisting2/modexml:cData", "modexml:cDataContent=\n&lt;dependency&gt;\n&lt;/dependency&gt;\n");
        this.assertElement("book/programlisting3", new String[0]);
        this.assertContent("book/programlisting3/modexml:elementContent[1]", "mixture of text and", new String[0]);
        this.assertCData("book/programlisting3/modexml:cData", "modexml:cDataContent=\n&lt;dependency&gt;\n&lt;/dependency&gt;\n");
        this.assertContent("book/programlisting3/modexml:elementContent[2]", "and some text", new String[0]);
        this.assertComment("book/programlisting3/modexml:comment", "comment in content");
        this.assertContent("book/programlisting3/modexml:elementContent[3]", "after.", new String[0]);
        this.assertNoMoreNodes();
    }

    @Test
    public void shouldParseXmlDocumentWithProcessingInstructions() throws IOException, SAXException {
        this.parse("docWithProcessingInstructions.xml");
        this.assertDocumentNode();
        this.assertPI(1, "target", "content");
        this.assertPI(2, "target2", "other stuff in the processing instruction");
        this.assertElement("Cars", new String[0]);
        this.assertComment("Cars/modexml:comment", "This is a comment");
        this.assertElement("Cars/Hybrid", new String[0]);
        this.assertElement("Cars/Hybrid/Toyota Prius", new String[0]);
        this.assertElement("Cars/Sports", new String[0]);
        this.assertNoMoreNodes();
    }

    @Test
    public void shouldParseXmlDocumentWithCDATA() throws IOException, SAXException {
        String cdata = "\n\n              import mx.events.ValidationResultEvent;\t\t\t\n              private var vResult:ValidationResultEvent;\n\t\t\t\n              // Event handler to validate and format input.\n              private function Format():void {\n              \n                    vResult = numVal.validate();\n\n                    if (vResult.type==ValidationResultEvent.VALID) {\n                        var temp:Number=Number(priceUS.text); \n                        formattedUSPrice.text= usdFormatter.format(temp);\n                    }\n                    \n                    else {\n                       formattedUSPrice.text=\"\";\n                    }\n              }\n        ";
        this.parse("docWithCDATA.xml");
        this.assertDocumentNode();
        this.assertComment("modexml:comment", "Simple example to demonstrate the CurrencyFormatter.");
        this.assertElement("mx:Application", new String[0]);
        this.assertElement("mx:Application/mx:Script", new String[0]);
        this.assertCdata("mx:Application/mx:Script/modexml:cData", cdata);
        this.assertElement("mx:Application/programlisting3", new String[0]);
        this.assertContent("mx:Application/programlisting3/modexml:elementContent[1]", "mixture of text and", new String[0]);
        this.assertCdata("mx:Application/programlisting3/modexml:cData", "\n<dependency>entities like &gt; are not replaced in a CDATA\n</dependency>\n");
        this.assertContent("mx:Application/programlisting3/modexml:elementContent[2]", "and some text", new String[0]);
        this.assertComment("mx:Application/programlisting3/modexml:comment", "comment in content");
        this.assertContent("mx:Application/programlisting3/modexml:elementContent[3]", "after.", new String[0]);
        this.assertElement("mx:Application/mx:NumberValidator", "id=numVal", "source={priceUS}", "property=text", "allowNegative=true", "domain=real");
        this.assertNoMoreNodes();
    }

    @Test
    public void shouldParseXmlDocumentWithDtd() throws IOException, SAXException {
        this.parse("master.xml");
        this.assertDocumentNode("book", "-//OASIS//DTD DocBook XML V4.4//EN", "http://www.oasis-open.org/docbook/xml/4.4/docbookx.dtd");
    }

    protected void assertNoMoreNodes() {
        if (!this.pathsInCreationOrder.isEmpty()) {
            Assert.fail((String)("Extra nodes were not expected:" + this.pathsInCreationOrder));
        }
    }

    protected void assertElement(String path, String ... properties) {
        this.assertNodeWithType(path, "{http://www.modeshape.org/xml/1.0}element", properties);
    }

    protected void assertCData(String path, String ... properties) {
        this.assertNodeWithType(path, "{http://www.modeshape.org/xml/1.0}cData", properties);
    }

    protected void assertContent(String path, String content, String ... properties) {
        String[] props = this.add("{http://www.modeshape.org/xml/1.0}elementContent=" + content, properties);
        this.assertNodeWithType(path, "{http://www.modeshape.org/xml/1.0}elementContent", props);
    }

    protected void assertNodeWithType(String path, String type, String ... properties) {
        String[] props = this.add("jcr:primaryType=" + type, properties);
        this.assertNode(path, props);
    }

    protected String[] add(String str, String[] array) {
        String[] props = new String[array.length + 1];
        props[0] = str;
        System.arraycopy(array, 0, props, 1, array.length);
        return props;
    }

    protected void assertNode(String path, String ... properties) {
        String string = path = path.length() != 0 ? this.sequencedNodeName + "/" + path : this.sequencedNodeName;
        if (path.length() != 0 && !path.endsWith("]")) {
            path = path + "[1]";
        }
        PathFactory factory = this.context.getValueFactories().getPathFactory();
        Path expectedPath = null;
        expectedPath = path.length() == 0 ? factory.createRelativePath() : (Path)factory.create(path);
        Path next = this.pathsInCreationOrder.removeFirst();
        Assert.assertThat((Object)next, (Matcher)Is.is((Object)expectedPath));
        HashMap<Name, Property> expectedProperties = new HashMap<Name, Property>();
        for (String propertyString : properties) {
            String[] strings = propertyString.split("=");
            if (strings.length < 2) continue;
            Name name = (Name)this.context.getValueFactories().getNameFactory().create(strings[0]);
            Object[] values = new Object[strings.length - 1];
            for (int i = 1; i != strings.length; ++i) {
                values[i - 1] = strings[i];
            }
            Property property = this.context.getPropertyFactory().create(name, values);
            expectedProperties.put(name, property);
        }
        if (!expectedProperties.containsKey(JcrLexicon.PRIMARY_TYPE)) {
            Property property = this.context.getPropertyFactory().create(JcrLexicon.PRIMARY_TYPE, new Object[]{this.primaryType});
            expectedProperties.put(property.getName(), property);
        }
        Map actualProperties = this.output.getProperties(expectedPath);
        Assert.assertThat((String)"node not found", (Object)actualProperties, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        for (Property actual : actualProperties.values()) {
            Property expected = (Property)expectedProperties.remove(actual.getName());
            Assert.assertThat((String)("unexpected actual property: " + actual), (Object)expected, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            Assert.assertThat((Object)actual, (Matcher)Is.is((Object)expected));
        }
        if (!expectedProperties.isEmpty()) {
            StringBuilder msg = new StringBuilder("missing actual properties: ");
            boolean isFirst = true;
            for (Property expected : expectedProperties.values()) {
                if (!isFirst) {
                    msg.append(", ");
                } else {
                    isFirst = false;
                }
                msg.append(expected.getName());
            }
            Assert.assertThat((String)msg.toString(), (Object)expectedProperties.isEmpty(), (Matcher)Is.is((Object)true));
        }
    }

    protected void assertComment(String path, String comment) {
        this.assertNode(path, "jcr:primaryType={http://www.modeshape.org/xml/1.0}comment", "modexml:commentContent=" + comment.trim());
    }

    protected void assertCdata(String path, String content) {
        String string = path = path.length() != 0 ? this.sequencedNodeName + "/" + path : this.sequencedNodeName;
        if (path.length() != 0 && !path.endsWith("]")) {
            path = path + "[1]";
        }
        PathFactory factory = this.context.getValueFactories().getPathFactory();
        Path expectedPath = (Path)factory.create("/" + path);
        Path next = this.pathsInCreationOrder.removeFirst();
        Assert.assertThat((Object)next, (Matcher)Is.is((Object)expectedPath));
        Property actualPrimaryType = this.output.getProperty(expectedPath, JcrLexicon.PRIMARY_TYPE);
        Assert.assertThat(actualPrimaryType.getValues().next(), (Matcher)Is.is((Object)ModeShapeXmlLexicon.CDATA));
        Property actual = this.output.getProperty(expectedPath, ModeShapeXmlLexicon.CDATA_CONTENT);
        Assert.assertThat((String)"expected one CDATA property", (Object)actual, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Property expected = this.context.getPropertyFactory().create(ModeShapeXmlLexicon.CDATA_CONTENT, new Object[]{content});
        Assert.assertThat((String)"CDATA content differed", (Object)actual, (Matcher)Is.is((Object)expected));
    }

    protected void assertDocumentNode() {
        this.assertNode("", "jcr:primaryType={http://www.modeshape.org/xml/1.0}document");
    }

    protected void assertDocumentNode(String name, String publicId, String systemId) {
        this.assertNode("", "jcr:primaryType={http://www.modeshape.org/xml/1.0}document", "modedtd:name=" + name, "modedtd:publicId=" + publicId, "modedtd:systemId=" + systemId);
    }

    protected void assertEntity(int index, String entityName, String value) {
        String path = "modedtd:entity[" + index + "]";
        this.assertNode(path, "jcr:primaryType={http://www.modeshape.org/dtd/1.0}entity", "modedtd:name=" + entityName, "modedtd:value=" + value);
    }

    protected void assertEntity(int index, String entityName, String publicId, String systemId) {
        String path = "modedtd:entity[" + index + "]";
        if (publicId != null) {
            this.assertNode(path, "jcr:primaryType={http://www.modeshape.org/dtd/1.0}entity", "modedtd:name=" + entityName, "modedtd:publicId=" + publicId, "modedtd:systemId=" + systemId);
        } else {
            this.assertNode(path, "jcr:primaryType={http://www.modeshape.org/dtd/1.0}entity", "modedtd:name=" + entityName, "modedtd:systemId=" + systemId);
        }
    }

    protected void assertPI(int index, String target, String data) {
        this.assertNode("modexml:processingInstruction[" + index + "]", "jcr:primaryType={http://www.modeshape.org/xml/1.0}processingInstruction", "modexml:target=" + target, "modexml:processingInstructionContent=" + data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parse(String relativePathToXmlFile) throws IOException, SAXException {
        Stopwatch sw = new Stopwatch();
        sw.start();
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(relativePathToXmlFile);
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler((ContentHandler)this.handler);
            reader.setErrorHandler((ErrorHandler)this.handler);
            reader.setProperty("http://xml.org/sax/properties/declaration-handler", this.handler);
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", this.handler);
            XmlSequencer.setFeature((XMLReader)reader, (String)"http://xml.org/sax/features/use-entity-resolver2", (boolean)true);
            XmlSequencer.setFeature((XMLReader)reader, (String)"http://apache.org/xml/features/nonvalidating/load-external-dtd", (boolean)false);
            XmlSequencer.setFeature((XMLReader)reader, (String)"http://xml.org/sax/features/resolve-dtd-uris", (boolean)false);
            reader.parse(new InputSource(stream));
        }
        finally {
            if (stream != null) {
                stream.close();
            }
            sw.stop();
            System.out.println("Parsing: " + sw);
        }
        this.pathsInCreationOrder = new LinkedList(this.output.getOrderOfCreation());
    }
}

