/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.xml;

import java.io.InputStream;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.graph.JcrNtLexicon;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencer;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.xml.XmlSequencerHandler;
import org.modeshape.sequencer.xml.XmlSequencerI18n;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlSequencer
implements StreamSequencer {
    static final String DEFAULT_PRIMARY_TYPE = "nt:unstructured";
    static final String DECL_HANDLER_FEATURE = "http://xml.org/sax/properties/declaration-handler";
    static final String ENTITY_RESOLVER_2_FEATURE = "http://xml.org/sax/features/use-entity-resolver2";
    static final String LEXICAL_HANDLER_FEATURE = "http://xml.org/sax/properties/lexical-handler";
    static final String RESOLVE_DTD_URIS_FEATURE = "http://xml.org/sax/features/resolve-dtd-uris";
    static final String LOAD_EXTERNAL_DTDS_FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private AttributeScoping scoping = AttributeScoping.USE_DEFAULT_NAMESPACE;

    public void setAttributeScoping(AttributeScoping scoping) {
        this.scoping = scoping;
    }

    public AttributeScoping getAttributeScoping() {
        return this.scoping;
    }

    public void sequence(InputStream stream, SequencerOutput output, StreamSequencerContext context) {
        try {
            Name primaryType = JcrNtLexicon.UNSTRUCTURED;
            Name nameAttribute = null;
            TextDecoder decoder = null;
            XmlSequencerHandler handler = new XmlSequencerHandler(output, context, nameAttribute, primaryType, decoder, this.scoping);
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(handler);
            reader.setErrorHandler(handler);
            reader.setProperty(DECL_HANDLER_FEATURE, handler);
            reader.setProperty(LEXICAL_HANDLER_FEATURE, handler);
            XmlSequencer.setFeature(reader, ENTITY_RESOLVER_2_FEATURE, true);
            XmlSequencer.setFeature(reader, LOAD_EXTERNAL_DTDS_FEATURE, false);
            XmlSequencer.setFeature(reader, RESOLVE_DTD_URIS_FEATURE, false);
            reader.parse(new InputSource(stream));
            if (context.getProblems().hasProblems()) {
                System.out.println(context.getProblems());
            }
        }
        catch (Exception error) {
            context.getLogger(this.getClass()).error((Throwable)error, XmlSequencerI18n.fatalErrorSequencingXmlDocument, new Object[]{error});
            context.getProblems().addError((Throwable)error, XmlSequencerI18n.fatalErrorSequencingXmlDocument, new Object[]{error});
            error.printStackTrace();
        }
    }

    static void setFeature(XMLReader reader, String featureName, boolean value) {
        try {
            if (reader.getFeature(featureName) != value) {
                reader.setFeature(featureName, value);
            }
        }
        catch (SAXNotRecognizedException meansFeatureNotRecognized) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
    }

    public static enum AttributeScoping {
        USE_DEFAULT_NAMESPACE,
        INHERIT_ELEMENT_NAMESPACE;

    }
}

