/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.xml;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.junit.Assert;
import org.modeshape.jcr.sequencer.AbstractSequencerTest;

public abstract class AbstractXmlSequencerTest
extends AbstractSequencerTest {
    protected Node sequenceAndAssertDocument(String documentFilename) throws Exception {
        this.createNodeWithContentFromFile(documentFilename, documentFilename);
        Node document = this.getOutputNode(this.rootNode, "xml/" + documentFilename);
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((Object)"modexml:document", (Object)document.getPrimaryNodeType().getName());
        return document;
    }

    protected Node assertElement(Node document, String elementRelativePath, String ... propertyNameValuePairs) throws RepositoryException {
        return this.assertNode(document, elementRelativePath, "modexml:element", propertyNameValuePairs);
    }

    protected Node assertNode(Node rootNode, String relativePath, String expectedType, String ... propertyNameValuePairs) throws RepositoryException {
        Node node = rootNode.getNode(relativePath);
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)expectedType, (Object)node.getPrimaryNodeType().getName());
        for (String nameValuePair : propertyNameValuePairs) {
            String[] elements = nameValuePair.split("=", 2);
            Assert.assertEquals((long)2L, (long)elements.length);
            String expectedName = elements[0];
            String expectedValue = elements[1];
            Property elementProperty = node.getProperty(expectedName);
            Assert.assertNotNull((String)"Property not found", (Object)elementProperty);
            Assert.assertEquals((Object)expectedValue, (Object)elementProperty.getString());
        }
        return node;
    }
}

