/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.xml.XmlSequencerHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlSequencer
extends Sequencer {
    static final String DECL_HANDLER_FEATURE = "http://xml.org/sax/properties/declaration-handler";
    static final String ENTITY_RESOLVER_2_FEATURE = "http://xml.org/sax/features/use-entity-resolver2";
    static final String LEXICAL_HANDLER_FEATURE = "http://xml.org/sax/properties/lexical-handler";
    static final String RESOLVE_DTD_URIS_FEATURE = "http://xml.org/sax/features/resolve-dtd-uris";
    static final String LOAD_EXTERNAL_DTDS_FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private AttributeScoping scoping = AttributeScoping.USE_DEFAULT_NAMESPACE;

    protected void setAttributeScoping(AttributeScoping scoping) {
        this.scoping = scoping;
    }

    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        super.registerNodeTypes("xml.cnd", nodeTypeManager, true);
        this.registerDefaultMimeTypes(new String[]{"application/xml", "text/xml", "application/xhtml+xml", "application/xop+xml", "application/xslt+xml", "application/xsfp+xml", "application/xv+xml"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        Binary binaryValue = inputProperty.getBinary();
        CheckArg.isNotNull((Object)binaryValue, (String)"binary");
        if (!outputNode.isNew()) {
            outputNode = outputNode.addNode("modexml:document");
        }
        XmlSequencerHandler sequencingHandler = new XmlSequencerHandler(outputNode, this.scoping);
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setContentHandler(sequencingHandler);
        reader.setErrorHandler(sequencingHandler);
        reader.setProperty(DECL_HANDLER_FEATURE, sequencingHandler);
        reader.setProperty(LEXICAL_HANDLER_FEATURE, sequencingHandler);
        this.setFeature(reader, ENTITY_RESOLVER_2_FEATURE, true);
        this.setFeature(reader, LOAD_EXTERNAL_DTDS_FEATURE, false);
        this.setFeature(reader, RESOLVE_DTD_URIS_FEATURE, false);
        InputStream stream = binaryValue.getStream();
        try {
            reader.parse(new InputSource(stream));
        }
        finally {
            stream.close();
        }
        return true;
    }

    void setFeature(XMLReader reader, String featureName, boolean value) {
        try {
            if (reader.getFeature(featureName) != value) {
                reader.setFeature(featureName, value);
            }
        }
        catch (SAXException e) {
            this.getLogger().warn((Throwable)e, "Cannot set feature " + featureName, new Object[0]);
        }
    }

    public static enum AttributeScoping {
        USE_DEFAULT_NAMESPACE,
        INHERIT_ELEMENT_NAMESPACE;

    }

    public static final class MimeTypeConstants {
        public static final String WSDL = "application/wsdl+xml";
        public static final String APPLICATION_XML = "application/xml";
        public static final String TEXT_XML = "text/xml";
        public static final String HTML_XML = "application/xhtml+xml";
        public static final String XOP_XML = "application/xop+xml";
        public static final String XSLT = "application/xslt+xml";
        public static final String XSFP = "application/xsfp+xml";
        public static final String MXML = "application/xv+xml";
    }
}

